/*
 * Decompiled with CFR 0.152.
 */
package tr.com.obss.plugin.extra.flyingpdf.gatekeeper;

import com.atlassian.confluence.util.GeneralUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tr.com.obss.plugin.Confluence7And8GateKeeper;
import tr.com.obss.plugin.Confluence9GateKeeper;
import tr.com.obss.plugin.VersionSpecificGateKeeper;

public class VersionSpecificGateKeeperFactory {
    private static final Logger logger = LoggerFactory.getLogger(VersionSpecificGateKeeperFactory.class);

    public static VersionSpecificGateKeeper getGateKeeper(String confluenceVersion) {
        logger.debug("Detected Confluence version: {}", (Object)confluenceVersion);
        if (confluenceVersion == null) {
            logger.error("Cannot determine Confluence version. Confluence Version is null");
            return null;
        }
        if (GeneralUtil.getVersionNumber().startsWith("9")) {
            logger.debug("Using Confluence9GateKeeper()");
            return new Confluence9GateKeeper();
        }
        if (GeneralUtil.getVersionNumber().startsWith("7") || GeneralUtil.getVersionNumber().startsWith("8")) {
            logger.debug("Using Confluence7And8GateKeeper()");
            return new Confluence7And8GateKeeper();
        }
        return null;
    }
}

