/*
 * Decompiled with CFR 0.152.
 */
package tr.com.obss.plugin.database;

import java.util.ArrayList;
import java.util.List;
import tr.com.obss.plugin.dto.BaselineDocumentTypeQuery;

public class StoragePaging {
    private final List<Integer> partsToFetch;
    private final int startIndexInFirstPart;
    private final int endIndexInLastPart;

    public StoragePaging(int pageNumber, int pageSize, BaselineDocumentTypeQuery documentType, int[] pagesPerPart, int[] attachmentsPerPart, int storedPageSize) {
        if (pagesPerPart.length != attachmentsPerPart.length) {
            throw new IllegalArgumentException("pagesPerPart and attachmentsPerPart arrays should have the same length.");
        }
        int totalParts = pagesPerPart.length;
        pageSize = Math.min(pageSize, totalParts * storedPageSize);
        int startIndex = (pageNumber - 1) * pageSize;
        int endIndex = startIndex + pageSize - 1;
        int checkedDocumentCount = 0;
        boolean enteredBetweenStartAndEnd = false;
        this.partsToFetch = new ArrayList<Integer>();
        int tempStartIndexInFirstPart = 0;
        int tempEndIndexInLastPart = 0;
        for (int i = 0; i < totalParts; ++i) {
            int pageCount = pagesPerPart[i];
            int attachmentCount = attachmentsPerPart[i];
            int partSize = 0;
            if (documentType == BaselineDocumentTypeQuery.ANY_DOCUMENT) {
                partSize = pageCount + attachmentCount;
            } else if (documentType == BaselineDocumentTypeQuery.PAGE) {
                partSize = pageCount;
            } else if (documentType == BaselineDocumentTypeQuery.ATTACHMENT) {
                partSize = attachmentCount;
            }
            if (checkedDocumentCount + partSize > startIndex && partSize > 0) {
                this.partsToFetch.add(i + 1);
                if (!enteredBetweenStartAndEnd) {
                    tempStartIndexInFirstPart = startIndex - checkedDocumentCount;
                    enteredBetweenStartAndEnd = true;
                }
                if (checkedDocumentCount + partSize >= endIndex) {
                    tempEndIndexInLastPart = endIndex - checkedDocumentCount;
                    break;
                }
                if (i == totalParts - 1) {
                    tempEndIndexInLastPart = partSize - 1;
                }
            }
            checkedDocumentCount += partSize;
        }
        this.startIndexInFirstPart = tempStartIndexInFirstPart;
        this.endIndexInLastPart = tempEndIndexInLastPart;
    }

    public List<Integer> getPartsToFetch() {
        return this.partsToFetch;
    }

    public int getStartIndexInFirstPart() {
        return this.startIndexInFirstPart;
    }

    public int getEndIndexInLastPart() {
        return this.endIndexInLastPart;
    }
}

