/*
 * Decompiled with CFR 0.152.
 */
package tr.com.obss.plugin.database;

import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.setup.bandana.ConfluenceBandanaContext;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tr.com.obss.plugin.baseline.request.BaselineCreateRequest;
import tr.com.obss.plugin.database.BaselineDatabaseManager;
import tr.com.obss.plugin.database.StoragePaging;
import tr.com.obss.plugin.dto.Baseline;
import tr.com.obss.plugin.dto.BaselineAttachment;
import tr.com.obss.plugin.dto.BaselineDocument;
import tr.com.obss.plugin.dto.BaselineDocumentType;
import tr.com.obss.plugin.dto.BaselineDocumentTypeQuery;
import tr.com.obss.plugin.dto.BaselinePage;
import tr.com.obss.plugin.dto.BaselineSummary;
import tr.com.obss.plugin.dto.impl.BaselineAttachmentImpl;
import tr.com.obss.plugin.dto.impl.BaselineImpl;
import tr.com.obss.plugin.dto.impl.BaselinePageImpl;
import tr.com.obss.plugin.dto.impl.BaselineSummaryImpl;
import tr.com.obss.plugin.info.InfoService;
import tr.com.obss.plugin.pojo.AttachmentPOJO;
import tr.com.obss.plugin.pojo.BaseLinePOJO;
import tr.com.obss.plugin.pojo.Document;
import tr.com.obss.plugin.pojo.PagePOJO;
import tr.com.obss.plugin.pojo.v2.AttachmentPOJOv2;
import tr.com.obss.plugin.pojo.v2.BaseLinePOJOv2;
import tr.com.obss.plugin.pojo.v2.DocumentV2;
import tr.com.obss.plugin.pojo.v2.PagePOJOv2;
import tr.com.obss.plugin.utils.CompressUtils;
import tr.com.obss.plugin.utils.ListUtils;

public class BaselineBandanaDatabaseManager
implements BaselineDatabaseManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaselineBandanaDatabaseManager.class);
    private static final int MAX_BANDANA_KEY_LENGTH = 100;
    private static final String BASELINE_KEY_PREFIX = "baseline-";
    private static final String CONTENT_KEY_PREFIX = "bslcontent-";
    private static final String CREATE_REQUEST_KEY_PREFIX = "bslrequest-";
    private static final String BASELINE_KEY_DELIMITER = "!,.,!";
    private final BandanaManager bandanaManager;
    private final TransactionTemplate transactionTemplate;
    private final InfoService infoService;
    private final ObjectMapper objectMapper;

    public BaselineBandanaDatabaseManager(BandanaManager bandanaManager, TransactionTemplate transactionTemplate, InfoService infoService) {
        this.bandanaManager = bandanaManager;
        this.transactionTemplate = transactionTemplate;
        this.infoService = infoService;
        this.objectMapper = new ObjectMapper();
    }

    @Override
    @Nonnull
    public List<String> getAllBaselineNames(@Nonnull Space space) {
        Iterable bandanaKeys = this.bandanaManager.getKeys(BaselineBandanaDatabaseManager.getContext(space));
        ArrayList<String> baselineNames = new ArrayList<String>();
        for (String bandanaKey : bandanaKeys) {
            if (!bandanaKey.startsWith(BASELINE_KEY_PREFIX)) continue;
            baselineNames.add(BaselineBandanaDatabaseManager.convertToBaselineName(bandanaKey));
        }
        return baselineNames;
    }

    @Override
    @Nullable
    public Baseline getBaseline(@Nonnull Space space, @Nonnull String baselineName, int pageNumber, int pageSize, @Nonnull BaselineDocumentTypeQuery documentType) {
        BaseLinePOJO baseLinePOJO = this.getBaselinePOJO(space, baselineName, false);
        if (baseLinePOJO == null) {
            return null;
        }
        if (baseLinePOJO instanceof BaseLinePOJOv2) {
            List<DocumentV2> documentPOJOs = this.getDocumentPojoV2List(space, (BaseLinePOJOv2)baseLinePOJO, pageNumber, pageSize, documentType);
            return this.pojoV2ToDto((BaseLinePOJOv2)baseLinePOJO, documentPOJOs);
        }
        return this.pojoV1ToDto(baseLinePOJO);
    }

    @Override
    @Nonnull
    public List<BaselineSummary> getBaselineSummaries(@Nonnull Space space) {
        List<String> allBaselineNames = this.getAllBaselineNames(space);
        ArrayList<BaselineSummary> baselineSummaries = new ArrayList<BaselineSummary>();
        for (String baselineName : allBaselineNames) {
            BaseLinePOJO baseLinePOJO = this.getBaselinePOJO(space, baselineName, true);
            if (baseLinePOJO == null) continue;
            BaselineSummaryImpl baselineSummary = new BaselineSummaryImpl(baseLinePOJO.getName(), baseLinePOJO.getBaselineDate(), baseLinePOJO.getCreateDate());
            baselineSummaries.add(baselineSummary);
        }
        return baselineSummaries;
    }

    private BaseLinePOJO getBaselinePOJO(Space space, String baselineName, boolean justSummary) {
        Object baselineAsObject = this.bandanaManager.getValue(BaselineBandanaDatabaseManager.getContext(space), BaselineBandanaDatabaseManager.generateBaselineBandanaKey(baselineName));
        if (baselineAsObject == null) {
            return null;
        }
        BaseLinePOJO baseLinePOJO = null;
        try {
            if (justSummary) {
                BaseLinePOJO fullBaselinePojo = (BaseLinePOJO)baselineAsObject;
                baseLinePOJO = new BaseLinePOJO();
                baseLinePOJO.setName(fullBaselinePojo.getName());
                baseLinePOJO.setBaselineDate(fullBaselinePojo.getBaselineDate());
                baseLinePOJO.setCreateDate(fullBaselinePojo.getCreateDate());
            } else {
                baseLinePOJO = (BaseLinePOJO)baselineAsObject;
            }
        }
        catch (ClassCastException e) {
            LOGGER.warn("Baseline could not be retrieved from database via the regular method. Trying secondary method. Please restart your Confluence system in order to solve this problem.");
            baseLinePOJO = this.getBaselinePojoViaReflection(baselineAsObject, justSummary);
        }
        if (baseLinePOJO != null && (baseLinePOJO.getName() == null || "".equals(baseLinePOJO.getName().trim()))) {
            baseLinePOJO.setName(baselineName);
        }
        return baseLinePOJO;
    }

    private BaseLinePOJO getBaselinePojoViaReflection(Object baselineAsObject, boolean justSummary) {
        try {
            boolean isV2 = BaseLinePOJOv2.class.getName().equals(baselineAsObject.getClass().getName());
            BaseLinePOJO baseLinePOJO = isV2 ? new BaseLinePOJOv2() : new BaseLinePOJO();
            Class<?> baselineObjectClass = baselineAsObject.getClass();
            baseLinePOJO.setName((String)baselineObjectClass.getMethod("getName", new Class[0]).invoke(baselineAsObject, new Object[0]));
            baseLinePOJO.setBaselineDate((Date)baselineObjectClass.getMethod("getBaselineDate", new Class[0]).invoke(baselineAsObject, new Object[0]));
            baseLinePOJO.setCreateDate((Date)baselineObjectClass.getMethod("getCreateDate", new Class[0]).invoke(baselineAsObject, new Object[0]));
            if (justSummary) {
                return baseLinePOJO;
            }
            baseLinePOJO.setCreator((String)baselineObjectClass.getMethod("getCreator", new Class[0]).invoke(baselineAsObject, new Object[0]));
            baseLinePOJO.setBaselineKey((String)baselineObjectClass.getMethod("getBaselineKey", new Class[0]).invoke(baselineAsObject, new Object[0]));
            baseLinePOJO.setSpace((String)baselineObjectClass.getMethod("getSpace", new Class[0]).invoke(baselineAsObject, new Object[0]));
            if (isV2) {
                ((BaseLinePOJOv2)baseLinePOJO).setTotalContentParts((Integer)baselineObjectClass.getMethod("getTotalContentParts", new Class[0]).invoke(baselineAsObject, new Object[0]));
                ((BaseLinePOJOv2)baseLinePOJO).setContentPageSize((Integer)baselineObjectClass.getMethod("getContentPageSize", new Class[0]).invoke(baselineAsObject, new Object[0]));
                ((BaseLinePOJOv2)baseLinePOJO).setPageCount((Integer)baselineObjectClass.getMethod("getPageCount", new Class[0]).invoke(baselineAsObject, new Object[0]));
                ((BaseLinePOJOv2)baseLinePOJO).setAttachmentCount((Integer)baselineObjectClass.getMethod("getAttachmentCount", new Class[0]).invoke(baselineAsObject, new Object[0]));
                ((BaseLinePOJOv2)baseLinePOJO).setPagesPerPart((int[])baselineObjectClass.getMethod("getPagesPerPart", new Class[0]).invoke(baselineAsObject, new Object[0]));
                ((BaseLinePOJOv2)baseLinePOJO).setAttachmentsPerPart((int[])baselineObjectClass.getMethod("getAttachmentsPerPart", new Class[0]).invoke(baselineAsObject, new Object[0]));
                return baseLinePOJO;
            }
            List pageObjects = (List)baselineObjectClass.getMethod("getPages", new Class[0]).invoke(baselineAsObject, new Object[0]);
            if (pageObjects == null) {
                return baseLinePOJO;
            }
            ArrayList<PagePOJO> baselinePages = new ArrayList<PagePOJO>();
            for (Object pageAsObject : pageObjects) {
                PagePOJO pagePOJO = new PagePOJO();
                Class<?> pageObjectClass = pageAsObject.getClass();
                pagePOJO.setVersion((String)pageObjectClass.getMethod("getVersion", new Class[0]).invoke(pageAsObject, new Object[0]));
                pagePOJO.setUrl((String)pageObjectClass.getMethod("getUrl", new Class[0]).invoke(pageAsObject, new Object[0]));
                pagePOJO.setType((String)pageObjectClass.getMethod("getType", new Class[0]).invoke(pageAsObject, new Object[0]));
                pagePOJO.setTitle((String)pageObjectClass.getMethod("getTitle", new Class[0]).invoke(pageAsObject, new Object[0]));
                pagePOJO.setPagePath((String)pageObjectClass.getMethod("getPagePath", new Class[0]).invoke(pageAsObject, new Object[0]));
                pagePOJO.setPageId((String)pageObjectClass.getMethod("getPageId", new Class[0]).invoke(pageAsObject, new Object[0]));
                pagePOJO.setCreationDate((Date)pageObjectClass.getMethod("getCreationDate", new Class[0]).invoke(pageAsObject, new Object[0]));
                List<Object> attachmentObjects = this.getAttachmentObjectsViaReflection(pageObjectClass, pageAsObject, pagePOJO.getPageId());
                if (attachmentObjects != null) {
                    ArrayList<AttachmentPOJO> baselineAttachments = new ArrayList<AttachmentPOJO>();
                    for (Object attachmentAsObject : attachmentObjects) {
                        AttachmentPOJO attachmentPOJO = new AttachmentPOJO();
                        Class<?> attachmentObjectClass = attachmentAsObject.getClass();
                        attachmentPOJO.setVersion((String)attachmentObjectClass.getMethod("getVersion", new Class[0]).invoke(attachmentAsObject, new Object[0]));
                        attachmentPOJO.setUrl((String)attachmentObjectClass.getMethod("getUrl", new Class[0]).invoke(attachmentAsObject, new Object[0]));
                        attachmentPOJO.setType((String)attachmentObjectClass.getMethod("getType", new Class[0]).invoke(attachmentAsObject, new Object[0]));
                        attachmentPOJO.setTitle((String)attachmentObjectClass.getMethod("getTitle", new Class[0]).invoke(attachmentAsObject, new Object[0]));
                        attachmentPOJO.setPagePath((String)attachmentObjectClass.getMethod("getPagePath", new Class[0]).invoke(attachmentAsObject, new Object[0]));
                        attachmentPOJO.setId((String)attachmentObjectClass.getMethod("getId", new Class[0]).invoke(attachmentAsObject, new Object[0]));
                        attachmentPOJO.setCreationDate((Date)attachmentObjectClass.getMethod("getCreationDate", new Class[0]).invoke(attachmentAsObject, new Object[0]));
                        attachmentPOJO.setParentPage(pagePOJO);
                        baselineAttachments.add(attachmentPOJO);
                    }
                    pagePOJO.setAttachments(baselineAttachments);
                }
                baselinePages.add(pagePOJO);
            }
            baseLinePOJO.setPages(baselinePages);
            return baseLinePOJO;
        }
        catch (Exception e) {
            LOGGER.error("Could not retrieve baseline using reflection.", (Throwable)e);
            return null;
        }
    }

    private List<Object> getAttachmentObjectsViaReflection(Class<?> pageObjectClass, Object pageAsObject, String pageId) {
        List attachments = null;
        try {
            attachments = (List)pageObjectClass.getMethod("getAttachments", new Class[0]).invoke(pageAsObject, new Object[0]);
        }
        catch (NoSuchMethodException e) {
            LOGGER.debug("No attachments for page id: " + pageId + " found in baseline.", (Throwable)e);
        }
        catch (Exception e) {
            LOGGER.error("An error other than NoSuchMethodException was thrown.", (Throwable)e);
        }
        return attachments;
    }

    List<DocumentV2> getDocumentPojoV2List(Space space, BaseLinePOJOv2 baseline, int pageNumber, int pageSize, BaselineDocumentTypeQuery documentType) {
        StoragePaging storagePaging = new StoragePaging(pageNumber, pageSize, documentType, baseline.getPagesPerPart(), baseline.getAttachmentsPerPart(), baseline.getContentPageSize());
        ArrayList<DocumentV2> documents = new ArrayList<DocumentV2>();
        List<Integer> partsToFetch = storagePaging.getPartsToFetch();
        for (int i = 0; i < partsToFetch.size(); ++i) {
            int partNo = partsToFetch.get(i);
            List<DocumentV2> contentPart = this.getContentPart(space, baseline, partNo);
            if (documentType == BaselineDocumentTypeQuery.PAGE) {
                contentPart = contentPart.stream().filter(doc -> "page".equals(doc.getType())).collect(Collectors.toList());
            } else if (documentType == BaselineDocumentTypeQuery.ATTACHMENT) {
                contentPart = contentPart.stream().filter(doc -> "attachment".equals(doc.getType())).collect(Collectors.toList());
            }
            int startIndex = i == 0 ? storagePaging.getStartIndexInFirstPart() : 0;
            int endIndex = i == partsToFetch.size() - 1 ? storagePaging.getEndIndexInLastPart() + 1 : contentPart.size();
            documents.addAll(contentPart.subList(startIndex, endIndex));
        }
        return documents;
    }

    private List<DocumentV2> getContentPart(Space space, BaseLinePOJOv2 baseline, int partNo) {
        String key;
        BandanaContext context = BaselineBandanaDatabaseManager.getContext(space);
        Object contentPartAsObject = this.bandanaManager.getValue(context, key = BaselineBandanaDatabaseManager.generateContentBandanaKey(baseline.getName(), partNo, baseline.getTotalContentParts()));
        if (contentPartAsObject == null) {
            return new ArrayList<DocumentV2>();
        }
        String contentJsonString = contentPartAsObject instanceof byte[] ? CompressUtils.decompress((byte[])contentPartAsObject) : (String)contentPartAsObject;
        return this.fromJsonString(contentJsonString, new TypeReference<List<DocumentV2>>(){});
    }

    private Baseline pojoV1ToDto(BaseLinePOJO baseLinePOJO) {
        ArrayList<BaselineDocument> baselineDocuments = new ArrayList<BaselineDocument>();
        for (PagePOJO pagePOJO : baseLinePOJO.getPages()) {
            ArrayList<BaselineAttachment> baselineAttachments = new ArrayList<BaselineAttachment>();
            List<AttachmentPOJO> pagePojoAttachments = pagePOJO.getAttachments();
            if (pagePojoAttachments == null) {
                pagePojoAttachments = new ArrayList<AttachmentPOJO>();
            }
            for (AttachmentPOJO attachmentPOJO : pagePojoAttachments) {
                BaselineAttachmentImpl baselineAttachment = new BaselineAttachmentImpl(attachmentPOJO.getId(), attachmentPOJO.getTitle(), attachmentPOJO.getPagePath(), attachmentPOJO.getVersion(), attachmentPOJO.getUrl(), attachmentPOJO.getCreationDate(), attachmentPOJO.getParentPage().getPageId());
                baselineAttachments.add(baselineAttachment);
            }
            BaselinePageImpl baselinePage = new BaselinePageImpl(pagePOJO.getPageId(), pagePOJO.getTitle(), pagePOJO.getPagePath(), pagePOJO.getVersion(), pagePOJO.getUrl(), pagePOJO.getCreationDate(), baselineAttachments);
            baselineDocuments.add(baselinePage);
            baselineDocuments.addAll(baselineAttachments);
        }
        return new BaselineImpl(baseLinePOJO.getName(), baseLinePOJO.getCreateDate(), baseLinePOJO.getBaselineDate(), baseLinePOJO.getSpace(), baseLinePOJO.getCreator(), baseLinePOJO.getBaselineKey(), baselineDocuments);
    }

    private Baseline pojoV2ToDto(BaseLinePOJOv2 baseLinePOJO, List<DocumentV2> documentPOJOs) {
        ArrayList<BaselineDocument> baselineDocuments = new ArrayList<BaselineDocument>();
        ArrayList<BaselineAttachment> currentPageAttachments = new ArrayList<BaselineAttachment>();
        for (DocumentV2 document : documentPOJOs) {
            if (document instanceof PagePOJOv2) {
                PagePOJOv2 pagePOJO = (PagePOJOv2)document;
                currentPageAttachments = new ArrayList();
                baselineDocuments.add(new BaselinePageImpl(pagePOJO.getId(), pagePOJO.getTitle(), pagePOJO.getPagePath(), pagePOJO.getVersion(), pagePOJO.getUrl(), pagePOJO.getCreationDate(), currentPageAttachments));
                continue;
            }
            AttachmentPOJOv2 attachmentPOJO = (AttachmentPOJOv2)document;
            BaselineAttachmentImpl attachment = new BaselineAttachmentImpl(attachmentPOJO.getId(), attachmentPOJO.getTitle(), attachmentPOJO.getPagePath(), attachmentPOJO.getVersion(), attachmentPOJO.getUrl(), attachmentPOJO.getCreationDate(), attachmentPOJO.getPageId());
            currentPageAttachments.add(attachment);
            baselineDocuments.add(attachment);
        }
        return new BaselineImpl(baseLinePOJO.getName(), baseLinePOJO.getCreateDate(), baseLinePOJO.getBaselineDate(), baseLinePOJO.getSpace(), baseLinePOJO.getCreator(), baseLinePOJO.getBaselineKey(), baseLinePOJO.getPageCount(), baseLinePOJO.getAttachmentCount(), baselineDocuments);
    }

    @Override
    public void deleteBaseline(@Nonnull Space space, @Nonnull String baselineName) {
        this.transactionTemplate.execute(() -> {
            BandanaContext context = BaselineBandanaDatabaseManager.getContext(space);
            this.bandanaManager.removeValue(context, BaselineBandanaDatabaseManager.generateBaselineBandanaKey(baselineName));
            this.bandanaManager.removeValue(context, BaselineBandanaDatabaseManager.generateCreateRequestBandanaKey(baselineName));
            Iterable bandanaKeys = this.bandanaManager.getKeys(context);
            String prefix = BaselineBandanaDatabaseManager.generateContentBandanaKeyWithoutPartNo(baselineName);
            for (String bandanaKey : bandanaKeys) {
                if (!bandanaKey.startsWith(prefix)) continue;
                this.bandanaManager.removeValue(context, bandanaKey);
            }
            return null;
        });
    }

    @Override
    public void persistBaseline(@Nonnull Space space, @Nonnull Baseline baseline, @Nonnull BaselineCreateRequest createRequest) {
        BaseLinePOJOv2 baselinePOJO = BaselineBandanaDatabaseManager.dtoToPojo(baseline);
        int contentPageSize = this.infoService.getBaselineContentPageSize();
        List<List<Document>> contentParts = ListUtils.partition(BaselineBandanaDatabaseManager.dtoToDocumentPojoV2List(baseline), contentPageSize);
        int totalContentParts = contentParts.size();
        baselinePOJO.setTotalContentParts(totalContentParts);
        baselinePOJO.setContentPageSize(contentPageSize);
        baselinePOJO.setPageCount(baseline.getTotalPageCount());
        baselinePOJO.setAttachmentCount(baseline.getTotalAttachmentCount());
        int[] pagesPerPart = new int[totalContentParts];
        int[] attachmentsPerPart = new int[totalContentParts];
        for (int i = 0; i < totalContentParts; ++i) {
            List<Document> part = contentParts.get(i);
            pagesPerPart[i] = (int)part.stream().filter(doc -> "page".equals(doc.getType())).count();
            attachmentsPerPart[i] = (int)part.stream().filter(doc -> "attachment".equals(doc.getType())).count();
        }
        baselinePOJO.setPagesPerPart(pagesPerPart);
        baselinePOJO.setAttachmentsPerPart(attachmentsPerPart);
        BandanaContext context = BaselineBandanaDatabaseManager.getContext(space);
        boolean compressContent = this.infoService.compressBaselineContent();
        this.transactionTemplate.execute(() -> {
            this.bandanaManager.setValue(context, BaselineBandanaDatabaseManager.generateBaselineBandanaKey(baselinePOJO.getName()), (Object)baselinePOJO);
            this.bandanaManager.setValue(context, BaselineBandanaDatabaseManager.generateCreateRequestBandanaKey(baselinePOJO.getName()), (Object)this.toJsonString(createRequest));
            int partNo = 0;
            while (partNo < totalContentParts) {
                String contentJsonString = this.toJsonString(contentParts.get(++partNo - 1));
                this.bandanaManager.setValue(context, BaselineBandanaDatabaseManager.generateContentBandanaKey(baselinePOJO.getName(), partNo, totalContentParts), compressContent ? (Object)CompressUtils.compress(contentJsonString) : contentJsonString);
            }
            return null;
        });
    }

    @Override
    public boolean isBaselineNameTooLong(@Nonnull String baselineName) {
        String baselineKey = BaselineBandanaDatabaseManager.generateBaselineBandanaKey(baselineName);
        String contentKey = BaselineBandanaDatabaseManager.generateContentBandanaKey(baselineName, 1, 9999);
        String requestKey = BaselineBandanaDatabaseManager.generateCreateRequestBandanaKey(baselineName);
        return baselineKey.length() > 100 || contentKey.length() > 100 || requestKey.length() > 100;
    }

    private static BandanaContext getContext(Space space) {
        return new ConfluenceBandanaContext(space);
    }

    private static String generateBaselineBandanaKey(String baselineName) {
        return BASELINE_KEY_PREFIX + baselineName.replace(" ", BASELINE_KEY_DELIMITER);
    }

    private static String generateContentBandanaKeyWithoutPartNo(String baselineName) {
        return CONTENT_KEY_PREFIX + baselineName.replace(" ", BASELINE_KEY_DELIMITER);
    }

    private static String generateContentBandanaKey(String baselineName, int partNo, int totalParts) {
        return BaselineBandanaDatabaseManager.generateContentBandanaKeyWithoutPartNo(baselineName) + "-" + BaselineBandanaDatabaseManager.generatePartNumber(partNo, totalParts);
    }

    private static String generateCreateRequestBandanaKey(String baselineName) {
        return CREATE_REQUEST_KEY_PREFIX + baselineName.replace(" ", BASELINE_KEY_DELIMITER);
    }

    private static String convertToBaselineName(String bandanaKey) {
        return bandanaKey.replaceFirst(BASELINE_KEY_PREFIX, "").replace(BASELINE_KEY_DELIMITER, " ");
    }

    private static BaseLinePOJOv2 dtoToPojo(Baseline baseline) {
        BaseLinePOJOv2 baseLinePOJO = new BaseLinePOJOv2();
        baseLinePOJO.setCreateDate(baseline.getCreationDate());
        baseLinePOJO.setBaselineDate(baseline.getBaselineDate());
        baseLinePOJO.setSpace(baseline.getSpaceKey());
        baseLinePOJO.setCreator(baseline.getCreator());
        baseLinePOJO.setName(baseline.getName());
        baseLinePOJO.setBaselineKey(baseline.getKeyword());
        return baseLinePOJO;
    }

    private static List<Document> dtoToDocumentPojoV2List(Baseline baseline) {
        List<BaselineDocument> baselineDocuments = baseline.getAllDocuments();
        ArrayList<Document> documents = new ArrayList<Document>();
        for (BaselineDocument baselineDocument : baselineDocuments) {
            if (baselineDocument.getType() == BaselineDocumentType.PAGE) {
                BaselinePage baselinePage = (BaselinePage)baselineDocument;
                PagePOJOv2 pagePOJOv2 = new PagePOJOv2(baselinePage.getTitle(), baselinePage.getPath(), baselinePage.getVersion(), baselinePage.getUrl(), baselinePage.getCreationDate(), baselinePage.getId());
                documents.add(pagePOJOv2);
                continue;
            }
            BaselineAttachment baselineAttachment = (BaselineAttachment)baselineDocument;
            AttachmentPOJOv2 attachmentPOJOv2 = new AttachmentPOJOv2(baselineAttachment.getTitle(), baselineAttachment.getPath(), baselineAttachment.getVersion(), baselineAttachment.getUrl(), baselineAttachment.getCreationDate(), baselineAttachment.getId(), baselineAttachment.getPageId());
            documents.add(attachmentPOJOv2);
        }
        return documents;
    }

    private static String generatePartNumber(int part, int totalParts) {
        int totalDigits = String.valueOf(totalParts).length();
        String format = "%0" + totalDigits + "d";
        return String.format(format, part);
    }

    private String toJsonString(Object object) {
        try {
            return this.objectMapper.writeValueAsString(object);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private <T> T fromJsonString(String jsonString, TypeReference<T> typeReference) {
        try {
            return this.objectMapper.readValue(jsonString, typeReference);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

