/*
 * Decompiled with CFR 0.152.
 */
package tr.com.obss.plugin.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CompressUtils {
    private static final Logger log = LoggerFactory.getLogger(CompressUtils.class);

    private CompressUtils() {
        throw new UnsupportedOperationException("Utility class");
    }

    public static byte[] compress(String data) {
        if (StringUtils.isBlank((CharSequence)data)) {
            return new byte[0];
        }
        byte[] body = data.getBytes(StandardCharsets.UTF_8);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (GZIPOutputStream gzipOutputStream = new GZIPOutputStream(baos);){
            gzipOutputStream.write(body);
        }
        catch (Exception e) {
            log.error("Error occurred trying to compress data", (Throwable)e);
        }
        return baos.toByteArray();
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static String decompress(byte[] compressedData) {
        if (compressedData == null || compressedData.length == 0) {
            return null;
        }
        if (CompressUtils.isCompressed(compressedData)) {
            try (ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(compressedData);){
                String string;
                try (GZIPInputStream gzipInputStream = new GZIPInputStream(byteArrayInputStream);){
                    byte[] decompressedArr = IOUtils.toByteArray((InputStream)gzipInputStream);
                    string = new String(decompressedArr, StandardCharsets.UTF_8);
                }
                return string;
            }
            catch (Exception e) {
                log.error("Error occurred trying to decompress data", (Throwable)e);
                return null;
            }
        }
        return new String(compressedData, StandardCharsets.UTF_8);
    }

    public static boolean isCompressed(byte[] compressed) {
        if (Objects.nonNull(compressed) && compressed.length > 1) {
            return compressed[0] == 31 && compressed[1] == -117;
        }
        return false;
    }
}

