/*
 * Decompiled with CFR 0.152.
 */
package tr.com.obss.plugin.extra.flyingpdf;

import com.lowagie.text.Image;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.image.ImageTranscoder;
import org.apache.batik.transcoder.image.PNGTranscoder;
import tr.com.obss.plugin.extra.flyingpdf.LightITextFSImage;
import tr.com.obss.plugin.extra.flyingpdf.util.ImageFileCacheUtils;
import tr.com.obss.plugin.extra.flyingpdf.util.ImageInformation;
import tr.com.obss.plugin.extra.flyingpdf.util.ImageInformationURICacheUtil;
import tr.com.obss.plugin.extra.flyingpdf.util.ImageTranscoderCacheUtil;

public class LightITextFSImageUtilityMethods {
    static ImageInformation updateMeasurementsForSvg(float dotsPerPixel, File tempFile, String uri, int defaultSvgWidth, int defaultSvgHeight, LightITextFSImage.IntWrapper width, LightITextFSImage.IntWrapper height) throws UnsupportedEncodingException, IOException, FileNotFoundException {
        ImageInformation cacheInformation;
        try (FileInputStream imgSvgStream = new FileInputStream(tempFile);){
            PNGTranscoder transcoder = new PNGTranscoder();
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            transcoder.transcode(new TranscoderInput(new InputStreamReader((InputStream)imgSvgStream, "UTF-8")), new TranscoderOutput(out));
            width.setValue((int)(dotsPerPixel * (float)defaultSvgWidth));
            height.setValue((int)(dotsPerPixel * (float)defaultSvgHeight));
            cacheInformation = new ImageInformation(height.getValue(), width.getValue(), tempFile.getAbsolutePath(), true);
        }
        catch (TranscoderException te) {
            ImageInformation cacheInformation2 = new ImageInformation(0, 0, null, false);
            ImageInformationURICacheUtil.setCacheURI(uri, cacheInformation2);
            throw new IOException("Unknown image format", te);
        }
        catch (MalformedURLException te) {
            ImageInformation cacheInformation3 = new ImageInformation(0, 0, null, false);
            ImageInformationURICacheUtil.setCacheURI(uri, cacheInformation3);
            throw new IOException("Malformed url " + uri, te);
        }
        return cacheInformation;
    }

    static String getTempFileNameForSvg(String imageTempFile, ImageInformation imageInformation, String uri, LightITextFSImage.IntWrapper width, LightITextFSImage.IntWrapper height) {
        try (FileInputStream imgSvgStream = new FileInputStream(imageInformation.getTempFileName());){
            PNGTranscoder transcoder = new PNGTranscoder();
            transcoder.addTranscodingHint(ImageTranscoder.KEY_WIDTH, Float.valueOf(width.getValue()));
            transcoder.addTranscodingHint(ImageTranscoder.KEY_HEIGHT, Float.valueOf(height.getValue()));
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            transcoder.transcode(new TranscoderInput(new InputStreamReader((InputStream)imgSvgStream, "UTF-8")), new TranscoderOutput(out));
            File transcoderTempFile = ImageFileCacheUtils.createTempFile(out.toByteArray());
            ImageTranscoderCacheUtil.setCacheImage(uri, transcoderTempFile.getAbsolutePath());
            imageTempFile = transcoderTempFile.getAbsolutePath();
        }
        catch (Exception tx) {
            throw new RuntimeException("Failed to read image", tx);
        }
        return imageTempFile;
    }

    static Image getSvgImage(String uri, LightITextFSImage.IntWrapper width, LightITextFSImage.IntWrapper height) {
        Image image;
        block8: {
            InputStream imgSvgStream = new URL(uri).openStream();
            try {
                PNGTranscoder transcoder = new PNGTranscoder();
                transcoder.addTranscodingHint(ImageTranscoder.KEY_WIDTH, Float.valueOf(width.getValue()));
                transcoder.addTranscodingHint(ImageTranscoder.KEY_HEIGHT, Float.valueOf(height.getValue()));
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                transcoder.transcode(new TranscoderInput(new InputStreamReader(imgSvgStream, "UTF-8")), new TranscoderOutput(out));
                Image svgImage = Image.getInstance(out.toByteArray());
                svgImage.scaleAbsolute(width.getValue(), height.getValue());
                image = svgImage;
                if (imgSvgStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (imgSvgStream != null) {
                        try {
                            imgSvgStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception tx) {
                    throw new RuntimeException("Failed to read image", tx);
                }
            }
            imgSvgStream.close();
        }
        return image;
    }
}

