/*
 * Decompiled with CFR 0.152.
 */
package tr.com.obss.plugin.export;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.DateFormatter;
import com.atlassian.confluence.importexport.ImportExportManager;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.confluence.util.longrunning.LongRunningTaskManager;
import com.atlassian.core.task.longrunning.LongRunningTask;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.user.User;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.UUID;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tr.com.obss.plugin.BaselineDocumentPathComparator;
import tr.com.obss.plugin.ServiceAccessor;
import tr.com.obss.plugin.VersionSpecificGateKeeper;
import tr.com.obss.plugin.baseline.BaselineService;
import tr.com.obss.plugin.dto.Baseline;
import tr.com.obss.plugin.dto.BaselineAttachment;
import tr.com.obss.plugin.dto.BaselineCsvSeparatorType;
import tr.com.obss.plugin.dto.BaselineDocument;
import tr.com.obss.plugin.dto.BaselineDocumentType;
import tr.com.obss.plugin.dto.BaselineDocumentTypeQuery;
import tr.com.obss.plugin.exception.BaselinePDFExportLimitException;
import tr.com.obss.plugin.export.BaselineExportService;
import tr.com.obss.plugin.export.BaselinePdfExportLongRunningTask;
import tr.com.obss.plugin.export.BaselinePdfExportProcess;
import tr.com.obss.plugin.export.BaselinePdfExportProcessTracker;
import tr.com.obss.plugin.export.PagePdfExportRunnable;
import tr.com.obss.plugin.extra.flyingpdf.PdfExportSemaphore;
import tr.com.obss.plugin.extra.flyingpdf.PdfExporterService;
import tr.com.obss.plugin.extra.flyingpdf.gatekeeper.VersionSpecificGateKeeperFactory;
import tr.com.obss.plugin.info.InfoService;
import tr.com.obss.plugin.utils.FileUtils;

public class BaselineExportServiceImpl
implements BaselineExportService {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaselineExportServiceImpl.class);
    private static final String CSV_SEPARATOR_COMMA_KEY = "comma";
    private PdfExporterService pdfExporterService;
    private BootstrapManager bootstrapManager;
    private PageManager pageManager;
    private BaselineService baselineService;
    private SpaceManager spaceManager;
    private VersionSpecificGateKeeper gateKeeper;
    private LongRunningTaskManager longRunningTaskManager;
    private TransactionTemplate transactionTemplate;
    private ImportExportManager importExportManager;
    private PdfExportSemaphore pdfExportSemaphore;
    private PermissionManager permissionManager;
    private final InfoService infoService;

    public BaselineExportServiceImpl(PdfExporterService internalPdfExporterService, BootstrapManager bootstrapManager, PageManager pageManager, BaselineService baselineService, SpaceManager spaceManager, LongRunningTaskManager longRunningTaskManager, TransactionTemplate transactionTemplate, PdfExportSemaphore pdfExportSemaphore, ImportExportManager importExportManager, PermissionManager permissionManager, InfoService infoService) {
        this.pdfExporterService = internalPdfExporterService;
        this.bootstrapManager = bootstrapManager;
        this.pageManager = pageManager;
        this.baselineService = baselineService;
        this.spaceManager = spaceManager;
        this.gateKeeper = VersionSpecificGateKeeperFactory.getGateKeeper(GeneralUtil.getVersionNumber());
        this.longRunningTaskManager = longRunningTaskManager;
        this.transactionTemplate = transactionTemplate;
        this.pdfExportSemaphore = pdfExportSemaphore;
        this.importExportManager = importExportManager;
        this.permissionManager = permissionManager;
        this.infoService = infoService;
    }

    @Override
    public String createPdfForPage(Long pageId, int pageVersion, String contextPath, String spaceKey) {
        if (pageId == null || contextPath == null) {
            LOGGER.error("Some of the parameters are null. pageId: {}, pageVersion: {}, contextPath: {}", new Object[]{pageId, pageVersion, contextPath});
            return null;
        }
        AbstractPage page = (AbstractPage)this.pageManager.getOtherVersion((ContentEntityObject)this.pageManager.getPage(pageId.longValue()), pageVersion);
        if (page == null) {
            LOGGER.warn("Page with id {} could not be found. Pdf could not be created.", (Object)pageId);
            return null;
        }
        ConfluenceUser currentUser = AuthenticatedUserThreadLocal.get();
        if (!this.permissionManager.hasPermission((User)currentUser, Permission.VIEW, (Object)page)) {
            LOGGER.warn("User don't have permission to export the page.");
            return null;
        }
        try {
            PagePdfExportRunnable pdfRunnable = new PagePdfExportRunnable(this.pdfExporterService, page, contextPath);
            this.pdfExportSemaphore.run(pdfRunnable);
            String downloadPath = FileUtils.getDownloadPath(pdfRunnable.getPdfFile(), this.bootstrapManager);
            if (downloadPath != null) {
                Space space = this.spaceManager.getSpace(spaceKey);
                Predicate<User> permissionPredicate = u -> this.permissionManager.hasPermission(u, Permission.VIEW, (Object)space);
                this.gateKeeper.addkey(downloadPath, (User)currentUser, permissionPredicate);
            }
            return downloadPath;
        }
        catch (RuntimeException e) {
            LOGGER.warn("Not enough processors for pdf export operation.", (Throwable)e);
            return null;
        }
    }

    @Override
    public UUID createPdfForBaseline(String baselineName, String spaceKey, String contextPath) throws BaselinePDFExportLimitException {
        if (baselineName == null || spaceKey == null || contextPath == null) {
            LOGGER.error("Some of the parameters are null. baselineName: {}, spaceKey: {}, contextPath: {}", new Object[]{baselineName, spaceKey, contextPath});
            return null;
        }
        Space space = this.spaceManager.getSpace(spaceKey);
        if (space == null) {
            LOGGER.warn("Space with key {} could not be found.", (Object)spaceKey);
            return null;
        }
        ConfluenceUser currentUser = AuthenticatedUserThreadLocal.get();
        if (!this.permissionManager.hasPermission((User)currentUser, Permission.VIEW, (Object)space)) {
            LOGGER.warn("User don't have permission to export the space.");
            return null;
        }
        Baseline baseline = this.baselineService.getBaseline(space, baselineName, BaselineDocumentTypeQuery.PAGE);
        if (baseline == null) {
            LOGGER.warn("Baseline could not be found for baselineName: {} and spaceKey: {}", (Object)baselineName, (Object)spaceKey);
            return null;
        }
        int systemMaxExportCount = this.infoService.getAllowedPdfMaxPageCount();
        if (systemMaxExportCount > 0 && baseline.getTotalPageCount() > systemMaxExportCount) {
            LOGGER.warn("Baseline page count ({}) is bigger than allowed size ({})", (Object)baseline.getTotalPageCount(), (Object)systemMaxExportCount);
            throw new BaselinePDFExportLimitException(systemMaxExportCount);
        }
        UUID exportId = UUID.randomUUID();
        BaselinePdfExportProcess exportProcess = new BaselinePdfExportProcess(baselineName, space.getName(), System.currentTimeMillis());
        BaselinePdfExportProcessTracker.addProcess(exportId, exportProcess);
        this.startPdfExportLongRunningTask(exportProcess, baseline, contextPath, space, (User)AuthenticatedUserThreadLocal.get());
        return exportId;
    }

    private void startPdfExportLongRunningTask(BaselinePdfExportProcess exportProcess, Baseline baseline, String contextPath, Space space, User user) {
        BaselinePdfExportLongRunningTask exportTask = new BaselinePdfExportLongRunningTask(exportProcess, baseline, contextPath, space, user);
        exportTask.setBootstrapManager(this.bootstrapManager);
        exportTask.setGateKeeper(this.gateKeeper);
        exportTask.setPdfExporterService(this.pdfExporterService);
        exportTask.setTransactionTemplate(this.transactionTemplate);
        exportTask.setPdfExportSemaphore(this.pdfExportSemaphore);
        exportTask.setImportExportManager(this.importExportManager);
        exportTask.setPageManager(this.pageManager);
        exportTask.setPermissionManager(this.permissionManager);
        this.longRunningTaskManager.startLongRunningTask(user, (LongRunningTask)exportTask);
    }

    @Override
    public String createCsvForBaseline(String baselineName, String spaceKey, BaselineCsvSeparatorType separatorType, String baseUrl) {
        if (baselineName == null || spaceKey == null) {
            LOGGER.error("Some of the parameters are null. baselineName: {}, spaceKey: {}", new Object[]{baselineName, spaceKey});
            return null;
        }
        Space space = this.spaceManager.getSpace(spaceKey);
        if (space == null) {
            LOGGER.warn("Space with key {} could not be found.", (Object)spaceKey);
            return null;
        }
        ConfluenceUser currentUser = AuthenticatedUserThreadLocal.get();
        if (!this.permissionManager.hasPermission((User)currentUser, Permission.VIEW, (Object)space)) {
            LOGGER.warn("User don't have permission to export the space.");
            return null;
        }
        Baseline baseline = this.baselineService.getBaseline(space, baselineName, BaselineDocumentTypeQuery.ANY_DOCUMENT);
        if (baseline == null) {
            LOGGER.warn("Baseline could not be found for baselineName: {} and spaceKey: {}", (Object)baselineName, (Object)spaceKey);
            return null;
        }
        File csvFile = FileUtils.generateFileInTempDir(this.bootstrapManager, "baseline-csv-export", "csv", "baseline-csv");
        if (csvFile == null) {
            LOGGER.error("Csv file could not be created in the Confluence temp folder.");
            return null;
        }
        this.pdfExportSemaphore.run(() -> {
            Writer csvWriter = null;
            try (FileOutputStream os = new FileOutputStream(csvFile);){
                ((OutputStream)os).write(239);
                ((OutputStream)os).write(187);
                ((OutputStream)os).write(191);
                csvWriter = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)os, StandardCharsets.UTF_8), true);
                this.writeCsvHeaders(csvWriter, separatorType.getSeparator());
                List<BaselineDocument> baselineDocuments = baseline.getAllDocuments();
                baselineDocuments.sort(new BaselineDocumentPathComparator());
                DateFormatter dateFormatter = ServiceAccessor.getDateService().getUserPreferencesDateFormatter();
                for (BaselineDocument document : baselineDocuments) {
                    Page page = this.pageManager.getPage(document.getType().equals((Object)BaselineDocumentType.PAGE) ? Long.parseLong(document.getId()) : Long.parseLong(((BaselineAttachment)document).getPageId()));
                    boolean userHasPermissonForViewPage = this.permissionManager.hasPermission((User)currentUser, Permission.VIEW, (Object)page);
                    if (!userHasPermissonForViewPage) continue;
                    this.writeCsvRowForDocument(csvWriter, document, dateFormatter, separatorType.getSeparator(), baseUrl);
                }
                csvWriter.flush();
            }
            catch (Exception e) {
                LOGGER.error("Something went wrong while creating the csv file.", (Throwable)e);
            }
            finally {
                try {
                    if (csvWriter != null) {
                        csvWriter.close();
                    }
                }
                catch (IOException e) {
                    LOGGER.error("Csv writer could not be closed.", (Throwable)e);
                }
            }
        });
        String downloadPath = FileUtils.getDownloadPath(csvFile, this.bootstrapManager);
        if (downloadPath != null) {
            Predicate<User> permissionPredicate = u -> this.permissionManager.hasPermission(u, Permission.VIEW, (Object)space);
            this.gateKeeper.addkey(downloadPath, (User)currentUser, permissionPredicate);
        }
        return downloadPath;
    }

    private void writeCsvRowForDocument(Writer csvWriter, BaselineDocument document, DateFormatter dateFormatter, String separator, String baseUrl) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getQuotedValue(document.getTitle()));
        stringBuilder.append(separator);
        stringBuilder.append(this.getQuotedValue(document.getType().toString()));
        stringBuilder.append(separator);
        stringBuilder.append(this.getQuotedValue(document.getPath()));
        stringBuilder.append(separator);
        stringBuilder.append(this.getQuotedValue(document.getVersion()));
        stringBuilder.append(separator);
        stringBuilder.append(this.getQuotedValue(dateFormatter.formatDateTime(document.getCreationDate())));
        stringBuilder.append(separator);
        stringBuilder.append(this.getQuotedValue(baseUrl + document.getUrl()));
        stringBuilder.append("\n");
        csvWriter.write(stringBuilder.toString());
    }

    private void writeCsvHeaders(Writer csvWriter, String separator) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getQuotedValue("title"));
        stringBuilder.append(separator);
        stringBuilder.append(this.getQuotedValue("type"));
        stringBuilder.append(separator);
        stringBuilder.append(this.getQuotedValue("location"));
        stringBuilder.append(separator);
        stringBuilder.append(this.getQuotedValue("version"));
        stringBuilder.append(separator);
        stringBuilder.append(this.getQuotedValue("date"));
        stringBuilder.append(separator);
        stringBuilder.append(this.getQuotedValue("url"));
        stringBuilder.append("\n");
        csvWriter.write(stringBuilder.toString());
    }

    private String getQuotedValue(String value) {
        if (value == null) {
            return "\"\"";
        }
        return "\"" + value.replace("\"", "\"\"") + "\"";
    }
}

