/*
 * Decompiled with CFR 0.152.
 */
package tr.com.obss.plugin.baseline;

import com.atlassian.confluence.core.persistence.hibernate.CacheMode;
import com.atlassian.confluence.core.persistence.hibernate.SessionCacheModeThreadLocal;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.util.longrunning.ConfluenceAbstractLongRunningTask;
import com.atlassian.confluence.util.longrunning.LongRunningTaskManager;
import com.atlassian.core.task.longrunning.LongRunningTask;
import com.atlassian.user.User;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tr.com.obss.plugin.BaselineDocumentPathComparator;
import tr.com.obss.plugin.CommonDocumentPathComparator;
import tr.com.obss.plugin.baseline.BaselineService;
import tr.com.obss.plugin.baseline.parameter.BaselineCompareParameterBuilder;
import tr.com.obss.plugin.baseline.parameter.BaselineCreateParameters;
import tr.com.obss.plugin.baseline.request.BaselineCreateRequest;
import tr.com.obss.plugin.collector.factory.PageCollectorFactory;
import tr.com.obss.plugin.collector.page.PageCollector;
import tr.com.obss.plugin.database.BaselineDatabaseManager;
import tr.com.obss.plugin.dto.Baseline;
import tr.com.obss.plugin.dto.BaselineAttachment;
import tr.com.obss.plugin.dto.BaselineCreateResult;
import tr.com.obss.plugin.dto.BaselineDocument;
import tr.com.obss.plugin.dto.BaselineDocumentType;
import tr.com.obss.plugin.dto.BaselineDocumentTypeQuery;
import tr.com.obss.plugin.dto.BaselinePage;
import tr.com.obss.plugin.dto.BaselineSummary;
import tr.com.obss.plugin.dto.CollectedAttachment;
import tr.com.obss.plugin.dto.CollectedPage;
import tr.com.obss.plugin.dto.CollectedPageMap;
import tr.com.obss.plugin.dto.CommonBaselineAttachmentPair;
import tr.com.obss.plugin.dto.CommonBaselineDocumentPair;
import tr.com.obss.plugin.dto.CommonBaselinePagePair;
import tr.com.obss.plugin.dto.CompareResult;
import tr.com.obss.plugin.dto.impl.BaselineAttachmentImpl;
import tr.com.obss.plugin.dto.impl.BaselineImpl;
import tr.com.obss.plugin.dto.impl.BaselinePageImpl;
import tr.com.obss.plugin.exception.BaselineParameterException;
import tr.com.obss.plugin.exception.SpaceNotFoundException;
import tr.com.obss.plugin.progress.BaselineProgressPhaseType;
import tr.com.obss.plugin.progress.BaselineProgressTracker;
import tr.com.obss.plugin.progress.PhasedBaselineProgress;
import tr.com.obss.plugin.progress.SimpleBaselineProgress;
import tr.com.obss.plugin.utils.Utils;

public class BaselineServiceImpl
implements BaselineService {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaselineServiceImpl.class);
    private PageManager pageManager;
    private BaselineDatabaseManager baselineDatabaseManager;
    private PermissionManager permissionManager;
    private LongRunningTaskManager longRunningTaskManager;

    public BaselineServiceImpl(PageManager pageManager, BaselineDatabaseManager baselineDatabaseManager, PermissionManager permissionManager, LongRunningTaskManager longRunningTaskManager) {
        this.pageManager = pageManager;
        this.baselineDatabaseManager = baselineDatabaseManager;
        this.permissionManager = permissionManager;
        this.longRunningTaskManager = longRunningTaskManager;
    }

    @Override
    public Baseline getBaseline(Space space, String baselineName, BaselineDocumentTypeQuery documentType) {
        return this.baselineDatabaseManager.getBaseline(space, baselineName, 1, Integer.MAX_VALUE, documentType);
    }

    @Override
    public Baseline getBaseline(Space space, String baselineName, int pageNumber, int pageSize, BaselineDocumentTypeQuery documentType) {
        return this.baselineDatabaseManager.getBaseline(space, baselineName, pageNumber, pageSize, documentType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BaselineCreateResult createBaseline(BaselineCreateParameters parameters, BaselineCreateRequest createRequest) throws BaselineParameterException {
        SessionCacheModeThreadLocal.set((CacheMode)CacheMode.IGNORE);
        try {
            boolean userHasPermissonToViewSpace = this.permissionManager.hasPermission((User)AuthenticatedUserThreadLocal.get(), Permission.VIEW, (Object)parameters.getSpace());
            if (!userHasPermissonToViewSpace) {
                throw new SpaceNotFoundException();
            }
            PageCollector pageCollector = PageCollectorFactory.getPageCollector(parameters);
            int pageCount = this.calculatePageCount(parameters, pageCollector);
            SimpleBaselineProgress baselineProgress = new SimpleBaselineProgress(pageCount > 0 ? pageCount : 1);
            UUID operationId = parameters.getOperationId();
            if (operationId != null) {
                BaselineProgressTracker.addProgress(operationId, baselineProgress);
                pageCollector.registerBaselineProgress(operationId);
            }
            CollectedPageMap collectedPages = pageCollector.collect();
            BaselineImpl baseline = new BaselineImpl(parameters.getBaselineName(), new Date(), parameters.getBaselineDate(), parameters.getSpace().getKey(), AuthenticatedUserThreadLocal.get().getName(), parameters.getBaselineKeyword(), this.getBaselineDocuments(collectedPages));
            this.baselineDatabaseManager.persistBaseline(parameters.getSpace(), baseline, createRequest);
            baselineProgress.setCompleted();
            BaselineCreateResult baselineCreateResult = new BaselineCreateResult(baseline, pageCollector.getWarnings());
            return baselineCreateResult;
        }
        finally {
            SessionCacheModeThreadLocal.set((CacheMode)CacheMode.NORMAL);
        }
    }

    @Override
    public void startBaselineCreation(final BaselineCreateParameters parameters, final BaselineCreateRequest createRequest) {
        this.longRunningTaskManager.startLongRunningTask((User)AuthenticatedUserThreadLocal.get(), (LongRunningTask)new ConfluenceAbstractLongRunningTask(){

            public String getNameKey() {
                return "bsl-create-" + parameters.getOperationId().toString();
            }

            public String getName() {
                return "Baseline Create - " + parameters.getOperationId().toString();
            }

            protected void runInternal() {
                try {
                    BaselineServiceImpl.this.createBaseline(parameters, createRequest);
                }
                catch (Exception e) {
                    LOGGER.error("An error occurred during baseline creation.", (Throwable)e);
                    BaselineServiceImpl.this.createFailedProgress(parameters.getOperationId());
                }
            }
        });
    }

    private void createFailedProgress(UUID operationId) {
        if (operationId != null) {
            try {
                SimpleBaselineProgress baselineProgress = new SimpleBaselineProgress(1);
                baselineProgress.setFailed();
                BaselineProgressTracker.addProgress(operationId, baselineProgress);
            }
            catch (Exception e) {
                LOGGER.error("An error occurred during creation of failed progress.", (Throwable)e);
            }
        }
    }

    private int calculatePageCount(BaselineCreateParameters parameters, PageCollector pageCollector) {
        int pageCount = 0;
        if (parameters.getSelectAllPages().booleanValue()) {
            pageCount = this.pageManager.getPages(parameters.getSpace(), Boolean.TRUE.booleanValue()).size();
        } else {
            HashSet pages = new HashSet();
            List fullySelectedIds = parameters.getFullySelectedPages().stream().filter(selectedPage -> !pageCollector.shouldIgnore(selectedPage.getNonPrefixId())).map(selectedPage -> Long.parseLong(selectedPage.getNonPrefixId())).collect(Collectors.toList());
            List partiallySelectedIds = parameters.getPartiallySelectedPages().stream().filter(selectedPage -> !pageCollector.shouldIgnore(selectedPage.getNonPrefixId())).map(selectedPage -> Long.parseLong(selectedPage.getNonPrefixId())).collect(Collectors.toList());
            List fullySelected = this.pageManager.getPages(fullySelectedIds);
            List partiallySelected = this.pageManager.getPages(partiallySelectedIds);
            fullySelected.forEach(page -> {
                if (!pageCollector.shouldSkipDescendants(page.getIdAsString())) {
                    pages.addAll(page.getDescendants());
                }
            });
            pages.addAll(fullySelected);
            pages.addAll(partiallySelected);
            pageCount += pages.size();
        }
        return pageCount;
    }

    @Override
    public void deleteBaseline(Space space, String baselineName) {
        this.baselineDatabaseManager.deleteBaseline(space, baselineName);
    }

    @Override
    public boolean doesBaselineNameExist(Space space, String baselineName) {
        List<String> baselineNames = this.getBaselineNames(space);
        for (String name : baselineNames) {
            if (!baselineName.equals(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isBaselineNameTooLong(String baselineName) {
        return this.baselineDatabaseManager.isBaselineNameTooLong(baselineName);
    }

    @Override
    public List<String> getBaselineNames(Space space) {
        return this.baselineDatabaseManager.getAllBaselineNames(space);
    }

    @Override
    public Baseline getSpaceAsBaseline(Space space, PhasedBaselineProgress baselineProgress) {
        ArrayList<BaselineDocument> baselineDocuments = new ArrayList<BaselineDocument>();
        List pagesOfSpace = this.pageManager.getPages(space, true);
        for (Page page : pagesOfSpace) {
            ArrayList<BaselineAttachment> baselineAttachments = new ArrayList<BaselineAttachment>();
            List attachmentsOfPage = page.getLatestVersionsOfAttachments();
            for (Attachment attachment : attachmentsOfPage) {
                baselineAttachments.add(new BaselineAttachmentImpl(attachment.getIdAsString(), attachment.getTitle(), Utils.generatePagePath(page) + page.getTitle() + " \\", Integer.toString(attachment.getVersion()), attachment.getDownloadPath(), attachment.getCreationDate(), page.getIdAsString()));
            }
            BaselinePageImpl baselinePage = new BaselinePageImpl(page.getIdAsString(), page.getTitle(), Utils.generatePagePath(page).trim(), Integer.toString(page.getVersion()), Utils.generatePageUrl(page), page.getCreationDate(), baselineAttachments);
            baselineDocuments.add(baselinePage);
            baselineDocuments.addAll(baselineAttachments);
            baselineProgress.tick(BaselineProgressPhaseType.GET_SPACE_AS_BASELINE);
        }
        if (pagesOfSpace.isEmpty()) {
            baselineProgress.tick(BaselineProgressPhaseType.GET_SPACE_AS_BASELINE);
        }
        return new BaselineImpl(space.getName() + " [LATEST]", null, null, space.getKey(), null, null, baselineDocuments);
    }

    @Override
    public List<BaselineSummary> getBaselineSummaries(Space space) {
        return this.baselineDatabaseManager.getBaselineSummaries(space);
    }

    @Override
    public List<BaselineDocument> searchInBaseline(Baseline baseline, String searchQuery, BaselineDocumentTypeQuery docTypeQuery, Set<String> permittedPageIds) {
        if (searchQuery == null) {
            return new ArrayList<BaselineDocument>();
        }
        searchQuery = searchQuery.trim().toLowerCase();
        List<BaselineDocument> baselineDocuments = baseline.getAllDocuments();
        baselineDocuments.sort(new BaselineDocumentPathComparator());
        ArrayList<BaselineDocument> searchResults = new ArrayList<BaselineDocument>();
        for (BaselineDocument document : baselineDocuments) {
            if (document.getType() == BaselineDocumentType.PAGE && !permittedPageIds.contains(document.getId()) || document.getType() == BaselineDocumentType.ATTACHMENT && !permittedPageIds.contains(((BaselineAttachment)document).getPageId())) continue;
            String docTitle = document.getTitle().toLowerCase();
            String docPath = document.getPath().toLowerCase();
            String docType = document.getType().toString();
            if ((docTitle.contains(searchQuery) || docPath.contains(searchQuery)) && (docType.equals(docTypeQuery.toString()) || BaselineDocumentTypeQuery.ANY_DOCUMENT.equals((Object)docTypeQuery))) {
                searchResults.add(document);
            }
            if (searchResults.size() <= 500) continue;
            break;
        }
        return searchResults;
    }

    @Override
    public CompareResult compareBaselines(BaselineCompareParameterBuilder.BaselineCompareParameters parameters) {
        Baseline baseline1 = parameters.getBaseline1();
        Baseline baseline2 = parameters.getBaseline2();
        PhasedBaselineProgress baselineProgress = parameters.getBaselineProgress();
        ArrayList<BaselinePage> leftJoinedPages = new ArrayList<BaselinePage>();
        ArrayList<BaselineAttachment> leftJoinedAttachments = new ArrayList<BaselineAttachment>();
        ArrayList<BaselinePage> rightJoinedPages = new ArrayList<BaselinePage>();
        ArrayList<BaselineAttachment> rightJoinedAttachments = new ArrayList<BaselineAttachment>();
        ArrayList<CommonBaselinePagePair> commonPagesWithDifferentVersions = new ArrayList<CommonBaselinePagePair>();
        ArrayList<CommonBaselineAttachmentPair> commonAttachmentsWithDifferentVersions = new ArrayList<CommonBaselineAttachmentPair>();
        ArrayList<BaselinePage> commonPagesWithSameVersions = new ArrayList<BaselinePage>();
        ArrayList<BaselineAttachment> commonAttachmentsWithSameVersions = new ArrayList<BaselineAttachment>();
        this.findLeftJoinedDocuments(baseline1, baseline2, leftJoinedPages, leftJoinedAttachments);
        this.findRightJoinedDocuments(baseline1, baseline2, rightJoinedPages, rightJoinedAttachments);
        this.findCommonDocuments(baseline1, baseline2, commonPagesWithDifferentVersions, commonPagesWithSameVersions, commonAttachmentsWithDifferentVersions, commonAttachmentsWithSameVersions);
        baselineProgress.tick(BaselineProgressPhaseType.COMPARE);
        int leftJoinedPageCount = leftJoinedPages.size();
        int leftJoinedAttachmentCount = leftJoinedAttachments.size();
        int rightJoinedPageCount = rightJoinedPages.size();
        int rightJoinedAttachmentCount = rightJoinedAttachments.size();
        int commonPagesWithDifferentVersionsCount = commonPagesWithDifferentVersions.size();
        int commonAttachmentsWithDifferentVersionsCount = commonAttachmentsWithDifferentVersions.size();
        int commonPagesWithSameVersionsCount = commonPagesWithSameVersions.size();
        int commonAttachmentsWithSameVersionsCount = commonAttachmentsWithSameVersions.size();
        ConfluenceUser currentUser = AuthenticatedUserThreadLocal.get();
        Set<String> baseline1PermittedPageIds = this.getPermittedPageIds(currentUser, baseline1);
        Set<String> baseline2PermittedPageIds = this.getPermittedPageIds(currentUser, baseline2);
        leftJoinedPages.removeIf(page -> !baseline1PermittedPageIds.contains(page.getId()));
        leftJoinedAttachments.removeIf(attachment -> !baseline1PermittedPageIds.contains(attachment.getPageId()));
        ArrayList<BaselineDocument> leftJoinedDocuments = new ArrayList<BaselineDocument>();
        leftJoinedDocuments.addAll(leftJoinedPages);
        leftJoinedDocuments.addAll(leftJoinedAttachments);
        leftJoinedDocuments.sort(new BaselineDocumentPathComparator());
        rightJoinedPages.removeIf(page -> !baseline2PermittedPageIds.contains(page.getId()));
        rightJoinedAttachments.removeIf(attachment -> !baseline2PermittedPageIds.contains(attachment.getPageId()));
        ArrayList<BaselineDocument> rightJoinedDocuments = new ArrayList<BaselineDocument>();
        rightJoinedDocuments.addAll(rightJoinedPages);
        rightJoinedDocuments.addAll(rightJoinedAttachments);
        rightJoinedDocuments.sort(new BaselineDocumentPathComparator());
        commonPagesWithDifferentVersions.removeIf(commonPage -> !baseline1PermittedPageIds.contains(commonPage.getFirstDocument().getId()));
        commonAttachmentsWithDifferentVersions.removeIf(commonAttachment -> !baseline1PermittedPageIds.contains(((BaselineAttachment)commonAttachment.getFirstDocument()).getPageId()));
        ArrayList<CommonBaselineDocumentPair> commonDocumentsWithDifferentVersions = new ArrayList<CommonBaselineDocumentPair>();
        commonDocumentsWithDifferentVersions.addAll(commonPagesWithDifferentVersions);
        commonDocumentsWithDifferentVersions.addAll(commonAttachmentsWithDifferentVersions);
        commonDocumentsWithDifferentVersions.sort(new CommonDocumentPathComparator());
        baselineProgress.tick(BaselineProgressPhaseType.SORT);
        boolean canUserViewAllPages = baseline1.getPages().size() == baseline1PermittedPageIds.size() && baseline2.getPages().size() == baseline2PermittedPageIds.size();
        baselineProgress.setCompleted();
        return new CompareResult(baseline1.getName(), baseline2.getName(), leftJoinedPageCount, leftJoinedAttachmentCount, leftJoinedDocuments, rightJoinedPageCount, rightJoinedAttachmentCount, rightJoinedDocuments, commonPagesWithDifferentVersionsCount, commonAttachmentsWithDifferentVersionsCount, commonDocumentsWithDifferentVersions, commonPagesWithSameVersionsCount, commonAttachmentsWithSameVersionsCount, canUserViewAllPages);
    }

    private void findCommonDocuments(Baseline baseline1, Baseline baseline2, List<CommonBaselinePagePair> commonPagesWithDifferentVersions, List<BaselinePage> commonPagesWithSameVersions, List<CommonBaselineAttachmentPair> commonAttachmentsWithDifferentVersions, List<BaselineAttachment> commonAttachmentsWithSameVersions) {
        for (BaselinePage b1Page : baseline1.getPages()) {
            BaselinePage b2Page = baseline2.getPageById(b1Page.getId());
            if (b2Page == null) continue;
            if (!b1Page.getVersion().equals(b2Page.getVersion())) {
                commonPagesWithDifferentVersions.add(new CommonBaselinePagePair(b1Page, b2Page));
            } else {
                commonPagesWithSameVersions.add(b1Page);
            }
            if (b1Page.getAttachments() == null || b2Page.getAttachments() == null) continue;
            block1: for (BaselineAttachment b1PageAttachment : b1Page.getAttachments()) {
                for (BaselineAttachment b2PageAttachment : b2Page.getAttachments()) {
                    if (!b1PageAttachment.getId().equals(b2PageAttachment.getId())) continue;
                    if (!b1PageAttachment.getVersion().equals(b2PageAttachment.getVersion())) {
                        commonAttachmentsWithDifferentVersions.add(new CommonBaselineAttachmentPair(b1PageAttachment, b2PageAttachment));
                        continue block1;
                    }
                    commonAttachmentsWithSameVersions.add(b1PageAttachment);
                    continue block1;
                }
            }
        }
    }

    private void findLeftJoinedDocuments(Baseline baselineLeft, Baseline baselineRight, List<BaselinePage> leftJoinedPages, List<BaselineAttachment> leftJoinedAttachments) {
        this.compareBaselinesAndGetDifferentDocuments(leftJoinedPages, leftJoinedAttachments, baselineLeft, baselineRight);
    }

    private void findRightJoinedDocuments(Baseline baselineLeft, Baseline baselineRight, List<BaselinePage> rightJoinedPages, List<BaselineAttachment> rightJoinedAttachments) {
        this.compareBaselinesAndGetDifferentDocuments(rightJoinedPages, rightJoinedAttachments, baselineRight, baselineLeft);
    }

    private void compareBaselinesAndGetDifferentDocuments(List<BaselinePage> resultPages, List<BaselineAttachment> resultAttachments, Baseline baseline, Baseline baselineCompare) {
        for (BaselinePage page : baseline.getPages()) {
            BaselinePage pageCompare = baselineCompare.getPageById(page.getId());
            if (pageCompare != null) {
                List<BaselineAttachment> attachmentsOfPage = page.getAttachments();
                List<BaselineAttachment> attachmentsOfPageCompare = pageCompare.getAttachments();
                if (attachmentsOfPage == null) continue;
                if (attachmentsOfPageCompare == null) {
                    resultAttachments.addAll(attachmentsOfPage);
                    continue;
                }
                for (BaselineAttachment b1Attachment : attachmentsOfPage) {
                    boolean isAttachmentCommon = false;
                    for (BaselineAttachment b2Attachment : attachmentsOfPageCompare) {
                        if (!b1Attachment.getId().equals(b2Attachment.getId())) continue;
                        isAttachmentCommon = true;
                    }
                    if (isAttachmentCommon) continue;
                    resultAttachments.add(b1Attachment);
                }
                continue;
            }
            resultPages.add(page);
            List<BaselineAttachment> b1Attachments = page.getAttachments();
            if (b1Attachments == null) continue;
            resultAttachments.addAll(b1Attachments);
        }
    }

    private List<BaselineDocument> getBaselineDocuments(CollectedPageMap collectedPages) {
        ArrayList<BaselineDocument> baselineDocuments = new ArrayList<BaselineDocument>();
        for (String collectedPageId : collectedPages.keySet()) {
            CollectedPage collectedPage = (CollectedPage)collectedPages.get(collectedPageId);
            try {
                Page baselineVersion = collectedPage.getCollectedPageVersion();
                if (baselineVersion == null) continue;
                String pagePath = Utils.generatePagePath(baselineVersion);
                Long originalVersionId = baselineVersion.getOriginalVersionId();
                List<BaselineAttachment> baselineAttachments = this.getBaselineAttachments(baselineVersion, collectedPage.getAttachments(), pagePath);
                BaselinePageImpl baselinePage = new BaselinePageImpl(originalVersionId != null ? originalVersionId.toString() : baselineVersion.getIdAsString(), baselineVersion.getTitle(), pagePath.trim(), Integer.toString(baselineVersion.getVersion()), Utils.generatePageUrl(baselineVersion), baselineVersion.getLastModificationDate(), baselineAttachments);
                baselineDocuments.add(baselinePage);
                baselineDocuments.addAll(baselineAttachments);
            }
            catch (Exception e) {
                LOGGER.error("An error occurred during evaluation of page.", (Throwable)e);
            }
        }
        baselineDocuments.sort(new BaselineDocumentPathComparator());
        return baselineDocuments;
    }

    private List<BaselineAttachment> getBaselineAttachments(Page baselinePage, List<CollectedAttachment> attachments, String pagePath) {
        ArrayList<BaselineAttachment> baselineAttachments = new ArrayList<BaselineAttachment>();
        for (CollectedAttachment collectedAttachment : attachments) {
            try {
                Attachment attachment = collectedAttachment.getCollectedAttachmentVersion();
                Long originalVersionId = attachment.getOriginalVersionId();
                baselineAttachments.add(new BaselineAttachmentImpl(originalVersionId != null ? originalVersionId.toString() : attachment.getIdAsString(), attachment.getTitle(), pagePath + baselinePage.getTitle() + " \\", Integer.toString(attachment.getVersion()), attachment.getDownloadPath(), attachment.getLastModificationDate(), baselinePage.getOriginalVersionId() != null ? baselinePage.getOriginalVersionId().toString() : baselinePage.getIdAsString()));
            }
            catch (Exception e) {
                LOGGER.error("An error occurred during evaluation of attachment.", (Throwable)e);
            }
        }
        return baselineAttachments;
    }

    @Override
    public Set<String> getPermittedPageIds(ConfluenceUser user, Baseline baseline) {
        Set pageIds = baseline.getPageIds().stream().map(Long::parseLong).collect(Collectors.toSet());
        List pages = this.pageManager.getPages(pageIds);
        List permittedPages = this.permissionManager.getPermittedEntities((User)user, Permission.VIEW, pages);
        HashSet<String> permittedPageIds = new HashSet<String>(permittedPages.size());
        for (Page permittedPage : permittedPages) {
            permittedPageIds.add(String.valueOf(permittedPage.getId()));
        }
        return permittedPageIds;
    }
}

