/*
 * Decompiled with CFR 0.152.
 */
package tr.com.obss.plugin.rest;

import com.atlassian.json.jsonorg.JSONArray;
import com.atlassian.json.jsonorg.JSONObject;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import tr.com.obss.plugin.utils.Utils;

@Path(value="/groupService")
public class GroupRestService {
    private static final int MAX_RESULT_COUNT = 10;

    @GET
    @Path(value="/searchGroups")
    public Response searchGroups(@QueryParam(value="query") String query, @QueryParam(value="page") int page, @QueryParam(value="selectedGroups") List<String> selectedGroups) {
        return Response.ok((Object)this.generateGroupsJson(query, page, selectedGroups), (String)"application/json").build();
    }

    private String generateGroupsJson(String query, int page, List<String> selectedGroups) {
        int startIndex = (page - 1) * 10;
        int endIndex = startIndex + 10 - 1;
        List<String> foundGroupNames = this.getGroupNamesByQuery(query, selectedGroups);
        int totalGroupCount = foundGroupNames.size();
        if (endIndex >= totalGroupCount) {
            endIndex = totalGroupCount - 1;
        }
        boolean more = endIndex < totalGroupCount - 1;
        List<String> groupNamesInPage = foundGroupNames.subList(startIndex, endIndex + 1);
        JSONArray groupsJsonArray = new JSONArray();
        for (String groupName : groupNamesInPage) {
            JSONObject groupJson = new JSONObject();
            groupJson.put("name", (Object)groupName);
            groupsJsonArray.put((Object)groupJson);
        }
        JSONObject groupsJson = new JSONObject();
        groupsJson.put("groups", (Object)groupsJsonArray);
        groupsJson.put("more", more);
        return groupsJson.toString();
    }

    private List<String> getGroupNamesByQuery(String query, List<String> selectedGroups) {
        if (selectedGroups == null) {
            selectedGroups = new ArrayList<String>();
        }
        query = query != null ? query.trim().toLowerCase() : "";
        ArrayList<String> foundGroupNames = new ArrayList<String>();
        List<String> allGroupNames = Utils.getAllGroupNames();
        for (String groupName : allGroupNames) {
            if (!groupName.toLowerCase().contains(query) || selectedGroups.contains(groupName)) continue;
            foundGroupNames.add(groupName);
        }
        return foundGroupNames;
    }
}

