/*
 * Decompiled with CFR 0.152.
 */
package tr.com.obss.plugin.extra.flyingpdf;

import com.atlassian.confluence.core.persistence.confluence.SessionFactoryTypeEnum;
import com.atlassian.confluence.core.persistence.confluence.SessionFactoryTypeThreadLocal;
import com.atlassian.confluence.importexport.ImportExportManager;
import com.atlassian.confluence.importexport.impl.ExportFileNameGenerator;
import com.atlassian.confluence.pages.ContentTree;
import com.atlassian.confluence.renderer.radeox.macros.MacroUtils;
import com.atlassian.confluence.security.GateKeeper;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.util.i18n.I18NBean;
import com.atlassian.confluence.util.longrunning.ConfluenceAbstractLongRunningTask;
import com.atlassian.confluence.util.velocity.VelocityUtils;
import com.atlassian.core.task.longrunning.AbstractLongRunningTask;
import com.atlassian.sal.api.transaction.TransactionCallback;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.user.User;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.util.Collections;
import org.apache.commons.lang3.StringUtils;
import org.apache.velocity.context.Context;
import tr.com.obss.plugin.extra.flyingpdf.PdfExportSemaphore;

public class ContentTreeLongRunningTask
extends ConfluenceAbstractLongRunningTask {
    private final ImportExportManager importExportManager;
    private final TransactionTemplate transactionTemplate;
    private final I18NBean i18NBean;
    private final Space space;
    private final User user;
    private final GateKeeper gateKeeper;
    private final String contextPath;
    private final ExportFileNameGenerator pdfExportFileNameGenerator;
    private final PdfExportSemaphore pdfExportSemaphore;
    private String downloadPath;

    public ContentTreeLongRunningTask(ImportExportManager importExportManager, TransactionTemplate transactionTemplate, I18NBean i18NBean, Space space, User user, GateKeeper gateKeeper, String contextPath, ExportFileNameGenerator pdfExportFileNameGenerator, PdfExportSemaphore pdfExportSemaphore) {
        this.importExportManager = importExportManager;
        this.transactionTemplate = transactionTemplate;
        this.i18NBean = i18NBean;
        this.space = space;
        this.user = user;
        this.gateKeeper = gateKeeper;
        this.contextPath = contextPath;
        this.pdfExportFileNameGenerator = pdfExportFileNameGenerator;
        this.pdfExportSemaphore = pdfExportSemaphore;
    }

    protected void runInternal() {
        try {
            this.pdfExportSemaphore.run(this::doRunInternal);
        }
        catch (RuntimeException e) {
            this.progress.setCompletedSuccessfully(false);
            this.progress.setStatus(e.getMessage());
        }
    }

    private void doRunInternal() {
        SessionFactoryTypeThreadLocal.set((SessionFactoryTypeEnum)SessionFactoryTypeEnum.NON_CACHING);
        try {
            this.transactionTemplate.execute((TransactionCallback)new TransactionCallback<Void>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Void doInTransaction() {
                    try {
                        ContentTreeLongRunningTask.this.initProgress();
                        ContentTree contentTree = ContentTreeLongRunningTask.this.importExportManager.getContentTree(ContentTreeLongRunningTask.this.user, ContentTreeLongRunningTask.this.space);
                        Context context = MacroUtils.createDefaultVelocityContext();
                        context.put("contentTree", (Object)contentTree);
                        File file = ContentTreeLongRunningTask.this.pdfExportFileNameGenerator.getExportFile(new String[]{"confluence.extra.content-tree-builder-"});
                        try (FileWriter writer = new FileWriter(file);){
                            VelocityUtils.writeRenderedTemplate((Writer)writer, (String)"/templates/extra/pdfexport/obss-export-space-common-tree.vm", (Context)context);
                        }
                        ContentTreeLongRunningTask.this.downloadPath = ContentTreeLongRunningTask.this.importExportManager.prepareDownloadPath(file.getAbsolutePath());
                        ContentTreeLongRunningTask.this.gateKeeper.addKey(ContentTreeLongRunningTask.this.downloadPath, ContentTreeLongRunningTask.this.user);
                        ContentTreeLongRunningTask.this.downloadPath = ContentTreeLongRunningTask.this.contextPath + ContentTreeLongRunningTask.this.downloadPath;
                        ContentTreeLongRunningTask.this.updateProgress(ContentTreeLongRunningTask.this.downloadPath);
                    }
                    catch (Exception e) {
                        AbstractLongRunningTask.log.error((Object)"Error during building content tree for PDF export", (Throwable)e);
                        ContentTreeLongRunningTask.this.updateProgress(e);
                    }
                    return null;
                }
            });
        }
        finally {
            SessionFactoryTypeThreadLocal.clear();
        }
    }

    private void updateProgress(Exception e) {
        String exceptionMessage = e.getMessage();
        if (StringUtils.isBlank((CharSequence)exceptionMessage)) {
            exceptionMessage = e.getClass().getName();
        }
        this.progress.setPercentage(100);
        this.progress.setCompletedSuccessfully(false);
        this.progress.setStatus(this.i18NBean.getText("com.atlassian.confluence.extra.flyingpdf.progress.contenttreeerrored", Collections.singletonList(exceptionMessage)));
    }

    private void updateProgress(String downloadPath) {
        this.progress.setPercentage(100);
        this.progress.setCompletedSuccessfully(true);
        this.progress.setStatus(downloadPath);
    }

    private void initProgress() {
        this.progress.setPercentage(0);
        this.progress.setStatus("");
    }

    public String getName() {
        return "Content tree build for PDF export";
    }

    public String getDownloadPath() {
        return this.downloadPath;
    }
}

