/*
 * Decompiled with CFR 0.152.
 */
package tr.com.obss.plugin.export;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.persistence.hibernate.CacheMode;
import com.atlassian.confluence.core.persistence.hibernate.SessionCacheModeThreadLocal;
import com.atlassian.confluence.importexport.ImportExportManager;
import com.atlassian.confluence.pages.ContentNode;
import com.atlassian.confluence.pages.ContentTree;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.security.GateKeeper;
import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.util.RequestCacheThreadLocal;
import com.atlassian.confluence.util.longrunning.ConfluenceAbstractLongRunningTask;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.user.User;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tr.com.obss.plugin.dto.Baseline;
import tr.com.obss.plugin.dto.BaselinePage;
import tr.com.obss.plugin.export.BaselinePdfExportProcess;
import tr.com.obss.plugin.extra.flyingpdf.PdfExportProgressMonitor;
import tr.com.obss.plugin.extra.flyingpdf.PdfExportSemaphore;
import tr.com.obss.plugin.extra.flyingpdf.PdfExporterService;
import tr.com.obss.plugin.extra.flyingpdf.analytic.SpaceExportMetrics;
import tr.com.obss.plugin.utils.FileUtils;

public class BaselinePdfExportLongRunningTask
extends ConfluenceAbstractLongRunningTask {
    private static final Logger log = LoggerFactory.getLogger(BaselinePdfExportLongRunningTask.class);
    private PdfExporterService pdfExporterService;
    private GateKeeper gateKeeper;
    private BootstrapManager bootstrapManager;
    private BaselinePdfExportProcess exportProcess;
    private Baseline baseline;
    private String contextPath;
    private Space space;
    private User user;
    private TransactionTemplate transactionTemplate;
    private ImportExportManager importExportManager;
    private PageManager pageManager;
    private PdfExportSemaphore pdfExportSemaphore;

    public BaselinePdfExportLongRunningTask(BaselinePdfExportProcess exportProcess, Baseline baseline, String contextPath, Space space, User user) {
        this.exportProcess = exportProcess;
        this.baseline = baseline;
        this.contextPath = contextPath;
        this.space = space;
        this.user = user;
        exportProcess.setProgressMeter(this.progress);
    }

    protected void runInternal() {
        try {
            this.pdfExportSemaphore.run(this::doRunInternal);
        }
        catch (RuntimeException e) {
            log.error("Error while running baseline export task.", (Throwable)e);
            this.progress.setCompletedSuccessfully(false);
            this.progress.setStatus(e.getMessage());
            this.progress.setPercentage(100);
        }
    }

    protected void doRunInternal() {
        SessionCacheModeThreadLocal.set((CacheMode)CacheMode.IGNORE);
        try {
            this.transactionTemplate.execute(() -> {
                AuthenticatedUserThreadLocal.set((ConfluenceUser)((ConfluenceUser)this.user));
                RequestCacheThreadLocal.getRequestCache().put("confluence.context.path", this.contextPath);
                PdfExportProgressMonitor monitor = this.pdfExporterService.createProgressMonitor(this.progress);
                try {
                    monitor.beginCalculationOfContentTree();
                    HashMap<String, Integer> pagesToBeExported = new HashMap<String, Integer>();
                    for (BaselinePage pagePOJO : this.baseline.getPages()) {
                        String pageId = pagePOJO.getId();
                        String pageVersion = pagePOJO.getVersion();
                        if (pageId == null || pageVersion == null) {
                            log.debug("Invalid baseline page for pdf export. pageId: {}, pageVersion: {}", (Object)pageId, (Object)pageVersion);
                            continue;
                        }
                        pagesToBeExported.put(pageId, Integer.valueOf(pageVersion));
                    }
                    ContentTree contentTree = this.importExportManager.getContentTree(this.user, this.space);
                    ArrayList pageIds = new ArrayList(pagesToBeExported.keySet());
                    contentTree.filter(pageIds);
                    for (ContentNode node : contentTree.getAllContentNodes()) {
                        Page prevPage = node.getPage();
                        if (prevPage.getVersion() == ((Integer)pagesToBeExported.get(prevPage.getIdAsString())).intValue()) continue;
                        Page page = (Page)this.pageManager.getOtherVersion((ContentEntityObject)prevPage, ((Integer)pagesToBeExported.get(prevPage.getIdAsString())).intValue());
                        node.setPage(page);
                    }
                    monitor.completedCalculationOfContentTree(contentTree.size());
                    String baselineNameForFile = this.exportProcess.getBaselineName().replaceAll("[\\\\/:*?\"<>|]", "_");
                    File resultPdf = this.pdfExporterService.createPdfForBaseline(baselineNameForFile, this.user, contentTree, this.contextPath, this.space, new SpaceExportMetrics(), monitor);
                    String downloadPath = FileUtils.getDownloadPath(resultPdf, this.bootstrapManager);
                    this.gateKeeper.addKey(downloadPath, this.user);
                    downloadPath = this.contextPath + downloadPath;
                    monitor.completed(downloadPath);
                }
                catch (Exception e) {
                    log.error("Error during PDF export", (Throwable)e);
                    String exceptionMessage = e.getMessage();
                    if (StringUtils.isBlank((CharSequence)exceptionMessage)) {
                        exceptionMessage = e.getClass().getName();
                    }
                    monitor.errored(exceptionMessage);
                }
                return null;
            });
        }
        finally {
            SessionCacheModeThreadLocal.set((CacheMode)CacheMode.NORMAL);
        }
    }

    public void setPdfExporterService(PdfExporterService pdfExporterService) {
        this.pdfExporterService = pdfExporterService;
    }

    public void setGateKeeper(GateKeeper gateKeeper) {
        this.gateKeeper = gateKeeper;
    }

    public void setBootstrapManager(BootstrapManager bootstrapManager) {
        this.bootstrapManager = bootstrapManager;
    }

    public void setTransactionTemplate(TransactionTemplate transactionTemplate) {
        this.transactionTemplate = transactionTemplate;
    }

    public void setImportExportManager(ImportExportManager importExportManager) {
        this.importExportManager = importExportManager;
    }

    public void setPdfExportSemaphore(PdfExportSemaphore pdfExportSemaphore) {
        this.pdfExportSemaphore = pdfExportSemaphore;
    }

    public void setPageManager(PageManager pageManager) {
        this.pageManager = pageManager;
    }

    public String getName() {
        return "Baseline PDF Export Task";
    }
}

