/*
 * Decompiled with CFR 0.152.
 */
package tr.com.obss.plugin.dto.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import tr.com.obss.plugin.dto.Baseline;
import tr.com.obss.plugin.dto.BaselineAttachment;
import tr.com.obss.plugin.dto.BaselineDocument;
import tr.com.obss.plugin.dto.BaselineDocumentTypeQuery;
import tr.com.obss.plugin.dto.BaselinePage;
import tr.com.obss.plugin.dto.impl.BaselineSummaryImpl;
import tr.com.obss.plugin.exception.UnhandledEnumValueException;

public class BaselineImpl
extends BaselineSummaryImpl
implements Baseline {
    private String spaceKey;
    private String creator;
    private String keyword;
    private Map<String, BaselinePage> pagesById;
    private List<BaselineDocument> allDocuments;
    private List<BaselineDocument> pageDocuments;
    private List<BaselineDocument> attachmentDocuments;

    public BaselineImpl(String name, Date creationDate, Date baselineDate, String spaceKey, String creator, String keyword, List<BaselinePage> pages) {
        super(name, baselineDate, creationDate);
        this.spaceKey = spaceKey;
        this.creator = creator;
        this.keyword = keyword;
        this.generateDocumentCollections(pages);
    }

    private void generateDocumentCollections(List<BaselinePage> pages) {
        this.pagesById = new HashMap<String, BaselinePage>();
        this.allDocuments = new ArrayList<BaselineDocument>();
        this.pageDocuments = new ArrayList<BaselineDocument>();
        this.attachmentDocuments = new ArrayList<BaselineDocument>();
        if (pages == null) {
            return;
        }
        for (BaselinePage page : pages) {
            this.allDocuments.add(page);
            this.allDocuments.addAll(page.getAttachments());
            this.pagesById.put(page.getId(), page);
            this.pageDocuments.add(page);
            this.attachmentDocuments.addAll(page.getAttachments());
        }
    }

    @Override
    public String getSpaceKey() {
        return this.spaceKey;
    }

    @Override
    public String getCreator() {
        return this.creator;
    }

    @Override
    public String getKeyword() {
        return this.keyword;
    }

    @Override
    public List<BaselinePage> getPages() {
        return new ArrayList<BaselinePage>(this.pagesById.values());
    }

    @Override
    public List<BaselineDocument> getAllDocuments() {
        return this.allDocuments;
    }

    @Override
    public List<BaselineDocument> getPageDocuments() {
        return this.pageDocuments;
    }

    @Override
    public List<BaselineDocument> getAttachmentDocuments() {
        return this.attachmentDocuments;
    }

    @Override
    public int getPageCount() {
        return this.pagesById.size();
    }

    @Override
    public int getAttachmentCount(@Nullable Set<String> permittedPageIds) {
        int attachmentCount = 0;
        for (BaselinePage baselinePage : this.pagesById.values()) {
            List<BaselineAttachment> attachments;
            if (permittedPageIds != null && !permittedPageIds.contains(baselinePage.getId()) || (attachments = baselinePage.getAttachments()) == null) continue;
            attachmentCount += attachments.size();
        }
        return attachmentCount;
    }

    @Override
    public int getTotalDocumentCount() {
        return this.allDocuments.size();
    }

    @Override
    public int getTotalDocumentCountByType(BaselineDocumentTypeQuery documentType) throws UnhandledEnumValueException {
        if (BaselineDocumentTypeQuery.PAGE.equals((Object)documentType)) {
            return this.pageDocuments.size();
        }
        if (BaselineDocumentTypeQuery.ATTACHMENT.equals((Object)documentType)) {
            return this.attachmentDocuments.size();
        }
        if (BaselineDocumentTypeQuery.ANY_DOCUMENT.equals((Object)documentType)) {
            return this.allDocuments.size();
        }
        throw new UnhandledEnumValueException();
    }

    @Override
    public int getTotalDocumentCountByTypeStr(String documentType) throws UnhandledEnumValueException {
        return this.getTotalDocumentCountByType(BaselineDocumentTypeQuery.getByValue(documentType));
    }

    @Override
    public BaselinePage getPageById(String pageId) {
        return this.pagesById.get(pageId);
    }
}

