/*
 * Decompiled with CFR 0.152.
 */
package tr.com.obss.plugin.servlet;

import com.atlassian.config.ApplicationConfiguration;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.json.jsonorg.JSONException;
import com.atlassian.json.jsonorg.JSONObject;
import com.atlassian.renderer.v2.components.HtmlEscaper;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.xwork.RequireSecurityToken;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tr.com.obss.plugin.baseline.BaselineService;
import tr.com.obss.plugin.services.PermissionService;
import tr.com.obss.plugin.utils.UserHasCondition;
import tr.com.obss.plugin.utils.Utils;

public class BaseLineDeleteServlet
extends HttpServlet {
    private static final long serialVersionUID = -4682475343896576658L;
    private static final Logger LOG = LoggerFactory.getLogger(BaseLineDeleteServlet.class);
    private final ApplicationConfiguration applicationConfiguration;
    private final SpaceManager spaceManager;
    private final UserHasCondition userHasCondition;
    private final PluginLicenseManager licenseManager;
    private final BaselineService baselineService;
    private final PermissionService permissionService;

    public BaseLineDeleteServlet(ApplicationConfiguration applicationConfiguration, SpaceManager spaceManager, PermissionService permissionService, BaselineService baselineService, PluginSettingsFactory pluginSettingsFactory, UserAccessor userAccessor, PluginLicenseManager licenseManager) {
        this.applicationConfiguration = applicationConfiguration;
        this.spaceManager = spaceManager;
        this.baselineService = baselineService;
        this.permissionService = permissionService;
        this.userHasCondition = new UserHasCondition(userAccessor, pluginSettingsFactory);
        this.licenseManager = licenseManager;
    }

    @RequireSecurityToken(value=true)
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) {
        if (AuthenticatedUserThreadLocal.get() == null) {
            this.sendResponseToClient(resp, 403, "You are not authorized for this operation.");
            return;
        }
        if (!Utils.isLicenseValid(this.licenseManager)) {
            this.sendResponseToClient(resp, 403, "Your Baselines for Confluence license has expired.");
            return;
        }
        if (Utils.isReadOnlyModeEnabled(this.applicationConfiguration)) {
            this.sendResponseToClient(resp, 403, "Read-only mode is enabled. You cannot create baseline right now.");
            return;
        }
        String spaceKey = req.getParameter("space");
        String baselineName = req.getParameter("baseline");
        LOG.debug("Delete request received for baseline '{}' of space '{}' ", (Object)baselineName, (Object)spaceKey);
        Space space = this.spaceManager.getSpace(spaceKey);
        if (space == null) {
            LOG.debug("There is no space with this key: {} ", (Object)spaceKey);
            return;
        }
        boolean userCanViewSpace = this.permissionService.userCanViewSpace(space);
        if (!userCanViewSpace) {
            this.sendResponseToClient(resp, 403, "You are not authorized for this operation.");
            return;
        }
        Boolean isInViewGroups = this.userHasCondition.isInViewGroups(AuthenticatedUserThreadLocal.getUsername());
        Boolean isInDeleteGroups = this.userHasCondition.isInDeleteGroups(AuthenticatedUserThreadLocal.getUsername());
        if (isInDeleteGroups.booleanValue() && isInViewGroups.booleanValue()) {
            this.baselineService.deleteBaseline(space, baselineName);
            LOG.debug("Baseline '{}' of space '{}' removed ", (Object)baselineName, (Object)spaceKey);
        } else {
            LOG.error("You are not authorized for deleting baselines.");
            this.sendResponseToClient(resp, 403, "You are not authorized for this operation.");
        }
    }

    private void sendResponseToClient(HttpServletResponse response, int httpStatus, String message) {
        this.sendResponseToClient(response, httpStatus, message, new ArrayList<String>());
    }

    private void sendResponseToClient(HttpServletResponse response, int httpStatus, String message, List<String> warnings) {
        try {
            List<String> escapedWarnings = warnings.stream().map(warning -> HtmlEscaper.escapeAll((String)warning, (boolean)false)).collect(Collectors.toList());
            response.setStatus(httpStatus);
            response.getWriter().write(this.getResultJSON(HtmlEscaper.escapeAll((String)message, (boolean)false), escapedWarnings));
        }
        catch (IOException e) {
            LOG.error("Error while sending response to client.", (Throwable)e);
            try {
                response.sendError(500, "An unexpected error occurred while processing your request: " + HtmlEscaper.escapeAll((String)e.getMessage(), (boolean)false));
            }
            catch (IOException e2) {
                LOG.error(e2.getMessage(), (Throwable)e2);
            }
        }
    }

    private String getResultJSON(String message, List<String> warnings) {
        try {
            JSONObject resultJSON = new JSONObject();
            resultJSON.put("message", (Object)message);
            resultJSON.put("warnings", warnings);
            return resultJSON.toString();
        }
        catch (JSONException e) {
            LOG.error("Error while creating json.", (Throwable)e);
            return "{}";
        }
    }
}

