/*
 * Decompiled with CFR 0.152.
 */
package tr.com.obss.plugin.extra.flyingpdf.config;

import com.atlassian.confluence.event.events.cluster.ClusterEventWrapper;
import com.atlassian.event.Event;
import com.atlassian.event.EventListener;
import java.io.IOException;
import org.apache.log4j.Logger;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;
import tr.com.obss.plugin.extra.flyingpdf.config.CustomFontInstalledEvent;
import tr.com.obss.plugin.extra.flyingpdf.config.CustomFontRemovedEvent;
import tr.com.obss.plugin.extra.flyingpdf.config.FontDao;

public class CustomFontClusterEventListener
implements EventListener {
    private static final Logger log = Logger.getLogger(CustomFontClusterEventListener.class);
    private static final Class[] HANDLED_CLASSES = new Class[]{ClusterEventWrapper.class};
    private FontDao fontDao;

    public void handleEvent(Event event) {
        if (event instanceof ClusterEventWrapper) {
            ClusterEventWrapper clusterEventWrapper = (ClusterEventWrapper)event;
            Event wrappedEvent = clusterEventWrapper.getEvent();
            if (wrappedEvent instanceof CustomFontInstalledEvent) {
                this.handleInstallEvent((CustomFontInstalledEvent)wrappedEvent);
            } else if (wrappedEvent instanceof CustomFontRemovedEvent) {
                this.handleRemoveEvent((CustomFontRemovedEvent)wrappedEvent);
            }
        }
    }

    private void handleRemoveEvent(CustomFontRemovedEvent event) {
        try {
            this.fontDao.removeFont(event.getFontName());
        }
        catch (IOException e) {
            log.error((Object)("Unable to remove custom PDF font: " + event.getFontName() + " - " + e.getMessage()), (Throwable)e);
        }
    }

    private void handleInstallEvent(CustomFontInstalledEvent event) {
        ByteArrayResource resource = new ByteArrayResource(event.getFontData());
        try {
            this.fontDao.saveFont(event.getFontName(), (Resource)resource);
        }
        catch (IOException ex) {
            log.error((Object)("Unable to install custom PDF font: " + event.getFontName() + " - " + ex.getMessage()), (Throwable)ex);
        }
    }

    public Class[] getHandledEventClasses() {
        return HANDLED_CLASSES;
    }

    public void setPdfExportFontsDirectoryFontDao(FontDao pdfExportFontsDirectoryFontDao) {
        this.fontDao = pdfExportFontsDirectoryFontDao;
    }
}

