/*
 * Decompiled with CFR 0.152.
 */
package tr.com.obss.plugin.collector.page;

import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.spaces.Space;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tr.com.obss.plugin.ServiceAccessor;
import tr.com.obss.plugin.collector.attachment.AttachmentCollector;
import tr.com.obss.plugin.dto.CollectedPageMap;
import tr.com.obss.plugin.dto.SelectedPage;
import tr.com.obss.plugin.exception.BaselineParameterException;
import tr.com.obss.plugin.progress.BaselineProgressTracker;
import tr.com.obss.plugin.progress.SimpleBaselineProgress;
import tr.com.obss.plugin.utils.Utils;

public abstract class PageCollector {
    protected static final Logger log = LoggerFactory.getLogger(PageCollector.class);
    protected final Space space;
    protected final List<String> warnings;
    protected final PageManager pageManager = ServiceAccessor.getPageManager();
    protected AttachmentCollector attachmentCollector = new AttachmentCollector();
    protected SimpleBaselineProgress baselineProgress;
    private final Set<String> selectedPageIdsToSkipDescendants = new HashSet<String>();
    private final Set<String> selectedPageIdsToIgnore = new HashSet<String>();

    protected PageCollector(Space space) {
        this.space = space;
        this.warnings = new ArrayList<String>();
    }

    public void registerBaselineProgress(UUID operationId) {
        this.baselineProgress = (SimpleBaselineProgress)BaselineProgressTracker.getProgress(operationId);
    }

    public void progressUpdateEvent() {
        if (Objects.nonNull(this.baselineProgress)) {
            this.baselineProgress.tick();
        }
    }

    public abstract CollectedPageMap collect() throws BaselineParameterException;

    public List<String> getWarnings() {
        return this.warnings;
    }

    public boolean shouldSkipDescendants(String selectedPageId) {
        return this.selectedPageIdsToSkipDescendants.contains(selectedPageId);
    }

    public boolean shouldIgnore(String selectedPageId) {
        return this.selectedPageIdsToIgnore.contains(selectedPageId);
    }

    protected void detectRedundantPageCollections(List<SelectedPage> partiallySelectedPages, List<SelectedPage> fullySelectedPages) {
        if (CollectionUtils.isEmpty(fullySelectedPages) || partiallySelectedPages == null || fullySelectedPages.size() + partiallySelectedPages.size() <= 1) {
            return;
        }
        HashMap pageIdToSelectionType = new HashMap();
        partiallySelectedPages.forEach(page -> pageIdToSelectionType.put(page.getNonPrefixId(), "partially"));
        fullySelectedPages.forEach(page -> pageIdToSelectionType.put(page.getNonPrefixId(), "fully"));
        partiallySelectedPages.forEach(page -> this.checkRedundantSelection((SelectedPage)page, pageIdToSelectionType, false));
        fullySelectedPages.forEach(page -> this.checkRedundantSelection((SelectedPage)page, pageIdToSelectionType, true));
    }

    private void checkRedundantSelection(SelectedPage selectedPage, Map<String, String> pageIdToSelectionType, boolean isFullySelected) {
        Page page = this.pageManager.getPage(Utils.convertPageId(selectedPage.getId()).longValue());
        if (page == null) {
            this.warnings.add(String.format("Page not found with id %s.", selectedPage.getId()));
            return;
        }
        Page fullySelectedAncestor = page.getAncestors().stream().filter(ancestor -> "fully".equals(pageIdToSelectionType.get(ancestor.getIdAsString()))).findFirst().orElse(null);
        if (fullySelectedAncestor == null) {
            return;
        }
        if (selectedPage.isLatestVersion()) {
            this.selectedPageIdsToIgnore.add(selectedPage.getNonPrefixId());
        } else if (isFullySelected) {
            this.selectedPageIdsToSkipDescendants.add(selectedPage.getNonPrefixId());
        }
    }
}

