/*
 * Decompiled with CFR 0.152.
 */
package tr.com.obss.plugin.extra.flyingpdf;

import com.atlassian.confluence.cluster.ClusterManager;
import com.atlassian.confluence.cluster.ClusterNodeInformation;
import com.atlassian.confluence.importexport.ImportExportException;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.ContentTree;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.core.util.ProgressMeter;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.user.User;
import java.io.File;
import java.util.Optional;
import tr.com.obss.plugin.extra.flyingpdf.DelegatingPdfExporterService;
import tr.com.obss.plugin.extra.flyingpdf.PdfExportProgressMonitor;
import tr.com.obss.plugin.extra.flyingpdf.PdfExporterService;
import tr.com.obss.plugin.extra.flyingpdf.analytic.EnvironmentInfo;
import tr.com.obss.plugin.extra.flyingpdf.analytic.ExportResults;
import tr.com.obss.plugin.extra.flyingpdf.analytic.ExportScope;
import tr.com.obss.plugin.extra.flyingpdf.analytic.ExportStatus;
import tr.com.obss.plugin.extra.flyingpdf.analytic.FailureLocation;
import tr.com.obss.plugin.extra.flyingpdf.analytic.PageExportMetrics;
import tr.com.obss.plugin.extra.flyingpdf.analytic.PdfExportAnalyticEvent;
import tr.com.obss.plugin.extra.flyingpdf.analytic.SandboxStatus;
import tr.com.obss.plugin.extra.flyingpdf.analytic.SpaceExportMetrics;
import tr.com.obss.plugin.extra.flyingpdf.html.DecorationPolicy;

public class DiagnosticPdfExporterService
implements PdfExporterService {
    private DelegatingPdfExporterService delegate;
    private EventPublisher eventPublisher;
    private ClusterManager clusterManager;

    @Override
    public File createPdfForSpace(User user, Space space, ContentTree contentTree, PdfExportProgressMonitor progress, String contextPath, SpaceExportMetrics spaceExportMetrics, DecorationPolicy decorations) throws ImportExportException {
        spaceExportMetrics.getEnvironmentInfo().setSpaceKey(space.getKey());
        spaceExportMetrics.setConfluencePages(contentTree.size());
        spaceExportMetrics.getEnvironmentInfo().setExportScope(ExportScope.SPACE);
        this.fillEnvironmentData(space, spaceExportMetrics.getEnvironmentInfo());
        long startTime = System.currentTimeMillis();
        try {
            File result = this.delegate.createPdfForSpace(user, space, contentTree, progress, contextPath, spaceExportMetrics, decorations);
            spaceExportMetrics.getExportResults().setExportStatus(ExportStatus.OK);
            File file = result;
            return file;
        }
        catch (Exception e) {
            this.setGenericError(spaceExportMetrics.getExportResults());
            throw e;
        }
        finally {
            spaceExportMetrics.setTotalTime((int)(System.currentTimeMillis() - startTime));
            this.sendToAnalytics(new PdfExportAnalyticEvent(spaceExportMetrics));
        }
    }

    @Override
    public File createPdfForPage(User user, AbstractPage page, String contextPath, PageExportMetrics pageExportMetrics) throws ImportExportException {
        pageExportMetrics.setPageId(page.getId());
        pageExportMetrics.setPageRevision(page.getConfluenceRevision().hashCode());
        pageExportMetrics.getEnvironmentInfo().setExportScope(ExportScope.PAGE);
        this.fillEnvironmentData(page.getSpace(), pageExportMetrics.getEnvironmentInfo());
        try {
            File file = this.delegate.createPdfForPage(user, page, contextPath, pageExportMetrics);
            return file;
        }
        catch (Exception e) {
            pageExportMetrics.getExportResults().setFailureLocation(FailureLocation.PAGE);
            this.setGenericError(pageExportMetrics.getExportResults());
            throw e;
        }
        finally {
            this.sendToAnalytics(new PdfExportAnalyticEvent(pageExportMetrics));
        }
    }

    private void setGenericError(ExportResults results) {
        if (results.getExportStatus() == null) {
            results.setExportStatus(ExportStatus.FAIL);
            results.setFailureLocation(FailureLocation.INTERNAL);
        }
    }

    private void fillEnvironmentData(Space space, EnvironmentInfo environmentInfo) {
        if (this.clusterManager.isClustered()) {
            environmentInfo.setDcNodeId(Optional.ofNullable(this.clusterManager.getThisNodeInformation()).map(ClusterNodeInformation::getAnonymizedNodeIdentifier).map(Object::hashCode).orElse(-1));
        }
        environmentInfo.setSpaceKey(space.getKey());
        environmentInfo.setSandboxStatus(this.delegate.sandboxIsUsed() ? SandboxStatus.USED : SandboxStatus.NOT_USED);
    }

    @Override
    public ContentTree getContentTree(User user, Space space) {
        return this.delegate.getContentTree(user, space);
    }

    @Override
    public boolean isPermitted(User user, AbstractPage page) {
        return this.delegate.isPermitted(user, page);
    }

    @Override
    public boolean isPermitted(User user, Space space) {
        return this.delegate.isPermitted(user, space);
    }

    @Override
    public boolean exportableContentExists(Space space) {
        return this.delegate.exportableContentExists(space);
    }

    @Override
    public PdfExportProgressMonitor createProgressMonitor(ProgressMeter progressMeter) {
        return this.delegate.createProgressMonitor(progressMeter);
    }

    private void sendToAnalytics(PdfExportAnalyticEvent event) {
        this.eventPublisher.publish((Object)event);
    }

    public void setFlyingPdfExporterService(DelegatingPdfExporterService delegate) {
        this.delegate = delegate;
    }

    public void setEventPublisher(EventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }

    public void setClusterManager(ClusterManager clusterManager) {
        this.clusterManager = clusterManager;
    }

    @Override
    public File createPdfForBaseline(String baselineName, User user, ContentTree contentTree, String contextPath, Space space, SpaceExportMetrics spaceExportMetrics, PdfExportProgressMonitor progress) throws ImportExportException {
        return null;
    }
}

