/*
 * Decompiled with CFR 0.152.
 */
package tr.com.obss.plugin.services.impl;

import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.user.User;
import tr.com.obss.plugin.ServiceAccessor;
import tr.com.obss.plugin.services.PermissionService;

public class PermissionServiceImpl
implements PermissionService {
    private final SpaceManager spaceManager = ServiceAccessor.getSpaceManager();
    private final PermissionManager permissionManager = ServiceAccessor.getPermissionManager();

    @Override
    public boolean userCanViewSpace(String spaceKey) {
        Space space = this.spaceManager.getSpace(spaceKey);
        return this.userCanViewSpace(space);
    }

    @Override
    public boolean userCanViewSpace(Space space) {
        ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
        if (space == null) {
            return false;
        }
        return this.permissionManager.hasPermission((User)confluenceUser, Permission.VIEW, (Object)space);
    }

    @Override
    public boolean userCanExportSpace(String spaceKey) {
        Space space = this.spaceManager.getSpace(spaceKey);
        return this.userCanExportSpace(space);
    }

    @Override
    public boolean userCanExportSpace(Space space) {
        ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
        if (space == null) {
            return false;
        }
        return this.permissionManager.hasPermission((User)confluenceUser, Permission.EXPORT, (Object)space);
    }
}

