/*
 * Decompiled with CFR 0.152.
 */
package tr.com.obss.plugin.extra.flyingpdf;

import com.atlassian.confluence.api.service.content.SpaceService;
import com.atlassian.confluence.importexport.ImportExportException;
import com.atlassian.confluence.importexport.ImportExportManager;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.BlogPost;
import com.atlassian.confluence.pages.ContentNode;
import com.atlassian.confluence.pages.ContentTree;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.core.util.ProgressMeter;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.user.User;
import com.atlassian.util.profiling.UtilTimerStack;
import java.io.File;
import java.io.FileNotFoundException;
import org.w3c.dom.Document;
import tr.com.obss.plugin.extra.flyingpdf.ExportPermissionChecker;
import tr.com.obss.plugin.extra.flyingpdf.FlyingSaucerXmlToPdfConverter;
import tr.com.obss.plugin.extra.flyingpdf.PdfExportProgressMonitor;
import tr.com.obss.plugin.extra.flyingpdf.PdfExporterService;
import tr.com.obss.plugin.extra.flyingpdf.ProgressMeterWrappingProgressMonitor;
import tr.com.obss.plugin.extra.flyingpdf.analytic.ExportStatus;
import tr.com.obss.plugin.extra.flyingpdf.analytic.PageExportMetrics;
import tr.com.obss.plugin.extra.flyingpdf.analytic.SpaceExportMetrics;
import tr.com.obss.plugin.extra.flyingpdf.html.DecorationPolicy;
import tr.com.obss.plugin.extra.flyingpdf.html.LinkRenderingDetails;
import tr.com.obss.plugin.extra.flyingpdf.html.XhtmlBuilder;
import tr.com.obss.plugin.extra.flyingpdf.util.PdfUtils;

public class InternalPdfExporterService
implements PdfExporterService {
    private ImportExportManager importExportManager;
    private XhtmlBuilder intermediateHtmlBuilder;
    private FlyingSaucerXmlToPdfConverter flyingPdfDocumentConverter;
    private SpaceService apiSpaceService;
    private I18nResolver i18NBean;
    private ExportPermissionChecker exportPermissionChecker;

    public InternalPdfExporterService(ImportExportManager importExportManager, XhtmlBuilder intermediateHtmlBuilder, FlyingSaucerXmlToPdfConverter flyingPdfDocumentConverter, SpaceService apiSpaceService, I18nResolver i18NBean, ExportPermissionChecker exportPermissionChecker) {
        this.importExportManager = importExportManager;
        this.intermediateHtmlBuilder = intermediateHtmlBuilder;
        this.flyingPdfDocumentConverter = flyingPdfDocumentConverter;
        this.apiSpaceService = apiSpaceService;
        this.i18NBean = i18NBean;
        this.exportPermissionChecker = exportPermissionChecker;
    }

    @Override
    public File createPdfForSpace(User user, Space space, ContentTree contentTree, PdfExportProgressMonitor progress, String contextPath, SpaceExportMetrics spaceExportMetrics, DecorationPolicy decorations) throws ImportExportException {
        this.exportPermissionChecker.checkAuthorization(user, space);
        UtilTimerStack.push((String)"intermediateHtmlBuilderX.buildHtml");
        Document xhtml = this.intermediateHtmlBuilder.buildHtml(contentTree, space, LinkRenderingDetails.anchors(), DecorationPolicy.space().combine(decorations), progress);
        UtilTimerStack.pop((String)"intermediateHtmlBuilderX.buildHtml");
        contentTree = null;
        String spaceKey = this.getSpaceKeyForExportFileName(space.getKey());
        progress.beginHtmlToPdfConversion();
        File file = this.flyingPdfDocumentConverter.convertXhtmlToPdf(spaceKey, xhtml, progress, contextPath);
        spaceExportMetrics.getExportResults().setPdfFileSizeBytes(file.length());
        spaceExportMetrics.getExportResults().setPdfPagesTotal(PdfUtils.numberOfPages(file));
        return file;
    }

    @Override
    public File createPdfForBaseline(String baselineName, User user, ContentTree contentTree, String contextPath, Space space, SpaceExportMetrics spaceExportMetrics, PdfExportProgressMonitor progress) throws ImportExportException {
        this.exportPermissionChecker.checkAuthorization(user, space);
        UtilTimerStack.push((String)"intermediateHtmlBuilderX.buildHtml");
        Document xhtml = this.intermediateHtmlBuilder.buildHtml(contentTree, space, LinkRenderingDetails.anchors(), DecorationPolicy.space().combine(DecorationPolicy.pageNumbers()), progress);
        UtilTimerStack.pop((String)"intermediateHtmlBuilderX.buildHtml");
        contentTree = null;
        String spaceKey = this.getSpaceKeyForExportFileName(space.getKey());
        progress.beginHtmlToPdfConversion();
        File file = this.flyingPdfDocumentConverter.convertXhtmlToPdf(spaceKey + "-" + baselineName, xhtml, progress, contextPath);
        spaceExportMetrics.getExportResults().setPdfFileSizeBytes(file.length());
        spaceExportMetrics.getExportResults().setPdfPagesTotal(PdfUtils.numberOfPages(file));
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public File createPdfForPage(User user, AbstractPage page, String contextPath, PageExportMetrics pageExportMetrics) throws ImportExportException {
        long startTime = System.currentTimeMillis();
        try {
            pageExportMetrics.setPageId(page.getId());
            pageExportMetrics.setPageRevision(page.getConfluenceRevision().hashCode());
            File result = this.doCreatePdfForPage(user, page, contextPath);
            pageExportMetrics.getExportResults().setExportStatus(ExportStatus.OK);
            pageExportMetrics.getExportResults().setPdfPagesTotal(PdfUtils.numberOfPages(result));
            pageExportMetrics.getExportResults().setPdfFileSizeBytes(result.length());
            File file = result;
            return file;
        }
        finally {
            pageExportMetrics.setTimeMs((int)(System.currentTimeMillis() - startTime));
        }
    }

    private File doCreatePdfForPage(User user, AbstractPage page, String contextPath) throws ImportExportException {
        File pdf;
        Document xhtml;
        this.exportPermissionChecker.checkAuthorization(user, page);
        Space space = null;
        if (page instanceof Page) {
            ContentTree tree = this.newContentTree();
            tree.addRootNode(new ContentNode((Page)page));
            space = page.getSpace() != null ? page.getSpace() : page.getLatestVersion().getSpace();
            xhtml = this.intermediateHtmlBuilder.buildHtml(tree, space, LinkRenderingDetails.anchors(), DecorationPolicy.none());
        } else if (page instanceof BlogPost) {
            xhtml = this.intermediateHtmlBuilder.buildHtml((BlogPost)page);
        } else {
            throw new IllegalArgumentException("Only pages and blog post are supported");
        }
        String spaceKey = space != null ? space.getKey() : "";
        try {
            String filename = spaceKey + "-" + (page.getTitle() == null ? Long.valueOf(page.getId()) : page.getTitle().replaceAll("\\s", "")) + "-v" + page.getVersion();
            if (!GeneralUtil.isSafeTitleForFilesystem((String)filename)) {
                filename = spaceKey + "-" + page.getId() + "-v" + page.getVersion();
            }
            pdf = this.flyingPdfDocumentConverter.convertXhtmlToPdf(filename, xhtml, contextPath);
        }
        catch (ImportExportException e) {
            if (e.getCause() instanceof FileNotFoundException) {
                String filename = spaceKey + "-" + page.getId();
                pdf = this.flyingPdfDocumentConverter.convertXhtmlToPdf(filename, xhtml, contextPath);
            }
            throw e;
        }
        return pdf;
    }

    protected ContentTree newContentTree() {
        return new ContentTree();
    }

    @Override
    public ContentTree getContentTree(User user, Space space) {
        return this.importExportManager.getContentTree(user, space);
    }

    @Override
    public boolean isPermitted(User user, AbstractPage page) {
        return this.exportPermissionChecker.isPermitted(user, page);
    }

    @Override
    public boolean isPermitted(User user, Space space) {
        return this.exportPermissionChecker.isPermitted(user, space);
    }

    @Override
    public boolean exportableContentExists(Space space) {
        throw new UnsupportedOperationException("This method is not used.");
    }

    @Override
    public PdfExportProgressMonitor createProgressMonitor(ProgressMeter progressMeter) {
        return new ProgressMeterWrappingProgressMonitor(this.i18NBean, progressMeter);
    }

    private String getSpaceKeyForExportFileName(String spaceKey) {
        if (spaceKey.startsWith("~")) {
            spaceKey = spaceKey.substring(1);
        }
        return spaceKey;
    }
}

