/*
 * Decompiled with CFR 0.152.
 */
package tr.com.obss.plugin.dto;

import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Page;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import tr.com.obss.plugin.dto.CollectedAttachment;
import tr.com.obss.plugin.dto.CollectedPage;

public class CollectedPageMap
extends HashMap<String, CollectedPage> {
    public Page getPageWithPageId(String pageId) {
        if (this.containsKey(pageId)) {
            return ((CollectedPage)this.get(pageId)).getCollectedPageVersion();
        }
        return null;
    }

    public CollectedPage getCollectedPageWithAnyVersionOfPage(Page page) {
        AbstractPage pageLatestVersion = page.getLatestVersion();
        for (String s : this.keySet()) {
            Page currentPage = this.getPageWithPageId(s);
            if (currentPage.getLatestVersion().getId() != pageLatestVersion.getId()) continue;
            return (CollectedPage)this.get(s);
        }
        return null;
    }

    public List<CollectedAttachment> getPageAttachments(Page page) {
        CollectedPage collectedPage = this.getCollectedPageWithAnyVersionOfPage(page);
        if (Objects.nonNull(collectedPage)) {
            return collectedPage.getAttachments();
        }
        return null;
    }

    public boolean containsPageWithSameVersion(CollectedPage collectedPage) {
        return this.containsPageWithSameVersion(collectedPage.getCollectedPageVersion());
    }

    public boolean containsPageWithSameVersion(Page page) {
        CollectedPage currentPage = this.getCollectedPageWithAnyVersionOfPage(page);
        if (Objects.nonNull(currentPage)) {
            return currentPage.getCollectedPageVersion().getVersion() == page.getVersion();
        }
        return false;
    }

    public boolean containsPageWithAnyVersion(Page page) {
        AbstractPage pageLatestVersion = page.getLatestVersion();
        for (String s : this.keySet()) {
            CollectedPage c = (CollectedPage)this.get(s);
            if (!c.getCollectedPageVersion().getLatestVersion().equals((Object)pageLatestVersion)) continue;
            return true;
        }
        return false;
    }

    public boolean containsPageWithAnyVersion(CollectedPage collectedPage) {
        return this.containsPageWithAnyVersion(collectedPage.getCollectedPageVersion());
    }

    public boolean containsSamePageVersionAndAttachments(CollectedPage collectedPage) {
        if (!this.containsPageWithSameVersion(collectedPage)) {
            return false;
        }
        List<CollectedAttachment> currentAttachment = this.getPageAttachments(collectedPage.getCollectedPageVersion());
        List<CollectedAttachment> collectedAttachment = collectedPage.getAttachments();
        if (Objects.isNull(currentAttachment)) {
            return false;
        }
        if (currentAttachment.size() != collectedPage.getAttachments().size()) {
            return false;
        }
        block0: for (CollectedAttachment a : currentAttachment) {
            if (!collectedAttachment.contains(a)) {
                return false;
            }
            for (CollectedAttachment b : collectedAttachment) {
                if (a.getCollectedAttachmentVersion().getId() != b.getCollectedAttachmentVersion().getId()) continue;
                if (a.getCollectedAttachmentVersion().getVersion() == b.getCollectedAttachmentVersion().getVersion()) continue block0;
                return false;
            }
        }
        return true;
    }
}

