/*
 * Decompiled with CFR 0.152.
 */
package tr.com.obss.plugin.progress;

import java.util.ArrayList;
import java.util.List;
import tr.com.obss.plugin.progress.BaselineProgress;
import tr.com.obss.plugin.progress.BaselineProgressPhaseType;

public class PhasedBaselineProgress
implements BaselineProgress {
    private final List<BaselineProgressPhase> phases = new ArrayList<BaselineProgressPhase>();
    private final long startTime = System.currentTimeMillis();
    private int totalPercentage;
    private int currentPercentage;
    private int currentPhaseIndex;

    @Override
    public synchronized int getCurrentPercentage() {
        return this.currentPercentage;
    }

    @Override
    public synchronized void setCompleted() {
        this.currentPercentage = 100;
    }

    @Override
    public long getStartTime() {
        return this.startTime;
    }

    public synchronized void addPhase(BaselineProgressPhaseType phaseType, int percentage, int stepCount) {
        if (this.totalPercentage + percentage > 100) {
            throw new IllegalArgumentException("Total percentage exceeds 100!");
        }
        if (this.indexOfPhase(phaseType) >= 0) {
            throw new IllegalArgumentException("Same phase cannot be added twice!");
        }
        this.phases.add(new BaselineProgressPhase(phaseType, percentage, stepCount));
        this.totalPercentage += percentage;
    }

    public synchronized void tick(BaselineProgressPhaseType phaseType) {
        if (this.currentPercentage == 100) {
            return;
        }
        int indexOfPhase = this.indexOfPhase(phaseType);
        if (indexOfPhase == -1) {
            return;
        }
        if (indexOfPhase < this.currentPhaseIndex) {
            throw new IllegalArgumentException("Completed phases cannot be updated!");
        }
        this.phases.get(indexOfPhase).incCurrentStep();
        this.currentPhaseIndex = indexOfPhase;
        this.calculateCurrentPercentage();
    }

    private void calculateCurrentPercentage() {
        int calculatedPercentage = 0;
        for (int i = 0; i < this.currentPhaseIndex; ++i) {
            calculatedPercentage += this.phases.get(i).getPercentage();
        }
        BaselineProgressPhase currentPhase = this.phases.get(this.currentPhaseIndex);
        double currentPhasePercentage = 100.0 * (double)currentPhase.getCurrentStep() / (double)currentPhase.getStepCount();
        if ((calculatedPercentage += (int)((double)currentPhase.getPercentage() / 100.0 * currentPhasePercentage)) >= 100) {
            calculatedPercentage = 99;
        }
        this.currentPercentage = calculatedPercentage;
    }

    private int indexOfPhase(BaselineProgressPhaseType phaseType) {
        for (int i = 0; i < this.phases.size(); ++i) {
            if (this.phases.get(i).getType() != phaseType) continue;
            return i;
        }
        return -1;
    }

    private static class BaselineProgressPhase {
        private final BaselineProgressPhaseType type;
        private final int percentage;
        private final int stepCount;
        private int currentStep;

        BaselineProgressPhase(BaselineProgressPhaseType type, int percentage, int stepCount) {
            if (percentage <= 0) {
                throw new IllegalArgumentException("percentage must be greater than zero!");
            }
            if (stepCount <= 0) {
                throw new IllegalArgumentException("stepCount must be greater than zero!");
            }
            this.type = type;
            this.percentage = percentage;
            this.stepCount = stepCount;
        }

        private BaselineProgressPhaseType getType() {
            return this.type;
        }

        private int getPercentage() {
            return this.percentage;
        }

        private int getStepCount() {
            return this.stepCount;
        }

        private int getCurrentStep() {
            return this.currentStep;
        }

        private void incCurrentStep() {
            ++this.currentStep;
            if (this.currentStep > this.stepCount) {
                this.currentStep = this.stepCount;
            }
        }
    }
}

