/*
 * Decompiled with CFR 0.152.
 */
package tr.com.obss.plugin.extra.flyingpdf.config;

import com.atlassian.config.util.BootstrapUtils;
import com.atlassian.core.util.FileUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import tr.com.obss.plugin.extra.flyingpdf.config.FontDao;

public class FontsDirectoryFontDao
implements FontDao {
    private static final String FONTS_DIR = "fonts";

    @Override
    public Resource getFont(String fontName) throws IOException {
        File fontFile = new File(FontsDirectoryFontDao.getBaseFontsDir(), fontName);
        if (!fontFile.exists()) {
            throw new IOException("No font file could be found with the name " + fontName);
        }
        return new FileSystemResource(fontFile);
    }

    @Override
    public void saveFont(String fontName, Resource fontResource) throws IOException {
        this.saveFont(fontName, fontResource, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveFont(String fontName, Resource fontResource, boolean overwrite) throws IOException {
        if (!fontResource.exists()) {
            throw new IOException("Attempting to install a font resource that does not exist: " + fontResource.getDescription());
        }
        File installedFontFile = new File(FontsDirectoryFontDao.getBaseFontsDir(), fontName);
        InputStream istream = fontResource.getInputStream();
        try {
            FileUtils.copyFile((InputStream)istream, (File)installedFontFile, (boolean)overwrite);
        }
        finally {
            IOUtils.closeQuietly((InputStream)istream);
        }
    }

    @Override
    public void removeFont(String fontName) throws IOException {
        FileSystemResource fontResource = (FileSystemResource)this.getFont(fontName);
        File fontFile = fontResource.getFile();
        if (!fontFile.delete()) {
            throw new IOException("Failed to remove the font file " + fontFile.getAbsolutePath());
        }
    }

    private static File getBaseFontsDir() throws IOException {
        File fontDir = new File(BootstrapUtils.getBootstrapManager().getApplicationHome() + File.separator + FONTS_DIR);
        if (!fontDir.exists() && !fontDir.mkdir()) {
            throw new IOException("Failed to create the font directory " + fontDir.getAbsolutePath());
        }
        return fontDir;
    }
}

