/*
 * Decompiled with CFR 0.152.
 */
package tr.com.obss.plugin.pager;

import java.util.ArrayList;
import java.util.List;
import tr.com.obss.plugin.BaselineDocumentPathComparator;
import tr.com.obss.plugin.dto.Baseline;
import tr.com.obss.plugin.dto.BaselineDocument;
import tr.com.obss.plugin.dto.BaselineDocumentTypeQuery;
import tr.com.obss.plugin.exception.UnhandledEnumValueException;

public class BaselinePager {
    private static final int DOCUMENT_PER_PAGE = 100;
    private Baseline baseline;
    private int lastPageNumber;
    private boolean isSinglePage;
    private int totalDocumentCount;
    private BaselineDocumentTypeQuery documentType;

    public BaselinePager(Baseline baseline, BaselineDocumentTypeQuery documentType) throws UnhandledEnumValueException {
        this.documentType = documentType;
        this.totalDocumentCount = baseline.getTotalDocumentCountByType(documentType);
        this.baseline = baseline;
        this.lastPageNumber = (this.totalDocumentCount - 1) / 100 + 1;
        this.isSinglePage = this.lastPageNumber == 1;
    }

    public BaselineViewPage getViewPage(int pageNumber) throws UnhandledEnumValueException {
        int currentDocumentIndex;
        List<BaselineDocument> baselineDocuments;
        this.validatePageNumber(pageNumber);
        if (BaselineDocumentTypeQuery.PAGE.equals((Object)this.documentType)) {
            baselineDocuments = this.baseline.getPageDocuments();
        } else if (BaselineDocumentTypeQuery.ATTACHMENT.equals((Object)this.documentType)) {
            baselineDocuments = this.baseline.getAttachmentDocuments();
        } else if (BaselineDocumentTypeQuery.ANY_DOCUMENT.equals((Object)this.documentType)) {
            baselineDocuments = this.baseline.getAllDocuments();
        } else {
            throw new UnhandledEnumValueException();
        }
        baselineDocuments.sort(new BaselineDocumentPathComparator());
        int firstIndex = (pageNumber - 1) * 100;
        int lastIndex = firstIndex + 100 - 1;
        ArrayList<BaselineDocument> pageDocuments = new ArrayList<BaselineDocument>();
        for (currentDocumentIndex = firstIndex; currentDocumentIndex < this.totalDocumentCount && currentDocumentIndex <= lastIndex; ++currentDocumentIndex) {
            pageDocuments.add(baselineDocuments.get(currentDocumentIndex));
        }
        if (currentDocumentIndex >= this.totalDocumentCount) {
            lastIndex = currentDocumentIndex - 1;
        }
        return new BaselineViewPage(pageDocuments, pageNumber, this.totalDocumentCount > 0 ? firstIndex + 1 : 0, lastIndex + 1);
    }

    private void validatePageNumber(int pageNumber) {
        if (pageNumber <= 0) {
            throw new IllegalArgumentException("pageNumber must be greater than zero!");
        }
        if (pageNumber > this.lastPageNumber) {
            throw new IllegalArgumentException("pageNumber is too high!");
        }
    }

    public class BaselineViewPage {
        private List<BaselineDocument> documents;
        private int pageNumber;
        private int firstDocumentNumber;
        private int lastDocumentNumber;

        BaselineViewPage(List<BaselineDocument> documents, int pageNumber, int firstDocumentNumber, int lastDocumentNumber) {
            this.documents = documents;
            this.pageNumber = pageNumber;
            this.firstDocumentNumber = firstDocumentNumber;
            this.lastDocumentNumber = lastDocumentNumber;
        }

        public boolean isSinglePage() {
            return BaselinePager.this.isSinglePage;
        }

        public int getLastPageNumber() {
            return BaselinePager.this.lastPageNumber;
        }

        public List<BaselineDocument> getDocuments() {
            return this.documents;
        }

        public int getPageNumber() {
            return this.pageNumber;
        }

        public int getFirstDocumentNumber() {
            return this.firstDocumentNumber;
        }

        public int getLastDocumentNumber() {
            return this.lastDocumentNumber;
        }
    }
}

