/*
 * Decompiled with CFR 0.152.
 */
package tr.com.obss.plugin.extra.flyingpdf.config;

import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.setup.bandana.ConfluenceBandanaContext;
import com.atlassian.event.Event;
import com.atlassian.event.EventManager;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import tr.com.obss.plugin.extra.flyingpdf.config.CustomFontInstalledEvent;
import tr.com.obss.plugin.extra.flyingpdf.config.CustomFontRemovedEvent;
import tr.com.obss.plugin.extra.flyingpdf.config.FontDao;
import tr.com.obss.plugin.extra.flyingpdf.config.FontManager;

public class PdfExportFontManager
implements FontManager {
    private static final String FONT_NAMES_KEY = "com.atlassian.confluence.extra.flyingpdf.fontname";
    private static final String DEFAULT_FONT_NAME = "customfont";
    private static final Logger LOGGER = Logger.getLogger(PdfExportFontManager.class);
    private FontDao fontDao;
    private BandanaManager bandanaManager;
    private EventManager eventManager;

    public PdfExportFontManager(FontDao fontDao, BandanaManager bandanaManager, EventManager eventManager) {
        this.fontDao = fontDao;
        this.bandanaManager = bandanaManager;
        this.eventManager = eventManager;
    }

    @Override
    public FileSystemResource getInstalledFont() {
        String customFont = this.getFontFileName(DEFAULT_FONT_NAME);
        if (StringUtils.isBlank((CharSequence)customFont)) {
            return null;
        }
        Resource fontResource = null;
        try {
            fontResource = this.fontDao.getFont(customFont);
        }
        catch (IOException ex) {
            LOGGER.debug((Object)("No font resource could be found with the name " + customFont), (Throwable)ex);
            return null;
        }
        if (!(fontResource instanceof FileSystemResource)) {
            LOGGER.warn((Object)("The fontDao did not return the font " + customFont + " as a FileSystemResource"));
            return null;
        }
        return (FileSystemResource)fontResource;
    }

    @Override
    public void installFont(Resource fontResource) throws IOException {
        String fontName;
        try {
            fontName = fontResource.getFilename();
        }
        catch (IllegalStateException ex) {
            throw new IOException("The supplied fontResource did not include a filename property.");
        }
        this.fontDao.saveFont(fontName, fontResource);
        String oldFont = this.getFontFileName(DEFAULT_FONT_NAME);
        if (StringUtils.isNotBlank((CharSequence)oldFont) && !oldFont.equals(fontName)) {
            this.fontDao.removeFont(oldFont);
        }
        if (!fontName.equals(oldFont)) {
            this.storeFontFileName(DEFAULT_FONT_NAME, fontName);
        }
        this.eventManager.publishEvent((Event)new CustomFontInstalledEvent("PDF Export Font Manager", fontName, this.getFontData(fontResource)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] getFontData(Resource fontResource) throws IOException {
        if (!fontResource.exists()) {
            throw new IOException("The font resource cannot be found for transfer to other nodes in the cluster: " + fontResource.getDescription());
        }
        ByteArrayOutputStream fontDataStream = new ByteArrayOutputStream();
        InputStream istream = fontResource.getInputStream();
        try {
            IOUtils.copy((InputStream)istream, (OutputStream)fontDataStream);
        }
        finally {
            IOUtils.closeQuietly((OutputStream)fontDataStream);
        }
        return fontDataStream.toByteArray();
    }

    @Override
    public boolean isCustomFontInstalled() {
        FileSystemResource customFont = this.getInstalledFont();
        return customFont != null;
    }

    @Override
    public void removeInstalledFont() throws IOException {
        String customFont = this.getFontFileName(DEFAULT_FONT_NAME);
        if (StringUtils.isBlank((CharSequence)customFont)) {
            LOGGER.debug((Object)"No custom font is installed.");
            return;
        }
        try {
            this.fontDao.removeFont(customFont);
        }
        catch (IOException ex) {
            LOGGER.warn((Object)("Failed to remove the custom font " + customFont), (Throwable)ex);
            return;
        }
        this.storeFontFileName(DEFAULT_FONT_NAME, "");
        this.eventManager.publishEvent((Event)new CustomFontRemovedEvent("PDF Export Font Manager", customFont));
    }

    private String getFontFileName(String fontName) {
        Map fontNameMap = (Map)this.bandanaManager.getValue((BandanaContext)ConfluenceBandanaContext.GLOBAL_CONTEXT, FONT_NAMES_KEY);
        if (fontNameMap != null) {
            return (String)fontNameMap.get(fontName);
        }
        return null;
    }

    private void storeFontFileName(String fontName, String fontFileName) {
        HashMap<String, String> fontNameMap = (HashMap<String, String>)this.bandanaManager.getValue((BandanaContext)ConfluenceBandanaContext.GLOBAL_CONTEXT, FONT_NAMES_KEY);
        if (fontNameMap == null) {
            fontNameMap = new HashMap<String, String>(1);
        }
        fontNameMap.put(fontName, fontFileName);
        this.bandanaManager.setValue((BandanaContext)ConfluenceBandanaContext.GLOBAL_CONTEXT, FONT_NAMES_KEY, fontNameMap);
    }
}

