/*
 * Decompiled with CFR 0.152.
 */
package tr.com.obss.plugin.export;

import com.atlassian.confluence.importexport.ImportExportException;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.user.User;
import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tr.com.obss.plugin.extra.flyingpdf.PdfExporterService;
import tr.com.obss.plugin.extra.flyingpdf.analytic.PageExportMetrics;

public class PagePdfExportRunnable
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(PagePdfExportRunnable.class);
    private PdfExporterService pdfExporterService;
    private AbstractPage page;
    private String contextPath;
    private File pdfFile;

    public PagePdfExportRunnable(PdfExporterService pdfExporterService, AbstractPage page, String contextPath) {
        this.pdfExporterService = pdfExporterService;
        this.page = page;
        this.contextPath = contextPath;
        this.pdfFile = null;
    }

    @Override
    public void run() {
        try {
            this.pdfFile = this.pdfExporterService.createPdfForPage((User)AuthenticatedUserThreadLocal.get(), this.page, this.contextPath, new PageExportMetrics());
        }
        catch (ImportExportException e) {
            log.error("Error while creating pdf file for pageId: " + this.page.getId(), (Throwable)e);
        }
    }

    public File getPdfFile() {
        return this.pdfFile;
    }
}

