/*
 * Decompiled with CFR 0.152.
 */
package tr.com.obss.plugin.database;

import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.setup.bandana.ConfluenceBandanaContext;
import com.atlassian.confluence.spaces.Space;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tr.com.obss.plugin.database.BaselineDatabaseManager;
import tr.com.obss.plugin.dto.Baseline;
import tr.com.obss.plugin.dto.BaselineAttachment;
import tr.com.obss.plugin.dto.BaselinePage;
import tr.com.obss.plugin.dto.BaselineSummary;
import tr.com.obss.plugin.dto.impl.BaselineAttachmentImpl;
import tr.com.obss.plugin.dto.impl.BaselineImpl;
import tr.com.obss.plugin.dto.impl.BaselinePageImpl;
import tr.com.obss.plugin.dto.impl.BaselineSummaryImpl;
import tr.com.obss.plugin.pojo.AttachmentPOJO;
import tr.com.obss.plugin.pojo.BaseLinePOJO;
import tr.com.obss.plugin.pojo.PagePOJO;

public class BaselineBandanaDatabaseManager
implements BaselineDatabaseManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaselineBandanaDatabaseManager.class);
    private static final String BASELINE_KEY_PREFIX = "baseline-";
    private static final String BASELINE_KEY_DELIMITER = "!,.,!";
    private BandanaManager bandanaManager;

    public BaselineBandanaDatabaseManager(BandanaManager bandanaManager) {
        this.bandanaManager = bandanaManager;
    }

    @Override
    @Nonnull
    public List<String> getAllBaselineNames(@Nonnull Space space) {
        Iterable bandanaKeys = this.bandanaManager.getKeys(BaselineBandanaDatabaseManager.getContext(space));
        ArrayList<String> baselineNames = new ArrayList<String>();
        for (String bandanaKey : bandanaKeys) {
            if (!bandanaKey.startsWith(BASELINE_KEY_PREFIX)) continue;
            baselineNames.add(BaselineBandanaDatabaseManager.convertToBaselineName(bandanaKey));
        }
        return baselineNames;
    }

    @Override
    @Nullable
    public Baseline getBaseline(@Nonnull Space space, @Nonnull String baselineName) {
        BaseLinePOJO baseLinePOJO = this.getBaselinePOJO(space, baselineName, false);
        return BaselineBandanaDatabaseManager.pojoToDto(baseLinePOJO);
    }

    @Override
    @Nonnull
    public List<BaselineSummary> getBaselineSummaries(@Nonnull Space space) {
        List<String> allBaselineNames = this.getAllBaselineNames(space);
        ArrayList<BaselineSummary> baselineSummaries = new ArrayList<BaselineSummary>();
        for (String baselineName : allBaselineNames) {
            BaseLinePOJO baseLinePOJO = this.getBaselinePOJO(space, baselineName, true);
            if (baseLinePOJO == null) continue;
            BaselineSummaryImpl baselineSummary = new BaselineSummaryImpl(baseLinePOJO.getName(), baseLinePOJO.getBaselineDate(), baseLinePOJO.getCreateDate());
            baselineSummaries.add(baselineSummary);
        }
        return baselineSummaries;
    }

    private BaseLinePOJO getBaselinePOJO(Space space, String baselineName, boolean justSummary) {
        Object baselineAsObject = this.bandanaManager.getValue(BaselineBandanaDatabaseManager.getContext(space), BaselineBandanaDatabaseManager.convertToBandanaKey(baselineName));
        if (baselineAsObject == null) {
            return null;
        }
        BaseLinePOJO baseLinePOJO = null;
        try {
            if (justSummary) {
                BaseLinePOJO fullBaselinePojo = (BaseLinePOJO)baselineAsObject;
                baseLinePOJO = new BaseLinePOJO();
                baseLinePOJO.setName(fullBaselinePojo.getName());
                baseLinePOJO.setBaselineDate(fullBaselinePojo.getBaselineDate());
                baseLinePOJO.setCreateDate(fullBaselinePojo.getCreateDate());
            } else {
                baseLinePOJO = (BaseLinePOJO)baselineAsObject;
            }
        }
        catch (ClassCastException e) {
            LOGGER.warn("Baseline could not be retrieved from database via the regular method. Trying secondary method. Please restart your Confluence system in order to solve this problem.");
            baseLinePOJO = this.getBaselinePojoViaReflection(baselineAsObject, justSummary);
        }
        if (baseLinePOJO != null && (baseLinePOJO.getName() == null || "".equals(baseLinePOJO.getName().trim()))) {
            baseLinePOJO.setName(baselineName);
        }
        return baseLinePOJO;
    }

    private BaseLinePOJO getBaselinePojoViaReflection(Object baselineAsObject, boolean justSummary) {
        try {
            BaseLinePOJO baseLinePOJO = new BaseLinePOJO();
            Class<?> baselineObjectClass = baselineAsObject.getClass();
            baseLinePOJO.setName((String)baselineObjectClass.getMethod("getName", new Class[0]).invoke(baselineAsObject, new Object[0]));
            baseLinePOJO.setBaselineDate((Date)baselineObjectClass.getMethod("getBaselineDate", new Class[0]).invoke(baselineAsObject, new Object[0]));
            if (justSummary) {
                return baseLinePOJO;
            }
            baseLinePOJO.setCreateDate((Date)baselineObjectClass.getMethod("getCreateDate", new Class[0]).invoke(baselineAsObject, new Object[0]));
            baseLinePOJO.setCreator((String)baselineObjectClass.getMethod("getCreator", new Class[0]).invoke(baselineAsObject, new Object[0]));
            baseLinePOJO.setBaselineKey((String)baselineObjectClass.getMethod("getBaselineKey", new Class[0]).invoke(baselineAsObject, new Object[0]));
            baseLinePOJO.setSpace((String)baselineObjectClass.getMethod("getSpace", new Class[0]).invoke(baselineAsObject, new Object[0]));
            List pageObjects = (List)baselineObjectClass.getMethod("getPages", new Class[0]).invoke(baselineAsObject, new Object[0]);
            if (pageObjects == null) {
                return baseLinePOJO;
            }
            ArrayList<PagePOJO> baselinePages = new ArrayList<PagePOJO>();
            for (Object pageAsObject : pageObjects) {
                PagePOJO pagePOJO = new PagePOJO();
                Class<?> pageObjectClass = pageAsObject.getClass();
                pagePOJO.setVersion((String)pageObjectClass.getMethod("getVersion", new Class[0]).invoke(pageAsObject, new Object[0]));
                pagePOJO.setUrl((String)pageObjectClass.getMethod("getUrl", new Class[0]).invoke(pageAsObject, new Object[0]));
                pagePOJO.setType((String)pageObjectClass.getMethod("getType", new Class[0]).invoke(pageAsObject, new Object[0]));
                pagePOJO.setTitle((String)pageObjectClass.getMethod("getTitle", new Class[0]).invoke(pageAsObject, new Object[0]));
                pagePOJO.setPagePath((String)pageObjectClass.getMethod("getPagePath", new Class[0]).invoke(pageAsObject, new Object[0]));
                pagePOJO.setPageId((String)pageObjectClass.getMethod("getPageId", new Class[0]).invoke(pageAsObject, new Object[0]));
                pagePOJO.setCreationDate((Date)pageObjectClass.getMethod("getCreationDate", new Class[0]).invoke(pageAsObject, new Object[0]));
                List<Object> attachmentObjects = this.getAttachmentObjectsViaReflection(pageObjectClass, pageAsObject, pagePOJO.getPageId());
                if (attachmentObjects != null) {
                    ArrayList<AttachmentPOJO> baselineAttachments = new ArrayList<AttachmentPOJO>();
                    for (Object attachmentAsObject : attachmentObjects) {
                        AttachmentPOJO attachmentPOJO = new AttachmentPOJO();
                        Class<?> attachmentObjectClass = attachmentAsObject.getClass();
                        attachmentPOJO.setVersion((String)attachmentObjectClass.getMethod("getVersion", new Class[0]).invoke(attachmentAsObject, new Object[0]));
                        attachmentPOJO.setUrl((String)attachmentObjectClass.getMethod("getUrl", new Class[0]).invoke(attachmentAsObject, new Object[0]));
                        attachmentPOJO.setType((String)attachmentObjectClass.getMethod("getType", new Class[0]).invoke(attachmentAsObject, new Object[0]));
                        attachmentPOJO.setTitle((String)attachmentObjectClass.getMethod("getTitle", new Class[0]).invoke(attachmentAsObject, new Object[0]));
                        attachmentPOJO.setPagePath((String)attachmentObjectClass.getMethod("getPagePath", new Class[0]).invoke(attachmentAsObject, new Object[0]));
                        attachmentPOJO.setId((String)attachmentObjectClass.getMethod("getId", new Class[0]).invoke(attachmentAsObject, new Object[0]));
                        attachmentPOJO.setCreationDate((Date)attachmentObjectClass.getMethod("getCreationDate", new Class[0]).invoke(attachmentAsObject, new Object[0]));
                        attachmentPOJO.setParentPage(pagePOJO);
                        baselineAttachments.add(attachmentPOJO);
                    }
                    pagePOJO.setAttachments(baselineAttachments);
                }
                baselinePages.add(pagePOJO);
            }
            baseLinePOJO.setPages(baselinePages);
            return baseLinePOJO;
        }
        catch (Exception e) {
            LOGGER.error("Could not retrieve baseline using reflection.", (Throwable)e);
            return null;
        }
    }

    private List<Object> getAttachmentObjectsViaReflection(Class<?> pageObjectClass, Object pageAsObject, String pageId) {
        List attachments = null;
        try {
            attachments = (List)pageObjectClass.getMethod("getAttachments", new Class[0]).invoke(pageAsObject, new Object[0]);
        }
        catch (NoSuchMethodException e) {
            LOGGER.debug("No attachments for page id: " + pageId + " found in baseline.", (Throwable)e);
        }
        catch (Exception e) {
            LOGGER.error("An error other than NoSuchMethodException was thrown.", (Throwable)e);
        }
        return attachments;
    }

    @Override
    public void deleteBaseline(@Nonnull Space space, @Nonnull String baselineName) {
        this.bandanaManager.removeValue(BaselineBandanaDatabaseManager.getContext(space), BaselineBandanaDatabaseManager.convertToBandanaKey(baselineName));
    }

    @Override
    public void persistBaseline(@Nonnull Space space, @Nonnull Baseline baseline) {
        BaseLinePOJO baseLinePOJO = BaselineBandanaDatabaseManager.dtoToPojo(baseline);
        this.bandanaManager.setValue(BaselineBandanaDatabaseManager.getContext(space), BaselineBandanaDatabaseManager.convertToBandanaKey(baseLinePOJO.getName()), (Object)BaselineBandanaDatabaseManager.dtoToPojo(baseline));
    }

    private static BandanaContext getContext(Space space) {
        return new ConfluenceBandanaContext(space);
    }

    private static String convertToBandanaKey(String baselineName) {
        return BASELINE_KEY_PREFIX + baselineName.replace(" ", BASELINE_KEY_DELIMITER);
    }

    private static String convertToBaselineName(String bandanaKey) {
        return bandanaKey.replaceFirst(BASELINE_KEY_PREFIX, "").replace(BASELINE_KEY_DELIMITER, " ");
    }

    private static BaseLinePOJO dtoToPojo(Baseline baseline) {
        if (baseline == null) {
            return null;
        }
        ArrayList<PagePOJO> baselinePages = new ArrayList<PagePOJO>();
        List<BaselinePage> baselineDtoPages = baseline.getPages();
        if (baselineDtoPages == null) {
            baselineDtoPages = new ArrayList<BaselinePage>();
        }
        for (BaselinePage baselinePage : baselineDtoPages) {
            PagePOJO pagePOJO = new PagePOJO();
            pagePOJO.setTitle(baselinePage.getTitle());
            pagePOJO.setPageId(baselinePage.getId());
            pagePOJO.setCreationDate(baselinePage.getCreationDate());
            pagePOJO.setPagePath(baselinePage.getPath());
            pagePOJO.setType(baselinePage.getType().toString());
            pagePOJO.setUrl(baselinePage.getUrl());
            pagePOJO.setVersion(baselinePage.getVersion());
            ArrayList<AttachmentPOJO> baselineAttachments = new ArrayList<AttachmentPOJO>();
            List<BaselineAttachment> pageDtoAttachments = baselinePage.getAttachments();
            if (pageDtoAttachments == null) {
                pageDtoAttachments = new ArrayList<BaselineAttachment>();
            }
            for (BaselineAttachment baselineAttachment : pageDtoAttachments) {
                AttachmentPOJO attachmentPOJO = new AttachmentPOJO();
                attachmentPOJO.setParentPage(pagePOJO);
                attachmentPOJO.setId(baselineAttachment.getId());
                attachmentPOJO.setCreationDate(baselineAttachment.getCreationDate());
                attachmentPOJO.setPagePath(baselineAttachment.getPath());
                attachmentPOJO.setTitle(baselineAttachment.getTitle());
                attachmentPOJO.setType(baselineAttachment.getType().toString());
                attachmentPOJO.setUrl(baselineAttachment.getUrl());
                attachmentPOJO.setVersion(baselineAttachment.getVersion());
                baselineAttachments.add(attachmentPOJO);
            }
            pagePOJO.setAttachments(baselineAttachments);
            baselinePages.add(pagePOJO);
        }
        BaseLinePOJO baseLinePOJO = new BaseLinePOJO();
        baseLinePOJO.setBaselineDate(baseline.getBaselineDate());
        baseLinePOJO.setBaselineKey(baseline.getKeyword());
        baseLinePOJO.setCreateDate(baseline.getCreationDate());
        baseLinePOJO.setCreator(baseline.getCreator());
        baseLinePOJO.setName(baseline.getName());
        baseLinePOJO.setSpace(baseline.getSpaceKey());
        baseLinePOJO.setPages(baselinePages);
        return baseLinePOJO;
    }

    private static Baseline pojoToDto(BaseLinePOJO baseLinePOJO) {
        if (baseLinePOJO == null) {
            return null;
        }
        ArrayList<BaselinePage> baselinePages = new ArrayList<BaselinePage>();
        for (PagePOJO pagePOJO : baseLinePOJO.getPages()) {
            ArrayList<BaselineAttachment> baselineAttachments = new ArrayList<BaselineAttachment>();
            List<AttachmentPOJO> pagePojoAttachments = pagePOJO.getAttachments();
            if (pagePojoAttachments == null) {
                pagePojoAttachments = new ArrayList<AttachmentPOJO>();
            }
            for (AttachmentPOJO attachmentPOJO : pagePojoAttachments) {
                BaselineAttachmentImpl baselineAttachment = new BaselineAttachmentImpl(attachmentPOJO.getId(), attachmentPOJO.getTitle(), attachmentPOJO.getPagePath(), attachmentPOJO.getVersion(), attachmentPOJO.getUrl(), attachmentPOJO.getCreationDate(), attachmentPOJO.getParentPage().getPageId());
                baselineAttachments.add(baselineAttachment);
            }
            BaselinePageImpl baselinePage = new BaselinePageImpl(pagePOJO.getPageId(), pagePOJO.getTitle(), pagePOJO.getPagePath(), pagePOJO.getVersion(), pagePOJO.getUrl(), pagePOJO.getCreationDate(), baselineAttachments);
            baselinePages.add(baselinePage);
        }
        return new BaselineImpl(baseLinePOJO.getName(), baseLinePOJO.getCreateDate(), baseLinePOJO.getBaselineDate(), baseLinePOJO.getSpace(), baseLinePOJO.getCreator(), baseLinePOJO.getBaselineKey(), baselinePages);
    }
}

