/*
 * Decompiled with CFR 0.152.
 */
package tr.com.obss.plugin.baseline.parameter;

import com.atlassian.confluence.spaces.Space;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import tr.com.obss.plugin.ServiceAccessor;
import tr.com.obss.plugin.exception.BaselineParameterException;
import tr.com.obss.plugin.exception.InvalidOperationIdException;
import tr.com.obss.plugin.exception.OperationIdAlreadyExistsException;
import tr.com.obss.plugin.exception.SpaceKeyParameterIsRequiredException;
import tr.com.obss.plugin.exception.SpaceNotFoundException;
import tr.com.obss.plugin.progress.BaselineProgressTracker;

public abstract class BaselineParameterBuilder {
    private String operationIdParam;
    private String spaceKeyParam;

    public BaselineParameterBuilder(String operationIdParam, String spaceKeyParam) {
        this.operationIdParam = operationIdParam;
        this.spaceKeyParam = spaceKeyParam;
    }

    protected UUID validateOperationId() throws BaselineParameterException {
        UUID operationId;
        if (StringUtils.isBlank((CharSequence)this.operationIdParam)) {
            return null;
        }
        try {
            operationId = UUID.fromString(this.operationIdParam);
        }
        catch (Exception e) {
            throw new InvalidOperationIdException(e);
        }
        if (BaselineProgressTracker.exists(operationId)) {
            throw new OperationIdAlreadyExistsException();
        }
        return operationId;
    }

    protected Space validateSpace() throws BaselineParameterException {
        if (StringUtils.isBlank((CharSequence)this.spaceKeyParam)) {
            throw new SpaceKeyParameterIsRequiredException();
        }
        this.spaceKeyParam = this.spaceKeyParam.trim();
        Space space = ServiceAccessor.getSpaceManager().getSpace(this.spaceKeyParam);
        if (space == null) {
            throw new SpaceNotFoundException();
        }
        return space;
    }
}

