/*
 * Decompiled with CFR 0.152.
 */
package tr.com.obss.plugin.utils;

import com.atlassian.confluence.plugin.descriptor.web.WebInterfaceContext;
import com.atlassian.confluence.plugin.descriptor.web.conditions.BaseConfluenceCondition;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import java.util.List;
import tr.com.obss.plugin.utils.PluginSettingsData;

public class UserHasCondition
extends BaseConfluenceCondition {
    private UserAccessor userAccessor;
    private PluginSettingsData pluginSettingsData;

    public UserHasCondition(UserAccessor userAccessor, PluginSettingsFactory pluginSettingsFactory) {
        this.userAccessor = userAccessor;
        this.pluginSettingsData = new PluginSettingsData(pluginSettingsFactory);
    }

    private Boolean isGivenUserNameMemberOfASelectedGroupForView(String userName) {
        Boolean bool = false;
        List userGroups = this.userAccessor.getGroupNamesForUserName(userName);
        List<String> selectedGroups = this.pluginSettingsData.getUserGroupsForViewAsList();
        for (String tempGroup : userGroups) {
            if (!selectedGroups.contains(tempGroup)) continue;
            bool = true;
        }
        return bool;
    }

    private Boolean isGivenUserNameMemberOfASelectedGroupForEdit(String userName) {
        Boolean bool = false;
        List userGroups = this.userAccessor.getGroupNamesForUserName(userName);
        List<String> selectedGroups = this.pluginSettingsData.getUserGroupsForEditAsList();
        for (String tempGroup : userGroups) {
            if (!selectedGroups.contains(tempGroup)) continue;
            bool = true;
        }
        return bool;
    }

    private Boolean isGivenUserNameMemberOfASelectedGroupForDelete(String userName) {
        Boolean bool = false;
        List userGroups = this.userAccessor.getGroupNamesForUserName(userName);
        List<String> selectedGroups = this.pluginSettingsData.getUserGroupsForDeleteAsList();
        for (String tempGroup : userGroups) {
            if (!selectedGroups.contains(tempGroup)) continue;
            bool = true;
        }
        return bool;
    }

    private Boolean isGivenUserNameMemberOfASelectedGroupForExport(String userName) {
        Boolean bool = false;
        List userGroups = this.userAccessor.getGroupNamesForUserName(userName);
        List<String> selectedGroups = this.pluginSettingsData.getUserGroupsForExportAsList();
        for (String tempGroup : userGroups) {
            if (!selectedGroups.contains(tempGroup)) continue;
            bool = true;
        }
        return bool;
    }

    private Boolean isAllGroupsSelectedForView() {
        String selected;
        Boolean bool = false;
        String string = selected = this.pluginSettingsData.getAllUserGroupsForView() == null ? "" : this.pluginSettingsData.getAllUserGroupsForView().toString();
        if (selected.contentEquals("") || selected.contentEquals("on")) {
            bool = true;
        }
        return bool;
    }

    private Boolean isAllGroupsSelectedForEdit() {
        String selected;
        Boolean bool = false;
        String string = selected = this.pluginSettingsData.getAllUserGroupsForEdit() == null ? "" : this.pluginSettingsData.getAllUserGroupsForEdit().toString();
        if (selected.contentEquals("") || selected.contentEquals("on")) {
            bool = true;
        }
        return bool;
    }

    private Boolean isAllGroupsSelectedForDelete() {
        String selected;
        Boolean bool = false;
        String string = selected = this.pluginSettingsData.getAllUserGroupsForDelete() == null ? "" : this.pluginSettingsData.getAllUserGroupsForDelete().toString();
        if (selected.contentEquals("") || selected.contentEquals("on")) {
            bool = true;
        }
        return bool;
    }

    private Boolean isAllGroupsSelectedForExport() {
        String selected;
        Boolean bool = false;
        String string = selected = this.pluginSettingsData.getAllUserGroupsForExport() == null ? "" : this.pluginSettingsData.getAllUserGroupsForExport().toString();
        if (selected.contentEquals("") || selected.contentEquals("on")) {
            bool = true;
        }
        return bool;
    }

    public Boolean isInEditGroups(String userName) {
        Boolean permission = false;
        if (this.isAllGroupsSelectedForEdit().booleanValue() || this.isGivenUserNameMemberOfASelectedGroupForEdit(userName).booleanValue()) {
            permission = true;
        }
        return permission;
    }

    public Boolean isInViewGroups(String userName) {
        Boolean permission = false;
        if (this.isAllGroupsSelectedForView().booleanValue() || this.isGivenUserNameMemberOfASelectedGroupForView(userName).booleanValue()) {
            permission = true;
        }
        return permission;
    }

    public Boolean isInDeleteGroups(String userName) {
        Boolean permission = false;
        if (this.isAllGroupsSelectedForDelete().booleanValue() || this.isGivenUserNameMemberOfASelectedGroupForDelete(userName).booleanValue()) {
            permission = true;
        }
        return permission;
    }

    public Boolean isInExportGroups(String userName) {
        Boolean permission = false;
        if (this.isAllGroupsSelectedForExport().booleanValue() || this.isGivenUserNameMemberOfASelectedGroupForExport(userName).booleanValue()) {
            permission = true;
        }
        return permission;
    }

    protected boolean shouldDisplay(WebInterfaceContext arg0) {
        ConfluenceUser currentUser = arg0.getCurrentUser();
        if (currentUser == null) {
            return false;
        }
        if (this.isAllGroupsSelectedForView().booleanValue() || this.isAllGroupsSelectedForEdit().booleanValue()) {
            return true;
        }
        String currentUserName = currentUser.getName();
        return this.isInViewGroups(currentUserName) != false || this.isInEditGroups(currentUserName) != false;
    }
}

