/*
 * Decompiled with CFR 0.152.
 */
package tr.com.obss.plugin.servlet;

import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.xwork.RequireSecurityToken;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.Writer;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tr.com.obss.plugin.utils.PluginSettingsData;
import tr.com.obss.plugin.utils.Utils;

public class BaseLineConditionServlet
extends HttpServlet {
    private static final long serialVersionUID = 400647569503228949L;
    private static final Logger LOG = LoggerFactory.getLogger(BaseLineConditionServlet.class);
    private static final String CONDITION_TEMPLATE = "/templates/baselineConfig.vm";
    private static final String NOT_AUTH_TEMPLATE = "/templates/baselineNotAuth.vm";
    private static final String LICENSE_ERROR_TEMPLATE = "/templates/baselineInvalidLicense.vm";
    private static final String ALL_USER_GROUPS_FOR_EDIT = "allUserGroupsForEdit";
    private static final String ALL_USER_GROUPS_FOR_VIEW = "allUserGroupsForView";
    private static final String ALL_USER_GROUPS_FOR_DELETE = "allUserGroupsForDelete";
    private static final String ALL_USER_GROUPS_FOR_EXPORT = "allUserGroupsForExport";
    private static final String CHECKED = "checked";
    private final TemplateRenderer templateRenderer;
    private final UserManager userManager;
    private final LoginUriProvider loginUriProvider;
    private final PluginSettingsData pluginSettingsData;
    private final PluginLicenseManager licenseManager;

    public BaseLineConditionServlet(TemplateRenderer templateRenderer, UserManager userManager, LoginUriProvider loginUriProvider, PluginSettingsFactory pluginSettingsFactory, PluginLicenseManager licenseManager) {
        this.templateRenderer = templateRenderer;
        this.userManager = userManager;
        this.loginUriProvider = loginUriProvider;
        this.pluginSettingsData = new PluginSettingsData(pluginSettingsFactory);
        this.licenseManager = licenseManager;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) {
        try {
            resp.setContentType("text/html;charset=utf-8");
            HashMap context = Maps.newHashMap();
            if (AuthenticatedUserThreadLocal.get() == null) {
                this.redirectToLogin(req, resp);
            } else if (!this.userManager.isSystemAdmin(this.userManager.getRemoteUserKey())) {
                this.templateRenderer.render(NOT_AUTH_TEMPLATE, (Map)context, (Writer)resp.getWriter());
            } else if (!Utils.isLicenseValid(this.licenseManager)) {
                this.templateRenderer.render(LICENSE_ERROR_TEMPLATE, (Map)context, (Writer)resp.getWriter());
            } else {
                if ("yes".equals(req.getParameter("deleteSettings"))) {
                    this.deleteSettings();
                }
                if (this.pluginSettingsData.getAllUserGroupsForEdit() == null) {
                    context.put(ALL_USER_GROUPS_FOR_EDIT, "on");
                    this.pluginSettingsData.setAllUserGroupsForEdit("on");
                } else {
                    context.put(ALL_USER_GROUPS_FOR_EDIT, this.pluginSettingsData.getAllUserGroupsForEdit());
                }
                if (this.pluginSettingsData.getAllUserGroupsForView() == null) {
                    context.put(ALL_USER_GROUPS_FOR_VIEW, "on");
                    this.pluginSettingsData.setAllUserGroupsForView("on");
                } else {
                    context.put(ALL_USER_GROUPS_FOR_VIEW, this.pluginSettingsData.getAllUserGroupsForView());
                }
                if (this.pluginSettingsData.getAllUserGroupsForDelete() == null) {
                    context.put(ALL_USER_GROUPS_FOR_DELETE, "on");
                    this.pluginSettingsData.setAllUserGroupsForDelete("on");
                } else {
                    context.put(ALL_USER_GROUPS_FOR_DELETE, this.pluginSettingsData.getAllUserGroupsForDelete());
                }
                if (this.pluginSettingsData.getAllUserGroupsForExport() == null) {
                    context.put(ALL_USER_GROUPS_FOR_EXPORT, "on");
                    this.pluginSettingsData.setAllUserGroupsForExport("on");
                } else {
                    context.put(ALL_USER_GROUPS_FOR_EXPORT, this.pluginSettingsData.getAllUserGroupsForExport());
                }
                List<String> allGroupNames = Utils.getAllGroupNames();
                List<String> selectedGroupNamesForView = this.pluginSettingsData.getUserGroupsForViewAsList();
                List<String> selectedGroupNamesForEdit = this.pluginSettingsData.getUserGroupsForEditAsList();
                List<String> selectedGroupNamesForDelete = this.pluginSettingsData.getUserGroupsForDeleteAsList();
                List<String> selectedGroupNamesForExport = this.pluginSettingsData.getUserGroupsForExportAsList();
                selectedGroupNamesForView.removeIf(name -> !allGroupNames.contains(name));
                selectedGroupNamesForEdit.removeIf(name -> !allGroupNames.contains(name));
                selectedGroupNamesForDelete.removeIf(name -> !allGroupNames.contains(name));
                selectedGroupNamesForExport.removeIf(name -> !allGroupNames.contains(name));
                context.put("selectedUserGroupForView", selectedGroupNamesForView);
                context.put("selectedUserGroupForEdit", selectedGroupNamesForEdit);
                context.put("selectedUserGroupForDelete", selectedGroupNamesForDelete);
                context.put("selectedUserGroupForExport", selectedGroupNamesForExport);
                if ("true".equals(req.getParameter("submitted"))) {
                    context.put("showSuccessMessage", "true");
                } else {
                    context.put("showSuccessMessage", "false");
                }
                this.templateRenderer.render(CONDITION_TEMPLATE, (Map)context, (Writer)resp.getWriter());
            }
        }
        catch (Exception e) {
            LOG.error("Error while opening baseline configuration page.", (Throwable)e);
        }
    }

    @RequireSecurityToken(value=true)
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) {
        try {
            resp.setContentType("text/html;charset=utf-8");
            if (AuthenticatedUserThreadLocal.get() == null || !this.userManager.isSystemAdmin(this.userManager.getRemoteUserKey())) {
                resp.setStatus(403);
                resp.getWriter().write("You are not authorized for this operation.");
                return;
            }
            if (!Utils.isLicenseValid(this.licenseManager)) {
                resp.setStatus(403);
                resp.getWriter().write("Your Baselines for Confluence license has been expired.");
                return;
            }
            String allUserGroupsForView = "";
            allUserGroupsForView = CHECKED.equals(req.getParameter(ALL_USER_GROUPS_FOR_VIEW)) ? "on" : "off";
            String allUserGroupsForEdit = "";
            allUserGroupsForEdit = CHECKED.equals(req.getParameter(ALL_USER_GROUPS_FOR_EDIT)) ? "on" : "off";
            String allUserGroupsForDelete = "";
            allUserGroupsForDelete = CHECKED.equals(req.getParameter(ALL_USER_GROUPS_FOR_DELETE)) ? "on" : "off";
            String allUserGroupsForExport = "";
            allUserGroupsForExport = CHECKED.equals(req.getParameter(ALL_USER_GROUPS_FOR_EXPORT)) ? "on" : "off";
            ArrayList<String> fieldsforView = new ArrayList<String>();
            String[] multipleForView = null;
            if (null != req.getParameterValues("userGroupForView")) {
                multipleForView = req.getParameterValues("userGroupForView");
                fieldsforView.add(this.pluginSettingsData.parameterValuesToString(multipleForView));
            } else if (CHECKED.equals(req.getParameter(ALL_USER_GROUPS_FOR_VIEW))) {
                fieldsforView.add("ALL");
            }
            ArrayList<String> fieldsforEdit = new ArrayList<String>();
            String[] multipleForEdit = null;
            if (null != req.getParameterValues("userGroupForEdit")) {
                multipleForEdit = req.getParameterValues("userGroupForEdit");
                fieldsforEdit.add(this.pluginSettingsData.parameterValuesToString(multipleForEdit));
            } else if (CHECKED.equals(req.getParameter(ALL_USER_GROUPS_FOR_EDIT))) {
                fieldsforEdit.add("ALL");
            }
            ArrayList<String> fieldsforDelete = new ArrayList<String>();
            String[] multipleForDelete = null;
            if (null != req.getParameterValues("userGroupForDelete")) {
                multipleForDelete = req.getParameterValues("userGroupForDelete");
                fieldsforDelete.add(this.pluginSettingsData.parameterValuesToString(multipleForDelete));
            } else if (CHECKED.equals(req.getParameter(ALL_USER_GROUPS_FOR_DELETE))) {
                fieldsforDelete.add("ALL");
            }
            ArrayList<String> fieldsforExport = new ArrayList<String>();
            String[] multipleForExport = null;
            if (null != req.getParameterValues("userGroupForExport")) {
                multipleForExport = req.getParameterValues("userGroupForExport");
                fieldsforExport.add(this.pluginSettingsData.parameterValuesToString(multipleForExport));
            } else if (CHECKED.equals(req.getParameter(ALL_USER_GROUPS_FOR_EXPORT))) {
                fieldsforExport.add("ALL");
            }
            String generalSettingForView = this.pluginSettingsData.createGeneralSettingString(fieldsforView);
            String generalSettingForEdit = this.pluginSettingsData.createGeneralSettingString(fieldsforEdit);
            String generalSettingForDelete = this.pluginSettingsData.createGeneralSettingString(fieldsforDelete);
            String generalSettingForExport = this.pluginSettingsData.createGeneralSettingString(fieldsforExport);
            this.pluginSettingsData.setAllUserGroupsForView(allUserGroupsForView);
            this.pluginSettingsData.setAllUserGroupsForEdit(allUserGroupsForEdit);
            this.pluginSettingsData.setAllUserGroupsForDelete(allUserGroupsForDelete);
            this.pluginSettingsData.setAllUserGroupsForExport(allUserGroupsForExport);
            this.pluginSettingsData.setUserGroupsForView(generalSettingForView);
            this.pluginSettingsData.setUserGroupsForEdit(generalSettingForEdit);
            this.pluginSettingsData.setUserGroupsForDelete(generalSettingForDelete);
            this.pluginSettingsData.setUserGroupsForExport(generalSettingForExport);
        }
        catch (Exception e) {
            LOG.error("Error while saving baseline configuration.", (Throwable)e);
            try {
                resp.sendError(500);
            }
            catch (Exception e2) {
                LOG.error(e2.getMessage(), (Throwable)e2);
            }
        }
    }

    private void redirectToLogin(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        resp.sendRedirect(this.loginUriProvider.getLoginUri(URI.create(req.getRequestURL().toString())).toASCIIString());
    }

    private void deleteSettings() {
        this.pluginSettingsData.setAllUserGroupsForEdit("on");
        this.pluginSettingsData.setAllUserGroupsForView("on");
        this.pluginSettingsData.setAllUserGroupsForDelete("on");
        this.pluginSettingsData.setAllUserGroupsForExport("on");
        this.pluginSettingsData.setUserGroupsForEdit("ALL");
        this.pluginSettingsData.setUserGroupsForView("ALL");
        this.pluginSettingsData.setUserGroupsForDelete("ALL");
        this.pluginSettingsData.setUserGroupsForExport("ALL");
    }
}

