/*
 * Decompiled with CFR 0.152.
 */
package tr.com.obss.plugin.extra.flyingpdf.html;

import com.atlassian.bandana.BandanaContext;
import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.DefaultConversionContext;
import com.atlassian.confluence.content.render.xhtml.Renderer;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.importexport.ImportExportException;
import com.atlassian.confluence.importexport.impl.ConfluenceTempDirExportFileNameGenerator;
import com.atlassian.confluence.importexport.impl.ExportFileNameGenerator;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.BlogPost;
import com.atlassian.confluence.pages.ContentNode;
import com.atlassian.confluence.pages.ContentTree;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.confluence.setup.bandana.ConfluenceBandanaContext;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.util.velocity.VelocityUtils;
import com.atlassian.renderer.RenderContext;
import com.atlassian.sal.api.message.I18nResolver;
import com.google.common.collect.ImmutableList;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import tr.com.obss.plugin.extra.flyingpdf.NoOpProgressMonitor;
import tr.com.obss.plugin.extra.flyingpdf.PdfExportProgressMonitor;
import tr.com.obss.plugin.extra.flyingpdf.PdfResourceManager;
import tr.com.obss.plugin.extra.flyingpdf.config.PdfExportSettingsManager;
import tr.com.obss.plugin.extra.flyingpdf.html.AutoFontScaleUtils;
import tr.com.obss.plugin.extra.flyingpdf.html.BookmarksBuilder;
import tr.com.obss.plugin.extra.flyingpdf.html.DecorationPolicy;
import tr.com.obss.plugin.extra.flyingpdf.html.ExportHtmlService;
import tr.com.obss.plugin.extra.flyingpdf.html.HtmlConverterUtils;
import tr.com.obss.plugin.extra.flyingpdf.html.HtmlToDomParser;
import tr.com.obss.plugin.extra.flyingpdf.html.LinkFixer;
import tr.com.obss.plugin.extra.flyingpdf.html.LinkRenderingDetails;
import tr.com.obss.plugin.extra.flyingpdf.html.TocBuilder;
import tr.com.obss.plugin.extra.flyingpdf.html.XhtmlBuilder;

public class RenderedXhtmlBuilder
implements XhtmlBuilder {
    static final String MAIN_STYLE_ID = "confluence.flyingpdf.styleId";
    private static final int CHARACTER_PER_LINE = Integer.getInteger("confluence.flyingpdf.default.characters.per.line", 80);
    private static final Pattern HEADING_PATTERN = Pattern.compile("\\</?h(\\d)(\\>|\\s)");
    private static final String PAGE_TEMPLATE_NAME = "templates/extra/pdfexport/obss-pagehtml.vm";
    private static final String COMPLETE_EXPORT_PAGE_TEMPLATE_NAME = "templates/extra/pdfexport/obss-completeexport.vm";
    private static final String TOC_TEMPLATE_NAME = "templates/extra/pdfexport/obss-toc.vm";
    private static final String CONFLUENCE_BASE_STYLES = RenderedXhtmlBuilder.loadResource("obss-master.css");
    private static final Logger LOG = Logger.getLogger(RenderedXhtmlBuilder.class);
    private Renderer xhtmlRenderer;
    private BootstrapManager bootstrapManager;
    private SettingsManager settingsManager;
    private PdfExportSettingsManager pdfSettings;
    private PdfResourceManager pdfResourceManager;
    private ExportHtmlService exportHtmlService;
    private I18nResolver i18NBean;

    public RenderedXhtmlBuilder(Renderer xhtmlRenderer, BootstrapManager bootstrapManager, SettingsManager settingsManager, PdfExportSettingsManager pdfSettings, PdfResourceManager pdfResourceManager, ExportHtmlService exportHtmlService, I18nResolver i18NBean) {
        this.xhtmlRenderer = xhtmlRenderer;
        this.bootstrapManager = bootstrapManager;
        this.settingsManager = settingsManager;
        this.pdfSettings = pdfSettings;
        this.pdfResourceManager = pdfResourceManager;
        this.exportHtmlService = exportHtmlService;
        this.i18NBean = i18NBean;
    }

    @Override
    public Document buildHtml(ContentTree contentTree, Space space, LinkRenderingDetails linkRendering, DecorationPolicy decoration) throws ImportExportException {
        return this.buildHtml(contentTree, space, linkRendering, decoration, new NoOpProgressMonitor());
    }

    @Override
    public Document buildHtml(ContentTree contentTree, Space space, LinkRenderingDetails linkRendering, DecorationPolicy decoration, PdfExportProgressMonitor progress) throws ImportExportException {
        TocBuilder tocBuilder = new TocBuilder();
        BookmarksBuilder bookmarksBuilder = new BookmarksBuilder();
        List<String> pageHtml = this.renderContentTreeNodes(contentTree.getRootNodes(), tocBuilder, bookmarksBuilder, 0, contentTree, progress);
        LinkFixer linkFixer = new LinkFixer(space.getKey(), this.settingsManager.getGlobalSettings().getBaseUrl(), linkRendering.getLinkStrategy());
        this.populateLinkFixer(linkFixer, contentTree, linkRendering.getInternalPages());
        return this.buildHtml(pageHtml, space, decoration, tocBuilder, bookmarksBuilder, linkFixer);
    }

    @Override
    public Document buildHtml(BlogPost blogPost) throws ImportExportException {
        ImmutableList pageHtml = ImmutableList.of((Object)this.renderToHtml((AbstractPage)blogPost, null));
        LinkFixer linkFixer = new LinkFixer(blogPost.getSpace().getKey(), this.settingsManager.getGlobalSettings().getBaseUrl(), LinkFixer.InternalPageStrategy.ANCHOR);
        return this.buildHtml((List<String>)pageHtml, blogPost.getSpace(), DecorationPolicy.none(), new TocBuilder(), new BookmarksBuilder(), linkFixer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Document buildHtml(List<String> pageHtml, Space space, DecorationPolicy decoration, TocBuilder tocBuilder, BookmarksBuilder bookmarksBuilder, LinkFixer linkFixer) throws ImportExportException {
        Reader htmlReader = this.createCompleteExportHtml(pageHtml, tocBuilder, space, decoration);
        try {
            HtmlToDomParser domParser = HtmlConverterUtils.getHtmlToXhtmlParser(linkFixer);
            Document xhtmlDocument = domParser.parse(htmlReader);
            this.addTableLayout(xhtmlDocument);
            this.insertBookmarkElement(xhtmlDocument, bookmarksBuilder);
            AutoFontScaleUtils.applyTableScalingLogic(xhtmlDocument);
            Document document = xhtmlDocument;
            return document;
        }
        finally {
            try {
                htmlReader.close();
            }
            catch (IOException ex) {
                LOG.warn((Object)"Exception while closing the intermediate HTML file for reading.");
            }
        }
    }

    private void addTableLayout(Document xhtmlDocument) {
        NodeList tables = xhtmlDocument.getElementsByTagName("table");
        if (tables.getLength() == 0) {
            return;
        }
        for (int tableIndex = 0; tableIndex < tables.getLength(); ++tableIndex) {
            Element table = (Element)tables.item(tableIndex);
            this.fixTableLayout(table);
        }
    }

    private void fixTableLayout(Element table) {
        NodeList headRow = this.getTableHeader(table);
        if (headRow != null && this.rowIsTooLong(headRow)) {
            this.fixTableStyle(table);
            return;
        }
        this.fixTableByBody(table);
    }

    private void fixTableByBody(Element table) {
        Element body = this.getFirstElementByTagName(table, "tbody");
        if (null != body) {
            NodeList children = body.getElementsByTagName("tr");
            for (int index = 0; index < children.getLength(); ++index) {
                Node row = children.item(index);
                if (!this.rowIsTooLong(row.getChildNodes())) continue;
                this.fixTableStyle(table);
                return;
            }
        }
    }

    private Element getFirstElementByTagName(Element element, String tag) {
        NodeList elements = element.getElementsByTagName(tag);
        if (elements.getLength() > 0) {
            return (Element)elements.item(0);
        }
        return null;
    }

    private void fixTableStyle(Element table) {
        table.setAttribute("class", table.getAttribute("class") + " fixedTableLayout");
        Element colGroup = this.getFirstElementByTagName(table, "colgroup");
        if (null != colGroup) {
            NodeList cols = colGroup.getElementsByTagName("col");
            for (int index = 0; index < cols.getLength(); ++index) {
                Element col = (Element)cols.item(index);
                col.removeAttribute("style");
            }
        }
    }

    private boolean rowIsTooLong(NodeList row) {
        int characterCount = 0;
        for (int col = 0; col < row.getLength(); ++col) {
            characterCount += this.getColLength(row.item(col));
        }
        return characterCount > CHARACTER_PER_LINE;
    }

    private int getColLength(Node col) {
        String content = col.getTextContent();
        return content == null ? 0 : content.length();
    }

    private NodeList getTableHeader(Element table) {
        Element header = this.getFirstElementByTagName(table, "thead");
        if (null != header) {
            Element row = this.getFirstElementByTagName(header, "tr");
            return row == null ? null : row.getChildNodes();
        }
        return null;
    }

    private void populateLinkFixer(LinkFixer linkFixer, ContentTree contentTree, Collection<Page> additionalInternalPages) {
        List contentNodes = contentTree.getAllContentNodes();
        for (ContentNode node : contentNodes) {
            Page p2 = node.getPage();
            linkFixer.addPage(p2.getIdAsString(), p2.getTitle());
        }
        additionalInternalPages.forEach(p -> linkFixer.addPage(p.getIdAsString(), p.getTitle()));
    }

    @Override
    public Document generateTableOfContents(String baseUrl, Space space, TocBuilder tocBuilder) throws ImportExportException {
        Map<String, Object> context = this.createCompleteVelocityContext(Collections.emptyList(), tocBuilder, space, DecorationPolicy.titlePage());
        StringWriter writer = new StringWriter();
        try {
            this.exportHtmlService.renderTemplateWithoutSwallowingErrors(TOC_TEMPLATE_NAME, context, writer);
        }
        catch (Exception ex) {
            throw new ImportExportException("Failure while rendering the templates/extra/pdfexport/obss-toc.vm", (Throwable)ex);
        }
        HtmlToDomParser domParser = HtmlConverterUtils.getHtmlToXhtmlParser(new LinkFixer(space.getKey(), baseUrl, LinkFixer.InternalPageStrategy.NORMALISE));
        Document xhtmlDocument = domParser.parse(new StringReader(writer.getBuffer().toString()));
        this.addTableLayout(xhtmlDocument);
        BookmarksBuilder bookmarks = new BookmarksBuilder();
        bookmarks.beginEntry(this.i18NBean.getText("com.atlassian.confluence.extra.flyingpdf.toc"));
        bookmarks.endEntry();
        this.insertBookmarkElement(xhtmlDocument, bookmarks);
        AutoFontScaleUtils.applyTableScalingLogic(xhtmlDocument);
        return xhtmlDocument;
    }

    private Reader createCompleteExportHtml(List<String> renderedPages, TocBuilder tocBuilder, Space space, DecorationPolicy decoration) throws ImportExportException {
        Writer writer;
        RenderOutput output = renderedPages.size() > 1 ? new FileRenderOutput((ExportFileNameGenerator)new ConfluenceTempDirExportFileNameGenerator(this.bootstrapManager, "htmlexport", "html", "{0,date,yyyyMMdd}", "{1,time,ddMMyy-HHmm}"), "export", "intermediate") : new StringRenderOutput();
        Map<String, Object> context = this.createCompleteVelocityContext(renderedPages, tocBuilder, space, decoration);
        try {
            writer = output.getOutputWriter();
        }
        catch (IOException ex) {
            throw new ImportExportException("Failed to open output writer for the intermediate HTML file.", (Throwable)ex);
        }
        try {
            this.exportHtmlService.renderTemplateWithoutSwallowingErrors(COMPLETE_EXPORT_PAGE_TEMPLATE_NAME, context, writer);
        }
        catch (Exception ex) {
            throw new ImportExportException("Failure while rendering the templates/extra/pdfexport/obss-completeexport.vm", (Throwable)ex);
        }
        finally {
            try {
                writer.close();
            }
            catch (IOException ex) {
                LOG.warn((Object)"Failed to close the intermediate HTML file during PDF export.", (Throwable)ex);
            }
        }
        try {
            return output.getResultReader();
        }
        catch (IOException ex) {
            throw new ImportExportException("Failed to open the intermediate HTML file for reading.");
        }
    }

    private Map<String, Object> createCompleteVelocityContext(List<String> renderedPages, TocBuilder tocBuilder, Space currentSpace, DecorationPolicy decoration) {
        String titlePage;
        String footer;
        String header;
        HashMap<String, Object> contextMap = new HashMap<String, Object>(8);
        if (decoration.components().contains((Object)DecorationPolicy.DecorationComponent.HEADER) && !StringUtils.isEmpty((CharSequence)(header = this.getHeader(currentSpace)))) {
            contextMap.put("headerHtml", header);
        }
        if (decoration.components().contains((Object)DecorationPolicy.DecorationComponent.FOOTER) && !StringUtils.isEmpty((CharSequence)(footer = this.getFooter(currentSpace)))) {
            contextMap.put("footerHtml", footer);
        }
        if (decoration.components().contains((Object)DecorationPolicy.DecorationComponent.TITLE_PAGE) && !StringUtils.isEmpty((CharSequence)(titlePage = this.getTitlePage(currentSpace)))) {
            contextMap.put("titleHtml", titlePage);
        }
        if (decoration.components().contains((Object)DecorationPolicy.DecorationComponent.PAGE_NUMBERS)) {
            contextMap.put("pageNumbers", true);
        }
        String customStyles = this.getUserStyles(currentSpace);
        String userStyle = CONFLUENCE_BASE_STYLES;
        if (customStyles != null) {
            userStyle = userStyle + customStyles;
        }
        if (!StringUtils.isEmpty((CharSequence)userStyle)) {
            contextMap.put("userStyleHtml", userStyle);
        }
        contextMap.put("styleId", MAIN_STYLE_ID);
        contextMap.put("tocEntries", tocBuilder.getEntries());
        contextMap.put("pdfResourceManager", this.pdfResourceManager);
        contextMap.put("pages", renderedPages);
        return contextMap;
    }

    private String getUserStyles(Space currentSpace) {
        String customStyles = this.pdfSettings.getStyle((BandanaContext)new ConfluenceBandanaContext(currentSpace));
        if (StringUtils.isEmpty((CharSequence)customStyles)) {
            customStyles = this.pdfSettings.getStyle((BandanaContext)new ConfluenceBandanaContext());
        }
        if (StringUtils.isNotEmpty((CharSequence)customStyles)) {
            return customStyles;
        }
        return "";
    }

    private String getTitlePage(Space currentSpace) {
        String titlePage = this.pdfSettings.getTitlePage((BandanaContext)new ConfluenceBandanaContext(currentSpace));
        if (StringUtils.isEmpty((CharSequence)titlePage)) {
            titlePage = this.pdfSettings.getTitlePage((BandanaContext)new ConfluenceBandanaContext());
        }
        return titlePage;
    }

    private String getFooter(Space currentSpace) {
        String footer = this.pdfSettings.getFooter((BandanaContext)new ConfluenceBandanaContext(currentSpace));
        if (StringUtils.isEmpty((CharSequence)footer)) {
            footer = this.pdfSettings.getFooter((BandanaContext)new ConfluenceBandanaContext());
        }
        return footer;
    }

    private String getHeader(Space currentSpace) {
        String header = this.pdfSettings.getHeader((BandanaContext)new ConfluenceBandanaContext(currentSpace));
        if (StringUtils.isEmpty((CharSequence)header)) {
            header = this.pdfSettings.getHeader((BandanaContext)new ConfluenceBandanaContext());
        }
        return header;
    }

    private List<String> renderContentTreeNodes(List<ContentNode> nodes, TocBuilder tocBuilder, BookmarksBuilder bookmarksBuilder, int level, ContentTree fullContentTree, PdfExportProgressMonitor progress) {
        ArrayList<String> renderedPagesContent = new ArrayList<String>();
        for (ContentNode node : nodes) {
            Page page = node.getPage();
            String renderedHtml = this.renderToHtml((AbstractPage)page, fullContentTree);
            renderedPagesContent.add(renderedHtml);
            progress.completedExportedHtmlConversionForPage(String.valueOf(page.getId()), page.getTitle());
            tocBuilder.addEntry(level, page.getTitle());
            bookmarksBuilder.beginEntry(page.getTitle());
            List children = node.getChildren();
            if (children != null && !children.isEmpty()) {
                renderedPagesContent.addAll(this.renderContentTreeNodes(children, tocBuilder, bookmarksBuilder, level + 1, fullContentTree, progress));
            }
            bookmarksBuilder.endEntry();
        }
        return renderedPagesContent;
    }

    private String renderToHtml(AbstractPage page, ContentTree fullContentTree) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Rendering to exported XHTML page id=" + page.getId() + " (" + page.getTitle() + ")"));
        }
        PageContext context = page.toPageContext();
        context.setBaseUrl(this.settingsManager.getGlobalSettings().getBaseUrl());
        context.setOutputType("pdf");
        DefaultConversionContext conversionContext = new DefaultConversionContext((RenderContext)context);
        if (fullContentTree != null) {
            conversionContext.setContentTree(fullContentTree);
        }
        String html = this.xhtmlRenderer.render((ContentEntityObject)page, (ConversionContext)conversionContext);
        return this.renderPageTemplate(page.getTitle(), html);
    }

    private String renderPageTemplate(String title, String content) {
        HashMap<String, String> contextMap = new HashMap<String, String>(2);
        contextMap.put("pageTitle", title);
        contextMap.put("contentHtml", content);
        return VelocityUtils.getRenderedTemplate((String)PAGE_TEMPLATE_NAME, contextMap);
    }

    private void insertBookmarkElement(Document document, BookmarksBuilder builder) {
        List<BookmarksBuilder.BookmarkEntry> topLevelBookmarks = builder.getEntries();
        if (topLevelBookmarks.isEmpty()) {
            return;
        }
        Element bookmarksElement = document.createElement("bookmarks");
        NodeList headList = document.getElementsByTagName("head");
        if (headList.getLength() < 1) {
            return;
        }
        Node headNode = headList.item(0);
        headNode.appendChild(bookmarksElement);
        this.appendBookmarksElement(document, bookmarksElement, topLevelBookmarks);
    }

    private void appendBookmarksElement(Document document, Node parentNode, List<BookmarksBuilder.BookmarkEntry> bookmarkEntries) {
        for (BookmarksBuilder.BookmarkEntry entry : bookmarkEntries) {
            Element bookmarkElement = document.createElement("bookmark");
            bookmarkElement.setAttribute("name", entry.getTitle());
            bookmarkElement.setAttribute("href", "#" + entry.getTitle());
            parentNode.appendChild(bookmarkElement);
            if (!entry.hasChildEntries()) continue;
            this.appendBookmarksElement(document, bookmarkElement, entry.getChildEntries());
        }
    }

    private static String loadResource(String masterCss) {
        try {
            InputStream in = RenderedXhtmlBuilder.class.getResourceAsStream("/templates/extra/pdfexport/" + masterCss);
            String ret = IOUtils.toString((InputStream)in, (String)"ASCII");
            IOUtils.closeQuietly((InputStream)in);
            return ret;
        }
        catch (Throwable t) {
            if (LOG != null) {
                LOG.error((Object)"Unable to load the default styles for PDF export", t);
            }
            return "";
        }
    }

    private static class StringRenderOutput
    implements RenderOutput {
        private final StringWriter writer = new StringWriter();

        private StringRenderOutput() {
        }

        @Override
        public Writer getOutputWriter() {
            return this.writer;
        }

        @Override
        public Reader getResultReader() {
            return new StringReader(this.writer.getBuffer().toString());
        }
    }

    private static class FileRenderOutput
    implements RenderOutput {
        private final File outputFile;

        FileRenderOutput(ExportFileNameGenerator fileNameGenerator, String ... distinguishers) throws ImportExportException {
            try {
                this.outputFile = fileNameGenerator.getExportFile(distinguishers);
            }
            catch (Exception ex) {
                throw new ImportExportException("Failed to create output file during PDF export.");
            }
        }

        @Override
        public Writer getOutputWriter() throws IOException {
            return new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.outputFile), StandardCharsets.UTF_8));
        }

        @Override
        public Reader getResultReader() throws IOException {
            return new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.outputFile), StandardCharsets.UTF_8));
        }
    }

    private static interface RenderOutput {
        public Writer getOutputWriter() throws IOException;

        public Reader getResultReader() throws IOException;
    }
}

