/*
 * Decompiled with CFR 0.152.
 */
package tr.com.obss.plugin.rest;

import com.atlassian.json.jsonorg.JSONObject;
import java.util.UUID;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tr.com.obss.plugin.progress.BaselineProgressTracker;

@Path(value="/progressService")
public class BaselineProgressRestService {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaselineProgressRestService.class);

    @GET
    @Path(value="/getProgress")
    public Response getProgress(@QueryParam(value="operationId") String operationIdAsString) {
        UUID operationId = null;
        try {
            operationId = UUID.fromString(operationIdAsString);
        }
        catch (Exception e) {
            LOGGER.error("Invalid operationId for progress tracking. operationId: {}", (Object)operationIdAsString);
        }
        JSONObject data = new JSONObject();
        data.put("percentageComplete", BaselineProgressTracker.getCurrentPercentage(operationId));
        return Response.ok((Object)data.toString(), (String)"application/json").build();
    }
}

