/*
 * Decompiled with CFR 0.152.
 */
package tr.com.obss.plugin.collector.page;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.spaces.Space;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import tr.com.obss.plugin.collector.page.PageCollector;
import tr.com.obss.plugin.dto.CollectedAttachment;
import tr.com.obss.plugin.dto.CollectedPage;
import tr.com.obss.plugin.dto.CollectedPageMap;
import tr.com.obss.plugin.dto.SelectedPage;
import tr.com.obss.plugin.exception.BaselineParameterException;
import tr.com.obss.plugin.exception.DuplicatePageSelectionWithNonMatchingVersionsException;
import tr.com.obss.plugin.exception.InvalidFullySelectedPagesParameterException;
import tr.com.obss.plugin.exception.InvalidPartiallySelectedPagesParameterException;
import tr.com.obss.plugin.progress.BaselineProgressTracker;
import tr.com.obss.plugin.progress.SimpleBaselineProgress;
import tr.com.obss.plugin.utils.Utils;

public class VersionBasedPageCollector
extends PageCollector {
    private final List<SelectedPage> partiallySelectedPages;
    private final List<SelectedPage> fullySelectedPages;
    private final CollectedPageMap collectedPages;

    public VersionBasedPageCollector(Space space, List<SelectedPage> partiallySelectedPages, List<SelectedPage> fullySelectedPages) {
        super(space);
        this.partiallySelectedPages = partiallySelectedPages;
        this.fullySelectedPages = fullySelectedPages;
        this.collectedPages = new CollectedPageMap();
    }

    public VersionBasedPageCollector(Space space, UUID operationId, List<SelectedPage> partiallySelectedPages, List<SelectedPage> fullySelectedPages) {
        this(space, partiallySelectedPages, fullySelectedPages);
        this.baselineProgress = (SimpleBaselineProgress)BaselineProgressTracker.getProgress(operationId);
    }

    @Override
    public CollectedPageMap collect() throws BaselineParameterException {
        if (Objects.isNull(this.partiallySelectedPages)) {
            throw new InvalidPartiallySelectedPagesParameterException();
        }
        if (Objects.isNull(this.fullySelectedPages)) {
            throw new InvalidFullySelectedPagesParameterException();
        }
        this.processPartiallySelectedPages();
        this.processFullySelectedPages();
        this.processFullySelectedDescents();
        return this.collectedPages;
    }

    private void processPartiallySelectedPages() throws DuplicatePageSelectionWithNonMatchingVersionsException {
        for (SelectedPage selectedPage : this.partiallySelectedPages) {
            this.collectPageIfSuitable(selectedPage);
        }
    }

    private void processFullySelectedPages() throws DuplicatePageSelectionWithNonMatchingVersionsException {
        for (SelectedPage selectedPage : this.fullySelectedPages) {
            this.collectPageIfSuitable(selectedPage);
        }
    }

    public void collectPageIfSuitable(SelectedPage selectedPage) throws DuplicatePageSelectionWithNonMatchingVersionsException {
        long pageId = Utils.convertPageId(selectedPage.getId());
        Page page = this.pageManager.getPage(pageId);
        if (Objects.isNull(page)) {
            this.warnings.add(String.format("Page not found with id %s.", pageId));
            return;
        }
        if (!selectedPage.getVersion().equals("latest")) {
            int pageVersion = Integer.parseInt(selectedPage.getVersion());
            if (Objects.isNull(page = (Page)this.pageManager.getOtherVersion((ContentEntityObject)page, pageVersion))) {
                this.warnings.add(String.format("Page %d was not included because version %d not found.", pageId, pageVersion));
                return;
            }
            if (!page.isCurrent()) {
                this.warnings.add(String.format("Page %d was not included because it's not current.", pageId));
                return;
            }
        }
        if (this.collectedPages.containsPageWithAnyVersion(page)) {
            CollectedPage existsPage = this.collectedPages.getCollectedPageWithAnyVersionOfPage(page);
            if (!existsPage.getUsingSelectedPage().getVersion().equals(selectedPage.getVersion()) || existsPage.getCollectedPageVersion().getVersion() != page.getVersion()) {
                throw new DuplicatePageSelectionWithNonMatchingVersionsException();
            }
        } else {
            List<CollectedAttachment> attachments = selectedPage.getVersion().equals("latest") ? this.attachmentCollector.collect(page) : this.attachmentCollector.collect(page, page.getLastModificationDate());
            this.collectedPages.put(page.getIdAsString(), new CollectedPage(selectedPage, page, attachments));
        }
        this.progressUpdateEvent();
    }

    public void processFullySelectedDescents() {
        for (SelectedPage selectedPage : this.fullySelectedPages) {
            long pageId = Utils.convertPageId(selectedPage.getId());
            Page page = this.pageManager.getPage(pageId);
            if (Objects.isNull(page)) {
                this.warnings.add(String.format("Page not found with id %s.", pageId));
                continue;
            }
            for (Page descent : this.pageManager.getDescendants(page)) {
                if (!descent.isCurrent()) {
                    this.warnings.add(String.format("Page %d was not included because it's not current.", descent.getId()));
                    continue;
                }
                if (!this.collectedPages.containsPageWithAnyVersion(descent)) {
                    List<CollectedAttachment> attachments = descent.equals((Object)descent.getLatestVersion()) ? this.attachmentCollector.collect(descent) : this.attachmentCollector.collect(descent, descent.getLastModificationDate());
                    SelectedPage sPage = new SelectedPage("bsl_" + descent.getId(), descent.getVersion());
                    CollectedPage collectedPage = new CollectedPage(sPage, descent, attachments);
                    this.collectedPages.put(descent.getIdAsString(), collectedPage);
                }
                this.progressUpdateEvent();
            }
        }
    }
}

