/*
 * Decompiled with CFR 0.152.
 */
package tr.com.obss.plugin.servlet;

import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.xwork.RequireSecurityToken;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tr.com.obss.plugin.baseline.BaselineService;
import tr.com.obss.plugin.baseline.parameter.BaselineCompareParameterBuilder;
import tr.com.obss.plugin.date.BaselineDateService;
import tr.com.obss.plugin.dto.BaselineDocumentTypeQuery;
import tr.com.obss.plugin.dto.CompareResult;
import tr.com.obss.plugin.exception.BaselineNotFoundException;
import tr.com.obss.plugin.exception.InvalidBaselineNamesToCompareException;
import tr.com.obss.plugin.exception.InvalidOperationIdException;
import tr.com.obss.plugin.exception.OperationIdAlreadyExistsException;
import tr.com.obss.plugin.exception.SpaceKeyParameterIsRequiredException;
import tr.com.obss.plugin.exception.SpaceNotFoundException;
import tr.com.obss.plugin.utils.TemplateUtil;
import tr.com.obss.plugin.utils.UrlUtils;
import tr.com.obss.plugin.utils.UserHasCondition;
import tr.com.obss.plugin.utils.Utils;

public class BaseLineCompareServlet
extends HttpServlet {
    private static final long serialVersionUID = 400647569503228949L;
    private static final Logger LOG = LoggerFactory.getLogger(BaseLineCompareServlet.class);
    private static final String SPACE_KEY = "space";
    private static final String SELECTED_BASELINES = "selectedBaselines";
    private static final String OPERATION_ID = "operationId";
    private static final String NOT_AUTH_TEMPLATE = "/templates/baselineNotAuth.vm";
    private static final String LICENSE_ERROR_TEMPLATE = "/templates/baselineInvalidLicense.vm";
    private static final String COMPARE_TEMPLATE = "/templates/baselineCompare.vm";
    private final TemplateRenderer templateRenderer;
    private final LoginUriProvider loginUriProvider;
    private final PluginLicenseManager licenseManager;
    private final BaselineDateService dateService;
    private final UserHasCondition userHasCondition;
    private final BaselineService baselineService;

    public BaseLineCompareServlet(TemplateRenderer templateRenderer, LoginUriProvider loginUriProvider, PluginLicenseManager licenseManager, BaselineDateService dateService, BaselineService baselineService, UserAccessor userAccessor, PluginSettingsFactory pluginSettingsFactory) {
        this.templateRenderer = templateRenderer;
        this.loginUriProvider = loginUriProvider;
        this.licenseManager = licenseManager;
        this.dateService = dateService;
        this.userHasCondition = new UserHasCondition(userAccessor, pluginSettingsFactory);
        this.baselineService = baselineService;
    }

    @RequireSecurityToken(value=true)
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) {
        try {
            resp.setContentType("text/html;charset=utf-8");
            ConfluenceUser currentUser = AuthenticatedUserThreadLocal.get();
            if (currentUser == null) {
                Utils.redirectToLogin(req, resp, this.loginUriProvider);
                return;
            }
            HashMap context = Maps.newHashMap();
            if (!Utils.isLicenseValid(this.licenseManager)) {
                this.templateRenderer.render(LICENSE_ERROR_TEMPLATE, (Map)context, (Writer)resp.getWriter());
                return;
            }
            Boolean userIsInEditGroups = this.userHasCondition.isInEditGroups(AuthenticatedUserThreadLocal.getUsername());
            Boolean userIsInViewGroups = this.userHasCondition.isInViewGroups(AuthenticatedUserThreadLocal.getUsername());
            if (!userIsInEditGroups.booleanValue() && !userIsInViewGroups.booleanValue()) {
                this.templateRenderer.render(NOT_AUTH_TEMPLATE, (Map)context, (Writer)resp.getWriter());
                return;
            }
            BaselineCompareParameterBuilder.BaselineCompareParameters parameters = new BaselineCompareParameterBuilder(req.getParameter(OPERATION_ID), req.getParameter(SPACE_KEY), req.getParameterValues(SELECTED_BASELINES)).build();
            CompareResult compareResult = this.baselineService.compareBaselines(parameters);
            context.put("compareResult", compareResult);
            context.put("df", this.dateService.getUserPreferencesDateFormatter());
            context.put("baseUrl", UrlUtils.getBaseUrl(req));
            context.put("page", BaselineDocumentTypeQuery.PAGE.toString());
            context.put("attachment", BaselineDocumentTypeQuery.ATTACHMENT.toString());
            context.put("anyDocument", BaselineDocumentTypeQuery.ANY_DOCUMENT.toString());
            context.put("isCurrentVersionEqualOrHigherThan6_13_0", Utils.isCurrentVersionEqualOrHigherThan("6.13.0"));
            context.put("isCurrentVersionEqualOrHigherThan7_4_17", Utils.isCurrentVersionEqualOrHigherThan("7.4.17"));
            this.templateRenderer.render(COMPARE_TEMPLATE, (Map)context, (Writer)resp.getWriter());
        }
        catch (SpaceKeyParameterIsRequiredException e) {
            LOG.debug("SpaceKeyParameterIsRequiredException", (Throwable)e);
            this.sendResponseToClient(resp, 400, "space-key parameter is required");
        }
        catch (SpaceNotFoundException e) {
            LOG.debug("SpaceNotFoundException", (Throwable)e);
            this.sendResponseToClient(resp, 400, "space not found");
        }
        catch (InvalidOperationIdException e) {
            LOG.debug("InvalidOperationIdException", (Throwable)e);
            this.sendResponseToClient(resp, 400, "invalid operationId");
        }
        catch (OperationIdAlreadyExistsException e) {
            LOG.debug("OperationIdAlreadyExistsException", (Throwable)e);
            this.sendResponseToClient(resp, 400, "operationId already exists");
        }
        catch (InvalidBaselineNamesToCompareException e) {
            LOG.debug("InvalidBaselineNamesToCompareException", (Throwable)e);
            this.sendResponseToClient(resp, 400, "invalid baselines");
        }
        catch (BaselineNotFoundException e) {
            LOG.debug("BaselineNotFoundException", (Throwable)e);
            this.sendResponseToClient(resp, 400, "baseline not found");
        }
        catch (Exception e) {
            LOG.debug("Unexpected exception", (Throwable)e);
            this.sendResponseToClient(resp, 500, "an unexpected error has occurred");
        }
    }

    private void sendResponseToClient(HttpServletResponse resp, int httpStatus, String message) {
        try {
            resp.setStatus(httpStatus);
            TemplateUtil templateUtil = new TemplateUtil(this.templateRenderer);
            templateUtil.renderErrorPage(message, resp.getWriter());
        }
        catch (IOException e) {
            LOG.error("Could not send response to client.", (Throwable)e);
        }
    }
}

