/*
 * Decompiled with CFR 0.152.
 */
package tr.com.obss.plugin.date;

import com.atlassian.confluence.core.DateFormatter;
import com.atlassian.confluence.core.FormatSettingsManager;
import com.atlassian.confluence.languages.LocaleManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUserPreferences;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.sal.api.timezone.TimeZoneManager;
import com.atlassian.user.User;
import java.text.DateFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tr.com.obss.plugin.date.BaselineDateService;

public class BaselineDateServiceImpl
implements BaselineDateService {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaselineDateServiceImpl.class);
    private static final String DATE_PATTERN = "yyyy-MM-dd HH:mm:ss";
    private UserAccessor userAccessor;
    private FormatSettingsManager formatSettingsManager;
    private LocaleManager localeManager;
    private TimeZoneManager timeZoneManager;

    public BaselineDateServiceImpl(UserAccessor userAccessor, FormatSettingsManager formatSettingsManager, LocaleManager localeManager, TimeZoneManager timeZoneManager) {
        this.userAccessor = userAccessor;
        this.formatSettingsManager = formatSettingsManager;
        this.localeManager = localeManager;
        this.timeZoneManager = timeZoneManager;
    }

    @Override
    public DateFormat getDateFormatWithUserTimezone() {
        SimpleDateFormat dateFormat = new SimpleDateFormat(DATE_PATTERN);
        dateFormat.setLenient(false);
        dateFormat.setTimeZone(this.timeZoneManager.getUserTimeZone());
        return dateFormat;
    }

    @Override
    public String getCurrentDateForUserAsString() {
        DateFormat dateFormat = this.getDateFormatWithUserTimezone();
        return dateFormat.format(new Date());
    }

    @Override
    public Date convertToServerDate(String date) {
        DateFormat dateFormat = this.getDateFormatWithUserTimezone();
        try {
            ParsePosition position = new ParsePosition(0);
            Date serverDate = dateFormat.parse(date, position);
            if (position.getIndex() != date.length()) {
                LOGGER.error("Date string could not be parsed. date: {}", (Object)date);
                return null;
            }
            return serverDate;
        }
        catch (Exception e) {
            LOGGER.error("Error while converting to server date: " + date, (Throwable)e);
            return null;
        }
    }

    @Override
    public DateFormatter getUserPreferencesDateFormatter() {
        ConfluenceUserPreferences preferences = this.userAccessor.getConfluenceUserPreferences((User)AuthenticatedUserThreadLocal.get());
        return preferences.getDateFormatter(this.formatSettingsManager, this.localeManager);
    }
}

