/*
 * Decompiled with CFR 0.152.
 */
package tr.com.obss.plugin.collector.page;

import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.spaces.Space;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tr.com.obss.plugin.ServiceAccessor;
import tr.com.obss.plugin.collector.attachment.AttachmentCollector;
import tr.com.obss.plugin.dto.CollectedPageMap;
import tr.com.obss.plugin.exception.BaselineParameterException;
import tr.com.obss.plugin.progress.SimpleBaselineProgress;

public abstract class PageCollector {
    protected static final Logger log = LoggerFactory.getLogger(PageCollector.class);
    protected final Space space;
    protected final List<String> warnings;
    protected final PageManager pageManager = ServiceAccessor.getPageManager();
    protected AttachmentCollector attachmentCollector = new AttachmentCollector();
    protected SimpleBaselineProgress baselineProgress;

    public PageCollector(Space space) {
        this.space = space;
        this.warnings = new ArrayList<String>();
    }

    public void progressUpdateEvent() {
        if (Objects.nonNull(this.baselineProgress)) {
            this.baselineProgress.tick();
        }
    }

    public abstract CollectedPageMap collect() throws BaselineParameterException;

    public List<String> getWarnings() {
        return this.warnings;
    }
}

