/*
 * Decompiled with CFR 0.152.
 */
package tr.com.obss.plugin.utils;

import com.atlassian.confluence.importexport.impl.ConfluenceTempDirExportFileNameGenerator;
import com.atlassian.confluence.setup.BootstrapManager;
import java.io.File;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tr.com.obss.plugin.utils.Utils;

public final class FileUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileUtils.class);

    private FileUtils() {
    }

    public static File generateFileInTempDir(BootstrapManager bootstrapManager, String exportDirPrefix, String extension, String fileNamePrefix) {
        try {
            return new ConfluenceTempDirExportFileNameGenerator(bootstrapManager, exportDirPrefix, extension, "{0,date,yyyyMMdd}", "{1,time,ddMMyy-HHmm}").getExportFile(new String[]{fileNamePrefix});
        }
        catch (IOException e) {
            LOGGER.error("Couldn't generate file in temp directory.", (Throwable)e);
            return null;
        }
    }

    public static String getDownloadPath(File file, BootstrapManager bootstrapManager) {
        try {
            String rawPath = FileUtils.prepareDownloadPath(file, bootstrapManager);
            return FileUtils.replaceBackslashes(rawPath);
        }
        catch (IOException e) {
            LOGGER.error("Error while creating download path.", (Throwable)e);
            return null;
        }
    }

    private static String prepareDownloadPath(File file, BootstrapManager bootstrapManager) throws IOException {
        String homeDir = bootstrapManager.getLocalHome().getCanonicalPath();
        String exportDir = FileUtils.getExportDir(bootstrapManager);
        String canonicalPath = file.getCanonicalPath();
        int homeDirIndex = canonicalPath.indexOf(homeDir);
        String urlPath = null;
        if (homeDirIndex != -1) {
            urlPath = canonicalPath.substring(homeDirIndex + homeDir.length() + 1);
        } else {
            for (File root : File.listRoots()) {
                String rootPath = root.getCanonicalPath();
                int rootIndex = canonicalPath.indexOf(rootPath);
                if (rootIndex == -1) continue;
                urlPath = canonicalPath.substring(rootIndex + rootPath.length());
                break;
            }
            if (urlPath == null) {
                LOGGER.warn("Path to the download [ {} ] has not been stripped of any parent directories, and may be invalid", (Object)file);
                urlPath = file.getPath();
            }
        }
        if (Utils.isCurrentVersionEqualOrHigherThan("7.19")) {
            urlPath = urlPath.replace(exportDir.substring(homeDir.length() + 1), "export");
        }
        return "/download/" + urlPath;
    }

    private static String replaceBackslashes(String relativeFilePath) {
        return relativeFilePath.replaceAll("\\\\", "/");
    }

    private static String getExportDir(BootstrapManager bootstrapManager) {
        return bootstrapManager.getFilePathProperty("webwork.multipart.saveDir");
    }
}

