/*
 * Decompiled with CFR 0.152.
 */
package tr.com.obss.plugin.servlet;

import com.atlassian.config.ApplicationConfiguration;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.json.jsonorg.JSONException;
import com.atlassian.json.jsonorg.JSONObject;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.xwork.RequireSecurityToken;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tr.com.obss.plugin.baseline.BaselineService;
import tr.com.obss.plugin.baseline.parameter.BaselineCreateParameterBuilder;
import tr.com.obss.plugin.baseline.parameter.BaselineCreateParameters;
import tr.com.obss.plugin.baseline.request.BaselineCreateRequest;
import tr.com.obss.plugin.date.BaselineDateService;
import tr.com.obss.plugin.dto.BaselineCreateResult;
import tr.com.obss.plugin.exception.BaselineParameterException;
import tr.com.obss.plugin.utils.UrlUtils;
import tr.com.obss.plugin.utils.UserHasCondition;
import tr.com.obss.plugin.utils.Utils;

public class BaseLineCreateServlet
extends HttpServlet {
    private static final long serialVersionUID = 3174031603439715007L;
    private static final Logger LOG = LoggerFactory.getLogger(BaseLineCreateServlet.class);
    private static final String BASELINE_CREATE_TEMPLATE = "/templates/baselineCreate.vm";
    private static final String NOT_AUTH_TEMPLATE = "/templates/baselineNotAuth.vm";
    private static final String LICENSE_ERROR_TEMPLATE = "/templates/baselineInvalidLicense.vm";
    private final ApplicationConfiguration applicationConfiguration;
    private final TemplateRenderer templateRenderer;
    private final UserHasCondition userHasCondition;
    private final PluginLicenseManager licenseManager;
    private final BaselineService baselineService;
    private final BaselineDateService dateService;

    public BaseLineCreateServlet(ApplicationConfiguration applicationConfiguration, TemplateRenderer templateRenderer, PluginSettingsFactory pluginSettingsFactory, UserAccessor userAccessor, PluginLicenseManager licenseManager, BaselineService baselineService, BaselineDateService dateService) {
        this.applicationConfiguration = applicationConfiguration;
        this.templateRenderer = templateRenderer;
        this.userHasCondition = new UserHasCondition(userAccessor, pluginSettingsFactory);
        this.licenseManager = licenseManager;
        this.baselineService = baselineService;
        this.dateService = dateService;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) {
        try {
            resp.setContentType("text/html;charset=utf-8");
            HashMap context = Maps.newHashMap();
            if (AuthenticatedUserThreadLocal.get() == null) {
                this.templateRenderer.render(NOT_AUTH_TEMPLATE, (Map)context, (Writer)resp.getWriter());
            } else if (!Utils.isLicenseValid(this.licenseManager)) {
                LOG.debug("license is invalid");
                this.templateRenderer.render(LICENSE_ERROR_TEMPLATE, (Map)context, (Writer)resp.getWriter());
            } else {
                String spaceKey = req.getParameter("space-key");
                LOG.debug("create servlet received GET request for space key {}", (Object)spaceKey);
                Boolean isInEditGroups = this.userHasCondition.isInEditGroups(AuthenticatedUserThreadLocal.getUsername());
                context.put("baseUrl", UrlUtils.getBaseUrl(req));
                context.put("spaceKey", spaceKey);
                context.put("currentDateForUser", this.dateService.getCurrentDateForUserAsString());
                if (isInEditGroups.booleanValue()) {
                    this.templateRenderer.render(BASELINE_CREATE_TEMPLATE, (Map)context, (Writer)resp.getWriter());
                    LOG.debug("create servlet GET completed with spaceKey: {}", (Object)spaceKey);
                } else {
                    LOG.debug("user does not have permission to create baseline");
                    this.templateRenderer.render(NOT_AUTH_TEMPLATE, (Writer)resp.getWriter());
                }
            }
        }
        catch (Exception e) {
            LOG.error("Error while opening create baseline page.", (Throwable)e);
        }
    }

    @RequireSecurityToken(value=true)
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) {
        resp.setContentType("application/json");
        if (AuthenticatedUserThreadLocal.get() == null) {
            this.sendResponseToClient(resp, 403, "You are not authorized for this operation.");
            return;
        }
        if (!Utils.isLicenseValid(this.licenseManager)) {
            this.sendResponseToClient(resp, 403, "Your Baselines for Confluence license has expired.");
            return;
        }
        if (Utils.isReadOnlyModeEnabled(this.applicationConfiguration)) {
            this.sendResponseToClient(resp, 403, "Read-only mode is enabled. You cannot create baseline right now.");
            return;
        }
        Boolean isInEditGroups = this.userHasCondition.isInEditGroups(AuthenticatedUserThreadLocal.getUsername());
        if (!isInEditGroups.booleanValue()) {
            LOG.debug("user does not have permission to create baseline");
            this.sendResponseToClient(resp, 403, "unauthorized user");
            return;
        }
        try {
            BaselineCreateRequest baselineCreateRequest = BaselineCreateRequest.fromRequestParameters(req.getParameterMap());
            BaselineCreateParameters parameters = new BaselineCreateParameterBuilder(baselineCreateRequest).build();
            BaselineCreateResult result = this.baselineService.createBaseline(parameters);
            this.sendResponseToClient(resp, 200, result.getSuccessMessage(), result.getWarnings());
        }
        catch (BaselineParameterException e) {
            LOG.warn("BaselineParameterException", (Throwable)e);
            this.sendResponseToClient(resp, 400, e.getMessage());
        }
        catch (Exception e) {
            LOG.warn("Unexpected exception", (Throwable)e);
            this.sendResponseToClient(resp, 500, "an unexpected error has occurred");
        }
    }

    private void sendResponseToClient(HttpServletResponse response, int httpStatus, String message) {
        this.sendResponseToClient(response, httpStatus, message, new ArrayList<String>());
    }

    private void sendResponseToClient(HttpServletResponse response, int httpStatus, String message, List<String> warnings) {
        try {
            response.setStatus(httpStatus);
            response.getWriter().write(this.getResultJSON(message, warnings));
        }
        catch (IOException e) {
            LOG.error("Error while sending response to client.", (Throwable)e);
            try {
                response.sendError(500, "An unexpected error occurred while processing your request: " + e.getMessage());
            }
            catch (IOException e2) {
                LOG.error(e2.getMessage(), (Throwable)e2);
            }
        }
    }

    private String getResultJSON(String message, List<String> warnings) {
        try {
            JSONObject resultJSON = new JSONObject();
            resultJSON.put("message", (Object)message);
            resultJSON.put("warnings", warnings);
            return resultJSON.toString();
        }
        catch (JSONException e) {
            LOG.error("Error while creating json.", (Throwable)e);
            return "{}";
        }
    }
}

