/*
 * Decompiled with CFR 0.152.
 */
package tr.com.obss.plugin.rest;

import com.atlassian.config.ApplicationConfiguration;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.upm.api.license.PluginLicenseManager;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tr.com.obss.plugin.baseline.BaselineService;
import tr.com.obss.plugin.baseline.parameter.BaselineCreateParameterBuilder;
import tr.com.obss.plugin.baseline.parameter.BaselineCreateParameters;
import tr.com.obss.plugin.baseline.request.BaselineCreateRequest;
import tr.com.obss.plugin.dto.BaselineCreateResult;
import tr.com.obss.plugin.exception.BaselineParameterException;
import tr.com.obss.plugin.utils.UserHasCondition;
import tr.com.obss.plugin.utils.Utils;

@Path(value="/baselineService")
public class BaselineRestService {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaselineRestService.class);
    private final ApplicationConfiguration applicationConfiguration;
    private final UserHasCondition userHasCondition;
    private final PluginLicenseManager licenseManager;
    private final BaselineService baselineService;

    public BaselineRestService(ApplicationConfiguration applicationConfiguration, PluginSettingsFactory pluginSettingsFactory, UserAccessor userAccessor, PluginLicenseManager licenseManager, BaselineService baselineService) {
        this.applicationConfiguration = applicationConfiguration;
        this.userHasCondition = new UserHasCondition(userAccessor, pluginSettingsFactory);
        this.licenseManager = licenseManager;
        this.baselineService = baselineService;
    }

    @POST
    @Path(value="/createBaseline")
    public Response createBaseline(BaselineCreateRequest baselineCreateRequest) {
        if (AuthenticatedUserThreadLocal.get() == null) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)"You are not authorized for this operation.").build();
        }
        if (!Utils.isLicenseValid(this.licenseManager)) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)"Your Baselines for Confluence license has expired.").build();
        }
        if (Utils.isReadOnlyModeEnabled(this.applicationConfiguration)) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)"Read-only mode is enabled. You cannot create baseline right now.").build();
        }
        Boolean isInEditGroups = this.userHasCondition.isInEditGroups(AuthenticatedUserThreadLocal.getUsername());
        if (!isInEditGroups.booleanValue()) {
            LOGGER.debug("user does not have permission to create baseline");
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)"unauthorized user").build();
        }
        try {
            BaselineCreateParameters parameters = new BaselineCreateParameterBuilder(baselineCreateRequest).build();
            BaselineCreateResult result = this.baselineService.createBaseline(parameters);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)result.getSuccessMessage()).build();
        }
        catch (BaselineParameterException e) {
            LOGGER.warn("BaselineParameterException", (Throwable)e);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
        }
        catch (Exception e) {
            LOGGER.warn("Unexpected exception", (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"an unexpected error has occurred").build();
        }
    }
}

