/*
 * Decompiled with CFR 0.152.
 */
package tr.com.obss.plugin.rest;

import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.json.jsonorg.JSONObject;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.upm.api.license.PluginLicenseManager;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import tr.com.obss.plugin.dto.BaselineCsvSeparatorType;
import tr.com.obss.plugin.export.BaselineExportService;
import tr.com.obss.plugin.export.BaselinePdfExportProcessTracker;
import tr.com.obss.plugin.utils.UserHasCondition;
import tr.com.obss.plugin.utils.Utils;

@Path(value="/exportService")
public class BaselineExportRestService {
    private BaselineExportService baselineExportService;
    private UserHasCondition userHasCondition;
    private final PluginLicenseManager licenseManager;

    public BaselineExportRestService(BaselineExportService pdfExportService, UserAccessor userAccessor, PluginSettingsFactory pluginSettingsFactory, PluginLicenseManager licenseManager) {
        this.baselineExportService = pdfExportService;
        this.userHasCondition = new UserHasCondition(userAccessor, pluginSettingsFactory);
        this.licenseManager = licenseManager;
    }

    @GET
    @Path(value="/createPdf")
    public Response createPdf(@QueryParam(value="pageId") Long pageId, @QueryParam(value="pageVersion") int pageVersion, @Context HttpServletRequest request) {
        if (!Utils.isLicenseValid(this.licenseManager)) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)"Your Baselines for Confluence license has been expired.").build();
        }
        if (this.userHasCondition.isInExportGroups(AuthenticatedUserThreadLocal.get().getName()).booleanValue()) {
            String result = this.baselineExportService.createPdfForPage(pageId, pageVersion, request.getContextPath());
            return Response.ok((Object)result, (String)"text/plain").build();
        }
        return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)"You are not authorized for pdf export operation.").build();
    }

    @GET
    @Path(value="/createPdfForBaseline")
    public Response createPdfForBaseline(@QueryParam(value="baselineName") String baselineName, @QueryParam(value="spaceKey") String spaceKey, @Context HttpServletRequest request) {
        if (!Utils.isLicenseValid(this.licenseManager)) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)"Your Baselines for Confluence license has been expired.").build();
        }
        if (this.userHasCondition.isInExportGroups(AuthenticatedUserThreadLocal.get().getName()).booleanValue()) {
            UUID exportId = this.baselineExportService.createPdfForBaseline(baselineName, spaceKey, request.getContextPath());
            return Response.ok((Object)(exportId != null ? exportId.toString() : null), (String)"text/plain").build();
        }
        return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)"You are not authorized for pdf export operation.").build();
    }

    @GET
    @Path(value="/createCsv")
    public Response createCsvSemicolon(@QueryParam(value="baselineName") String baselineName, @QueryParam(value="spaceKey") String spaceKey, @QueryParam(value="separatorType") String separatorType, @Context HttpServletRequest request) {
        if (this.userHasCondition.isInExportGroups(AuthenticatedUserThreadLocal.get().getName()).booleanValue()) {
            String requestURL = request.getRequestURL().toString();
            String requestURI = request.getRequestURI();
            String baseURL = requestURL.replace(requestURI, "") + request.getContextPath();
            BaselineCsvSeparatorType csvSeparatorType = BaselineCsvSeparatorType.lookup(separatorType);
            String result = this.baselineExportService.createCsvForBaseline(baselineName, spaceKey, csvSeparatorType, baseURL);
            return Response.ok((Object)result, (String)"text/plain").build();
        }
        return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)"You are not authorized for csv export operation.").build();
    }

    @GET
    @Path(value="/getProcess")
    public Response getProcess(@QueryParam(value="exportId") UUID exportId) {
        JSONObject data = new JSONObject();
        data.put("percentageComplete", BaselinePdfExportProcessTracker.getPercentageComplete(exportId));
        data.put("currentCount", BaselinePdfExportProcessTracker.getCurrentCount(exportId));
        data.put("total", BaselinePdfExportProcessTracker.getTotal(exportId));
        data.put("isCompletedSuccessfully", BaselinePdfExportProcessTracker.isCompletedSuccessfully(exportId));
        data.put("status", (Object)BaselinePdfExportProcessTracker.getStatus(exportId));
        return Response.ok((Object)data.toString(), (String)"application/json").build();
    }
}

