/*
 * Decompiled with CFR 0.152.
 */
package tr.com.obss.plugin.extra.flyingpdf.upgrade;

import com.atlassian.confluence.setup.BootstrapManager;
import java.io.File;
import java.io.IOException;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import tr.com.obss.plugin.extra.flyingpdf.config.FontManager;

public class UpgradePdfLanguageSupport
implements InitializingBean {
    private static final Logger LOGGER = Logger.getLogger(UpgradePdfLanguageSupport.class);
    private BootstrapManager bootstrapManager;
    private FontManager pdfExportFontManager;

    public void afterPropertiesSet() {
        if (this.pdfExportFontManager.isCustomFontInstalled()) {
            return;
        }
        File fontDir = new File(this.bootstrapManager.getApplicationHome() + File.separator + "fonts");
        if (!fontDir.exists()) {
            return;
        }
        File[] fontFiles = fontDir.listFiles();
        if (fontFiles == null || fontFiles.length == 0) {
            return;
        }
        if (fontFiles.length > 1) {
            LOGGER.warn((Object)"More than one file was found in the font directory - custom font will not be migrated for use with the PDF Export plugin.");
            return;
        }
        try {
            String tempDir = this.bootstrapManager.getFilePathProperty("webwork.multipart.saveDir") + File.separator + System.currentTimeMillis();
            File tempFontDir = new File(tempDir);
            if (!tempFontDir.mkdir()) {
                throw new IOException("Failed to create the temporary font storage directory " + tempFontDir);
            }
            File tempFontFile = new File(tempFontDir, fontFiles[0].getName());
            if (!fontFiles[0].renameTo(tempFontFile)) {
                throw new IOException("Could not move the currently installed font " + fontFiles[0].getAbsolutePath() + " to a temporary location of " + tempDir);
            }
            this.pdfExportFontManager.installFont((Resource)new FileSystemResource(tempFontFile));
            LOGGER.info((Object)("Successfully made the font " + fontFiles[0] + " available for use in the PDF export plugin."));
        }
        catch (IOException ex) {
            LOGGER.error((Object)("Failed to make the font " + fontFiles[0] + " available for use in the PDF export plugin. Please install the font manually."), (Throwable)ex);
        }
    }

    public void setPdfExportFontManager(FontManager pdfExportFontManager) {
        this.pdfExportFontManager = pdfExportFontManager;
    }

    public void setBootstrapManager(BootstrapManager bootstrapManager) {
        this.bootstrapManager = bootstrapManager;
    }
}

