/*
 * Decompiled with CFR 0.152.
 */
package tr.com.obss.plugin.extra.flyingpdf;

import com.atlassian.core.util.ProgressMeter;
import com.atlassian.sal.api.message.I18nResolver;
import java.io.Serializable;
import tr.com.obss.plugin.extra.flyingpdf.PdfExportProgressMonitor;

public class ProgressMeterWrappingProgressMonitor
implements PdfExportProgressMonitor {
    private static final int CONTENT_TREE_CALCULATION_PERCENTAGE = 4;
    private static final int HTML_CONVERSION_PERCENTAGE = 46;
    private final I18nResolver i18NBean;
    private final ProgressMeter progressMeter;
    private int numberOfPages;
    private int convertedPageCount = 0;

    public ProgressMeterWrappingProgressMonitor(I18nResolver bean, ProgressMeter progressMeter) {
        this.i18NBean = bean;
        this.progressMeter = progressMeter;
    }

    @Override
    public void started() {
        this.progressMeter.setPercentage(0);
        this.progressMeter.setStatus(this.i18NBean.getText("tr.com.obss.plugin.extra.flyingpdf.progress.started"));
    }

    @Override
    public void beginCalculationOfContentTree() {
        this.progressMeter.setStatus(this.i18NBean.getText("com.atlassian.confluence.extra.flyingpdf.progress.calculatecontenttree"));
    }

    @Override
    public void completedCalculationOfPdfPages(int numberOfPages) {
        this.numberOfPages = numberOfPages;
        this.convertedPageCount = 0;
    }

    @Override
    public void completedCalculationOfContentTree(int numberOfPages) {
        this.numberOfPages = numberOfPages;
        this.progressMeter.setStatus(this.i18NBean.getText("com.atlassian.confluence.extra.flyingpdf.progress.contenttreecalculated"));
        this.progressMeter.setPercentage(4);
    }

    private static float getPercentage(float progress, float total) {
        return progress * 100.0f / total;
    }

    private static float scalePercentage(float originalPercentage, float scalingFactor) {
        return scalingFactor / 100.0f * originalPercentage;
    }

    @Override
    public void completedExportedHtmlConversionForPage(String pageId, String pageTitle) {
        ++this.convertedPageCount;
        float percentageComplete = ProgressMeterWrappingProgressMonitor.getPercentage(this.convertedPageCount, this.numberOfPages);
        float weightedPercentageComplete = ProgressMeterWrappingProgressMonitor.scalePercentage(percentageComplete, 46.0f) + 4.0f;
        this.progressMeter.setPercentage((int)weightedPercentageComplete);
        String message = this.i18NBean.getText("tr.com.obss.plugin.extra.flyingpdf.progress.pageConvertedToHtml", (Serializable[])new String[]{String.valueOf(this.convertedPageCount), String.valueOf(this.numberOfPages)});
        this.progressMeter.setStatus(message);
    }

    @Override
    public void beginHtmlToPdfConversion() {
        this.convertedPageCount = 0;
        this.progressMeter.setPercentage(50);
        this.progressMeter.setStatus(this.i18NBean.getText("tr.com.obss.plugin.extra.flyingpdf.progress.beginhtmltopdf"));
    }

    @Override
    public void performingHtmlToPdfConversionForPage(String pageTitle) {
        int pdfConversionPercentage;
        ++this.convertedPageCount;
        float percentageComplete = ProgressMeterWrappingProgressMonitor.getPercentage(this.convertedPageCount, this.numberOfPages);
        float weightedPercentageComplete = ProgressMeterWrappingProgressMonitor.scalePercentage(percentageComplete, pdfConversionPercentage = 50) + 4.0f + 46.0f;
        int calculatedPercentage = (int)weightedPercentageComplete;
        if (calculatedPercentage > 99) {
            calculatedPercentage = 99;
        }
        this.progressMeter.setPercentage(calculatedPercentage);
        String message = this.i18NBean.getText("tr.com.obss.plugin.extra.flyingpdf.progress.pageConvertedToPdf", (Serializable[])new String[]{String.valueOf(this.convertedPageCount), String.valueOf(this.numberOfPages)});
        this.progressMeter.setStatus(message);
    }

    @Override
    public void completed(String downloadPath) {
        this.progressMeter.setCompletedSuccessfully(true);
        this.progressMeter.setStatus(this.i18NBean.getText("tr.com.obss.plugin.extra.flyingpdf.progress.completed", (Serializable[])new String[]{downloadPath}));
        this.progressMeter.setPercentage(100);
    }

    @Override
    public void errored(String exceptionMessage) {
        this.progressMeter.setCompletedSuccessfully(false);
        this.progressMeter.setStatus(this.i18NBean.getText("tr.com.obss.plugin.extra.flyingpdf.progress.errored", (Serializable[])new String[]{exceptionMessage}));
        this.progressMeter.setPercentage(100);
    }
}

