/*
 * Decompiled with CFR 0.152.
 */
package tr.com.obss.plugin.extra.flyingpdf;

import com.atlassian.confluence.importexport.ImportExportException;
import com.atlassian.confluence.license.LicenseService;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.ContentTree;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.core.util.ProgressMeter;
import com.atlassian.user.User;
import java.io.File;
import tr.com.obss.plugin.extra.flyingpdf.InternalPdfExporterService;
import tr.com.obss.plugin.extra.flyingpdf.PdfExportProgressMonitor;
import tr.com.obss.plugin.extra.flyingpdf.PdfExporterService;
import tr.com.obss.plugin.extra.flyingpdf.analytic.PageExportMetrics;
import tr.com.obss.plugin.extra.flyingpdf.analytic.SpaceExportMetrics;
import tr.com.obss.plugin.extra.flyingpdf.html.DecorationPolicy;

public class DelegatingPdfExporterService
implements PdfExporterService {
    private LicenseService licenseService;
    private InternalPdfExporterService internalPdfExporterService;

    private static boolean sandboxExplicitlyDisabled() {
        return Boolean.getBoolean("pdf.export.sandbox.disable");
    }

    public void setLicenseService(LicenseService licenseService) {
        this.licenseService = licenseService;
    }

    public void setInternalPdfExporterService(InternalPdfExporterService internalPdfExporterService) {
        this.internalPdfExporterService = internalPdfExporterService;
    }

    @Override
    public File createPdfForSpace(User user, Space space, ContentTree contentTree, PdfExportProgressMonitor progress, String contextPath, SpaceExportMetrics spaceExportMetrics, DecorationPolicy decorations) throws ImportExportException {
        return this.getService().createPdfForSpace(user, space, contentTree, progress, contextPath, spaceExportMetrics, decorations);
    }

    @Override
    public File createPdfForPage(User user, AbstractPage page, String contextPath, PageExportMetrics pageExportMetrics) throws ImportExportException {
        return this.getService().createPdfForPage(user, page, contextPath, pageExportMetrics);
    }

    @Override
    public ContentTree getContentTree(User user, Space space) {
        return this.getService().getContentTree(user, space);
    }

    @Override
    public boolean isPermitted(User user, AbstractPage page) {
        return this.getService().isPermitted(user, page);
    }

    @Override
    public boolean isPermitted(User user, Space space) {
        return this.getService().isPermitted(user, space);
    }

    @Override
    public boolean exportableContentExists(Space space) {
        return this.getService().exportableContentExists(space);
    }

    @Override
    public PdfExportProgressMonitor createProgressMonitor(ProgressMeter progressMeter) {
        return this.getService().createProgressMonitor(progressMeter);
    }

    private PdfExporterService getService() {
        if (this.sandboxIsUsed()) {
            return null;
        }
        return this.internalPdfExporterService;
    }

    public boolean sandboxIsUsed() {
        return !DelegatingPdfExporterService.sandboxExplicitlyDisabled() && this.isDc();
    }

    private boolean isDc() {
        return false;
    }

    @Override
    public File createPdfForBaseline(String baselineName, User user, ContentTree contentTree, String contextPath, Space space, SpaceExportMetrics spaceExportMetrics, PdfExportProgressMonitor progress) throws ImportExportException {
        return this.getService().createPdfForBaseline(baselineName, user, contentTree, contextPath, space, spaceExportMetrics, progress);
    }
}

