/*
 * Decompiled with CFR 0.152.
 */
package com.nearsoft.retrospective.service;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.activeobjects.spi.DatabaseType;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.nearsoft.retrospective.exception.FourHundredException;
import com.nearsoft.retrospective.mappers.ActionItemMapper;
import com.nearsoft.retrospective.mappers.GroupElementMapper;
import com.nearsoft.retrospective.mappers.GroupedIdeaMapper;
import com.nearsoft.retrospective.mappers.ThinkElementMapper;
import com.nearsoft.retrospective.mappers.UserMapper;
import com.nearsoft.retrospective.mappers.VoteElementMapper;
import com.nearsoft.retrospective.model.ActionItem;
import com.nearsoft.retrospective.model.GroupCollection;
import com.nearsoft.retrospective.model.GroupElement;
import com.nearsoft.retrospective.model.GroupedIdea;
import com.nearsoft.retrospective.model.ThinkElement;
import com.nearsoft.retrospective.model.User;
import com.nearsoft.retrospective.model.VoteElement;
import com.nearsoft.retrospective.model.entity.ActionItemEntity;
import com.nearsoft.retrospective.model.entity.GroupElementEntity;
import com.nearsoft.retrospective.model.entity.GroupedIdeaEntity;
import com.nearsoft.retrospective.model.entity.SessionUserEntity;
import com.nearsoft.retrospective.model.entity.ThinkElementEntity;
import com.nearsoft.retrospective.model.entity.VoteEntity;
import com.nearsoft.retrospective.service.QueryHelper;
import com.nearsoft.retrospective.util.NormalizeStringUtil;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.ws.rs.core.Response;
import net.java.ao.DBParam;
import net.java.ao.RawEntity;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GroupService {
    private static final Gson GSON = new Gson();
    private final ActiveObjects activeObjects;

    @Autowired
    public GroupService(@ComponentImport ActiveObjects activeObjects) {
        this.activeObjects = activeObjects;
    }

    private DatabaseType DATABASE_TYPE() {
        return this.activeObjects.moduleMetaData().getDatabaseType();
    }

    public GroupedIdea getGroupedIdea(long uuid) {
        GroupedIdeaEntity[] entities = (GroupedIdeaEntity[])this.activeObjects.find(GroupedIdeaEntity.class, QueryHelper.ByUUID(uuid));
        if (entities.length == 0) {
            return null;
        }
        return GroupedIdeaMapper.map(entities[0]);
    }

    private GroupElement getGroupedElementById(int groupId, List<ThinkElement> ideas) {
        GroupElementEntity[] entities = (GroupElementEntity[])this.activeObjects.find(GroupElementEntity.class, QueryHelper.ById(groupId));
        if (entities == null || entities.length == 0) {
            return null;
        }
        GroupElementEntity entity = entities[0];
        GroupElement group = new GroupElement();
        group.setDescription(entity.getDescription());
        group.setGrouped(true);
        group.setIdeas(ideas);
        group.setId(entity.getID());
        group.setVotes(entity.getVotes());
        group.setVotesPerUser((HashMap)GSON.fromJson(entity.getVotesPerUser(), new TypeToken<HashMap<String, Integer>>(){}.getType()));
        group.setActionItems(Arrays.stream(entity.getActionItems()).map(ActionItemMapper::map).collect(Collectors.toList()));
        return group;
    }

    private List<GroupElement> getGroupedElements(long uuid, List<ThinkElement> ideas) {
        return (List)this.activeObjects.executeInTransaction(() -> {
            ArrayList<GroupElement> groupList = new ArrayList<GroupElement>();
            GroupElementEntity[] entities = (GroupElementEntity[])this.activeObjects.find(GroupElementEntity.class, QueryHelper.ByPageId(uuid));
            List<Integer> groupIdsBeingEdited = this.getGroupIdsBeingEdited(uuid);
            for (GroupElementEntity entity : entities) {
                if (groupIdsBeingEdited.contains(entity.getID())) continue;
                ThinkElementEntity[] thinkElements = entity.getIdeas();
                GroupElement group = new GroupElement();
                ArrayList<ThinkElement> ideasInGroup = new ArrayList<ThinkElement>();
                block1: for (ThinkElementEntity e : thinkElements) {
                    for (int i = 0; i < ideas.size(); ++i) {
                        if (e.getID() != ((ThinkElement)ideas.get(i)).getId()) continue;
                        ThinkElement idea = (ThinkElement)ideas.remove(i);
                        ideasInGroup.add(idea);
                        continue block1;
                    }
                }
                VoteEntity[] votes = entity.getVoteList();
                HashMap<String, Integer> votesPerUser = new HashMap<String, Integer>();
                for (VoteEntity v : votes) {
                    VoteElement element = VoteElementMapper.map(v);
                    group.getVoteList().add(element);
                    votesPerUser.put(v.getUserKey(), v.getVotes());
                }
                if (ideasInGroup.size() <= 0) continue;
                group.setDescription(entity.getDescription());
                group.setGrouped(true);
                group.setIdeas(ideasInGroup);
                group.setId(entity.getID());
                group.setVotes(entity.getVotes());
                group.setVotesPerUser(votesPerUser);
                group.setActionItems(Arrays.stream(entity.getActionItems()).map(ActionItemMapper::map).collect(Collectors.toList()));
                groupList.add(group);
            }
            return groupList;
        });
    }

    private List<GroupElement> getGroupedIdeas(long uuid, List<ThinkElement> ideas) {
        GroupedIdeaEntity[] entities;
        ArrayList<GroupElement> groupList = new ArrayList<GroupElement>();
        for (GroupedIdeaEntity entity : entities = (GroupedIdeaEntity[])this.activeObjects.executeInTransaction(() -> (GroupedIdeaEntity[])this.activeObjects.find(GroupedIdeaEntity.class, QueryHelper.ByUUID(uuid)))) {
            String thinkElementIds = entity.getThinkElementIds();
            if (thinkElementIds == null || thinkElementIds.trim().isEmpty()) continue;
            String[] thinkElementIdsArray = entity.getThinkElementIds().split(",");
            GroupElement group = new GroupElement();
            ArrayList<ThinkElement> ideasInGroup = new ArrayList<ThinkElement>();
            block1: for (String id : thinkElementIdsArray) {
                if (id.isEmpty()) continue;
                int ideaId = Integer.parseInt(id);
                for (int i = 0; i < ideas.size(); ++i) {
                    if (ideaId != ideas.get(i).getId()) continue;
                    ThinkElement idea = ideas.remove(i);
                    ideasInGroup.add(idea);
                    continue block1;
                }
            }
            if (ideasInGroup.size() <= 0) continue;
            group.setGrouped(true);
            group.setIdeas(ideasInGroup);
            groupList.add(group);
        }
        return groupList;
    }

    public GroupCollection getGroupsByPageId(long pageId, List<ThinkElement> ideas) {
        int size = ideas.size();
        ArrayList<GroupElement> groupList = new ArrayList<GroupElement>();
        GroupElement noGroupedIdeas = new GroupElement();
        groupList.addAll(this.getGroupedIdeas(pageId, ideas));
        groupList.addAll(this.getGroupedElements(pageId, ideas));
        ArrayList<ThinkElement> ideasInGroup = new ArrayList<ThinkElement>();
        for (ThinkElement idea : ideas) {
            ideasInGroup.add(idea);
            noGroupedIdeas.setIdeas(ideasInGroup);
        }
        groupList.add(0, noGroupedIdeas);
        return new GroupCollection(groupList, size);
    }

    private List<Integer> getGroupIdsBeingEdited(long uuid) {
        GroupedIdeaEntity[] entities;
        ArrayList<Integer> groupIds = new ArrayList<Integer>();
        for (GroupedIdeaEntity entity : entities = (GroupedIdeaEntity[])this.activeObjects.find(GroupedIdeaEntity.class, QueryHelper.ByUUID(uuid))) {
            if (entity.getGroupId() == -1) continue;
            groupIds.add(entity.getGroupId());
        }
        return groupIds;
    }

    GroupElementEntity[] getGroupElementsByPageId(int pageId) {
        return (GroupElementEntity[])this.activeObjects.find(GroupElementEntity.class, QueryHelper.ByPageId(pageId));
    }

    void deleteGroupElementByPageId(int pageId) {
        GroupElementEntity[] groupElementEntities = this.getGroupElementsByPageId(pageId);
        Arrays.stream(groupElementEntities).forEach(xva$0 -> this.activeObjects.delete(new RawEntity[]{xva$0}));
    }

    void deleteActionItemByPageId(int pageId) {
        ActionItemEntity[] actionItemEntities = (ActionItemEntity[])this.activeObjects.find(ActionItemEntity.class, QueryHelper.ByPageId(pageId));
        Arrays.stream(actionItemEntities).forEach(xva$0 -> this.activeObjects.delete(new RawEntity[]{xva$0}));
    }

    public GroupElement saveGroupedIdeaAsGroup(long uuid, ThinkElement[] list) throws FourHundredException {
        GroupElementEntity[] oldGroups;
        GroupedIdea groupedIdea = this.getGroupedIdea(uuid);
        if (groupedIdea == null) {
            return null;
        }
        String groupName = groupedIdea.getName();
        if (groupName != null && !groupName.trim().isEmpty() && !"Untitled group".equals(groupName)) {
            Integer excludeGroupId;
            Integer n = excludeGroupId = groupedIdea.getGroupId() != -1 ? Integer.valueOf(groupedIdea.getGroupId()) : null;
            if (this.isGroupNameDuplicate(uuid, groupName, excludeGroupId)) {
                throw new FourHundredException(Response.Status.CONFLICT);
            }
        }
        GroupElement groupElement = GroupedIdeaMapper.map(groupedIdea, list);
        GroupElementEntity newGroup = GroupElementMapper.map(uuid, groupElement, this.activeObjects);
        if (groupedIdea.getGroupId() != -1 && (oldGroups = (GroupElementEntity[])this.activeObjects.find(GroupElementEntity.class, QueryHelper.ById(groupedIdea.getGroupId()))) != null && oldGroups.length > 0) {
            ThinkElementEntity[] oldIdeas;
            for (ThinkElementEntity oldIdea : oldIdeas = oldGroups[0].getIdeas()) {
                oldIdea.setGroupElementEntity(null);
                oldIdea.save();
            }
        }
        for (ThinkElement thinkElement : groupElement.getIdeas()) {
            ThinkElementEntity[] tEntity = (ThinkElementEntity[])this.activeObjects.find(ThinkElementEntity.class, QueryHelper.ById(thinkElement.getId()));
            tEntity[0].setGroupElementEntity(newGroup);
            tEntity[0].save();
        }
        GroupedIdeaEntity[] entities = (GroupedIdeaEntity[])this.activeObjects.find(GroupedIdeaEntity.class, QueryHelper.ByUUID(uuid));
        if (entities != null) {
            this.activeObjects.delete((RawEntity[])entities);
        }
        if (groupedIdea.getGroupId() != -1) {
            List<ActionItem> actionItems;
            GroupElement groupToDelete = this.getGroupedElementById(groupedIdea.getGroupId(), groupElement.getIdeas());
            if (groupToDelete != null && (actionItems = groupToDelete.getActionItems()) != null) {
                for (ActionItem actionItem : actionItems) {
                    ActionItemEntity actionItemEntity = ActionItemMapper.map(actionItem, this.activeObjects, newGroup, uuid);
                    actionItemEntity.save();
                }
            }
            this.deleteGroupElementById(groupedIdea.getGroupId());
        }
        return groupElement;
    }

    private void deleteGroupElementById(int groupId) {
        GroupElementEntity[] entities = (GroupElementEntity[])this.activeObjects.find(GroupElementEntity.class, QueryHelper.ById(groupId));
        if (entities != null) {
            for (GroupElementEntity entity : entities) {
                this.activeObjects.delete((RawEntity[])entity.getActionItems());
            }
            this.activeObjects.delete((RawEntity[])entities);
        }
    }

    public void createGroupedIdea(long uuid, ThinkElement thinkElement, String name, int groupId) {
        GroupedIdea groupedIdea = new GroupedIdea();
        groupedIdea.setUuid("" + uuid);
        groupedIdea.setNumericUUID(uuid);
        groupedIdea.setColumnId(thinkElement.getColumnId());
        groupedIdea.setName(name);
        groupedIdea.setThinkElementIds(new String[]{"" + thinkElement.getId()});
        groupedIdea.setGroupId(groupId);
        GroupedIdeaEntity[] entities = (GroupedIdeaEntity[])this.activeObjects.find(GroupedIdeaEntity.class, QueryHelper.ByUUID(uuid));
        if (entities != null) {
            this.activeObjects.delete((RawEntity[])entities);
        }
        GroupedIdeaEntity entity = GroupedIdeaMapper.map(groupedIdea, this.activeObjects);
    }

    public void removeIdeaFromGroupedIdea(long uuid, int ideaId) throws FourHundredException {
        GroupedIdeaEntity[] entities = (GroupedIdeaEntity[])this.activeObjects.find(GroupedIdeaEntity.class, QueryHelper.ByUUID(uuid));
        if (entities == null || entities.length == 0) {
            return;
        }
        GroupedIdeaEntity currentGroupedIdea = entities[0];
        boolean executed = (Boolean)this.activeObjects.executeInTransaction(() -> {
            this.activeObjects.delete((RawEntity[])entities);
            String thinkElementIds = currentGroupedIdea.getThinkElementIds();
            if (thinkElementIds != null && !thinkElementIds.trim().isEmpty()) {
                String[] ids = thinkElementIds.split(",");
                ArrayList<String> newIds = new ArrayList<String>();
                for (String id : ids) {
                    if (Integer.parseInt(id) == ideaId) continue;
                    newIds.add(id);
                }
                if (!newIds.isEmpty()) {
                    StringBuilder commaSeparated = new StringBuilder("");
                    for (String id : newIds) {
                        commaSeparated.append(id).append(",");
                    }
                    commaSeparated.deleteCharAt(commaSeparated.length() - 1);
                    GroupedIdeaEntity newGrouped = (GroupedIdeaEntity)this.activeObjects.create(GroupedIdeaEntity.class, new DBParam[0]);
                    newGrouped.setThinkElementIds(commaSeparated.toString());
                    newGrouped.setColumnId(currentGroupedIdea.getColumnId());
                    newGrouped.setName(currentGroupedIdea.getName());
                    newGrouped.setUuid(currentGroupedIdea.getUuid());
                    newGrouped.setNumericUUID(currentGroupedIdea.getNumericUUID());
                    newGrouped.setGroupId(currentGroupedIdea.getGroupId());
                    newGrouped.save();
                } else if (currentGroupedIdea.getGroupId() != -1) {
                    this.deleteGroupElementById(currentGroupedIdea.getGroupId());
                }
            }
            return true;
        });
        if (!executed) {
            throw new FourHundredException(Response.Status.BAD_REQUEST);
        }
    }

    public void addIdeaToGroupedIdea(long uuid, ThinkElement thinkElement) {
        GroupedIdea groupedIdea = this.getGroupedIdea(uuid);
        if (groupedIdea == null) {
            return;
        }
        String[] ids = groupedIdea.getThinkElementIds();
        ArrayList<CallSite> newIds = new ArrayList<CallSite>();
        Collections.addAll(newIds, ids);
        if (!newIds.contains("" + thinkElement.getId())) {
            newIds.add((CallSite)((Object)("" + thinkElement.getId())));
        }
        String[] newIdsArray = newIds.toArray(new String[newIds.size()]);
        groupedIdea.setThinkElementIds(newIdsArray);
        GroupedIdeaEntity[] entities = (GroupedIdeaEntity[])this.activeObjects.find(GroupedIdeaEntity.class, QueryHelper.ByUUID(uuid));
        if (entities != null) {
            this.activeObjects.delete((RawEntity[])entities);
        }
        GroupedIdeaMapper.map(groupedIdea, this.activeObjects);
    }

    public void editGroup(long uuid, int groupId) {
        GroupElementEntity[] groups = (GroupElementEntity[])this.activeObjects.find(GroupElementEntity.class, QueryHelper.ById(groupId));
        if (groups != null && groups.length > 0) {
            GroupElementEntity groupElementEntity = groups[0];
            ThinkElementEntity[] ideas = groups[0].getIdeas();
            for (int i = 0; i < ideas.length; ++i) {
                if (i == 0) {
                    this.createGroupedIdea(uuid, ThinkElementMapper.map(ideas[i]), StringUtils.isEmpty((CharSequence)groupElementEntity.getDescription()) ? "Untitled group" : groupElementEntity.getDescription(), groupId);
                    continue;
                }
                this.addIdeaToGroupedIdea(uuid, ThinkElementMapper.map(ideas[i]));
            }
        }
    }

    public void breakGroup(long uuid) {
        GroupedIdeaEntity[] entities = (GroupedIdeaEntity[])this.activeObjects.find(GroupedIdeaEntity.class, QueryHelper.ByUUID(uuid));
        if (entities != null) {
            for (GroupedIdeaEntity entity : entities) {
                if (entity.getGroupId() == -1) continue;
                this.deleteGroupElementById(entity.getGroupId());
            }
            this.activeObjects.delete((RawEntity[])entities);
        }
    }

    public boolean isGroupNameDuplicate(long uuid, String name, Integer excludeGroupId) {
        if (name == null || name.trim().isEmpty()) {
            return false;
        }
        GroupElementEntity[] groups = (GroupElementEntity[])this.activeObjects.find(GroupElementEntity.class, QueryHelper.ByPageId(uuid));
        String normalizedNewName = NormalizeStringUtil.normalizeString(name);
        for (GroupElementEntity entity : groups) {
            if (excludeGroupId != null && entity.getID() == excludeGroupId.intValue()) continue;
            String normalizedEntityName = NormalizeStringUtil.normalizeString(entity.getDescription());
            if (entity.getDescription() == null || !normalizedNewName.equalsIgnoreCase(normalizedEntityName)) continue;
            return true;
        }
        return false;
    }

    public boolean updateGroupedIdeaName(long uuid, String groupName) throws FourHundredException {
        GroupedIdea idea;
        GroupedIdea groupedIdea = this.getGroupedIdea(uuid);
        if (groupedIdea == null) {
            return false;
        }
        if (groupName != null && groupName.trim().isEmpty() && !"Untitled group".equals(groupName)) {
            Integer excludeGroupId;
            Integer n = excludeGroupId = groupedIdea.getGroupId() != -1 ? Integer.valueOf(groupedIdea.getGroupId()) : null;
            if (this.isGroupNameDuplicate(uuid, groupName, excludeGroupId)) {
                throw new FourHundredException(Response.Status.CONFLICT);
            }
        }
        if ((idea = this.getGroupedIdea(uuid)) != null) {
            idea.setName(groupName);
            GroupedIdeaEntity[] entities = (GroupedIdeaEntity[])this.activeObjects.find(GroupedIdeaEntity.class, QueryHelper.ByUUID(uuid));
            if (entities != null) {
                this.activeObjects.delete((RawEntity[])entities);
            }
            GroupedIdeaMapper.map(idea, this.activeObjects);
        }
        return true;
    }

    public void processNonGroupedIdeas(long uuid, List<ThinkElement> ideas) {
        this.deleteUnsavedDraftGroups(uuid);
        GroupCollection groups = this.getGroupsByPageId(uuid, ideas);
        List<GroupElement> groupList = groups.getGroupList();
        if (groupList.size() > 0) {
            GroupElement nonGroupedIdeas = groupList.get(0);
            List<ThinkElement> nonGrouped = nonGroupedIdeas.getIdeas();
            if (nonGrouped == null) {
                return;
            }
            for (ThinkElement idea : nonGrouped) {
                GroupedIdea groupedIdea = new GroupedIdea();
                groupedIdea.setUuid("" + uuid);
                groupedIdea.setNumericUUID(uuid);
                groupedIdea.setColumnId(idea.getColumnId());
                groupedIdea.setName("");
                groupedIdea.setThinkElementIds(new String[]{"" + idea.getId()});
                GroupElement groupElement = GroupedIdeaMapper.map(groupedIdea, ideas.toArray(new ThinkElement[ideas.size()]));
                GroupElementEntity entity = GroupElementMapper.map(uuid, groupElement, this.activeObjects);
                ThinkElementEntity[] tEntity = (ThinkElementEntity[])this.activeObjects.find(ThinkElementEntity.class, QueryHelper.ById(idea.getId()));
                tEntity[0].setGroupElementEntity(entity);
                tEntity[0].save();
            }
        }
    }

    private void deleteUnsavedDraftGroups(long uuid) {
        GroupedIdeaEntity[] draftGroups = (GroupedIdeaEntity[])this.activeObjects.find(GroupedIdeaEntity.class, QueryHelper.ByUUID(uuid));
        if (draftGroups != null && draftGroups.length > 0) {
            this.activeObjects.delete((RawEntity[])draftGroups);
        }
    }

    public void addActionItem(long uuid, int groupId, ActionItem actionItem) {
        actionItem.setAssigneeUser(null);
        actionItem.setComplete(false);
        GroupElementEntity[] groups = (GroupElementEntity[])this.activeObjects.find(GroupElementEntity.class, QueryHelper.ById(groupId));
        if (groups == null || groups.length == 0) {
            return;
        }
        GroupElementEntity group = groups[0];
        ActionItemEntity entity = ActionItemMapper.map(actionItem, this.activeObjects, group, uuid);
        entity.save();
    }

    public void removeActionItem(int actionItemId) {
        ActionItemEntity[] entities = (ActionItemEntity[])this.activeObjects.find(ActionItemEntity.class, QueryHelper.ById(actionItemId));
        this.activeObjects.delete((RawEntity[])entities);
    }

    public void setActionItemAssignee(int uuid, int actionItemId, User user) throws FourHundredException {
        boolean executed = (Boolean)this.activeObjects.executeInTransaction(() -> {
            ActionItemEntity[] entities = (ActionItemEntity[])this.activeObjects.find(ActionItemEntity.class, QueryHelper.ById(actionItemId));
            if (entities == null || entities.length == 0) {
                return false;
            }
            entities[0].setAssigneeUser(UserMapper.maptoUserEntity(this.activeObjects, user));
            entities[0].save();
            SessionUserEntity sessionUserEntity = Arrays.stream((SessionUserEntity[])this.activeObjects.find(SessionUserEntity.class, QueryHelper.ByPageIdAndUserKey(uuid, user.getUserKey(), this.DATABASE_TYPE()))).findFirst().orElse(null);
            if (sessionUserEntity != null) {
                sessionUserEntity.setIsParticipant(true);
                sessionUserEntity.save();
            } else {
                sessionUserEntity = (SessionUserEntity)this.activeObjects.create(SessionUserEntity.class, new DBParam[0]);
                sessionUserEntity.setIsParticipant(true);
                sessionUserEntity.setIsConnected(false);
                sessionUserEntity.setIsReady(false);
                sessionUserEntity.setFullName(user.getFullName());
                sessionUserEntity.setImageUri(user.getImageURI());
                sessionUserEntity.setName(user.getName());
                sessionUserEntity.setPageId(user.getPageId());
                sessionUserEntity.setNumericPageId(user.getNumericPageId());
                sessionUserEntity.setUserKey(user.getUserKey());
                sessionUserEntity.save();
            }
            return true;
        });
        if (!executed) {
            throw new FourHundredException(Response.Status.NOT_FOUND);
        }
    }

    public void removeActionItemAssignee(int actionItemId) {
        ActionItemEntity[] entities = (ActionItemEntity[])this.activeObjects.find(ActionItemEntity.class, QueryHelper.ById(actionItemId));
        if (entities == null || entities.length == 0) {
            return;
        }
        entities[0].setAssigneeUser(null);
        entities[0].save();
    }

    public void toggleCompleteActionItem(int actionItemId) {
        ActionItemEntity[] entities = (ActionItemEntity[])this.activeObjects.find(ActionItemEntity.class, QueryHelper.ById(actionItemId));
        if (entities == null || entities.length == 0) {
            return;
        }
        entities[0].setComplete(!entities[0].getComplete());
        entities[0].save();
    }

    public ActionItem[] getActionItemsForRetro(long retroId) {
        ActionItemEntity[] entities = (ActionItemEntity[])this.activeObjects.find(ActionItemEntity.class, QueryHelper.ByPageId(retroId));
        if (entities == null) {
            return new ActionItem[0];
        }
        return (ActionItem[])Arrays.asList(entities).stream().map(ai -> ActionItemMapper.map(ai)).toArray(ActionItem[]::new);
    }
}

