/*
 * Decompiled with CFR 0.152.
 */
package com.nearsoft.retrospective.rest;

import com.google.gson.Gson;
import com.nearsoft.retrospective.exception.FourHundredException;
import com.nearsoft.retrospective.model.ActionItem;
import com.nearsoft.retrospective.model.GroupCollection;
import com.nearsoft.retrospective.model.GroupElement;
import com.nearsoft.retrospective.model.GroupIdeaRequest;
import com.nearsoft.retrospective.model.GroupRequest;
import com.nearsoft.retrospective.model.GroupedIdea;
import com.nearsoft.retrospective.model.ThinkElement;
import com.nearsoft.retrospective.model.User;
import com.nearsoft.retrospective.model.VoteRequest;
import com.nearsoft.retrospective.securityControl.PermissionValidator;
import com.nearsoft.retrospective.securityControl.ResourceHierarchyValidator;
import com.nearsoft.retrospective.securityControl.UserValidator;
import com.nearsoft.retrospective.service.GroupService;
import com.nearsoft.retrospective.service.SessionDataService;
import com.nearsoft.retrospective.service.ThinkService;
import com.nearsoft.retrospective.service.VoteService;
import com.nearsoft.retrospective.service.response.wrappers.VoteResponse;
import com.nearsoft.retrospective.util.NormalizeStringUtil;
import com.nearsoft.retrospective.util.SanitizationUtil;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Path(value="/group")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Component
public class GroupResource {
    private static final Gson GSON = new Gson();
    private final ThinkService thinkService;
    private final GroupService groupService;
    private final VoteService voteService;
    private final SessionDataService sessionDataService;
    private final PermissionValidator permissionValidator;
    private final ResourceHierarchyValidator resourceHierarchyValidator;
    private final UserValidator userValidator;

    @Autowired
    public GroupResource(ThinkService thinkService, GroupService groupService, VoteService voteService, SessionDataService sessionDataService, PermissionValidator permissionValidator, ResourceHierarchyValidator resourceHierarchyValidator, UserValidator userValidator) {
        this.thinkService = thinkService;
        this.groupService = groupService;
        this.voteService = voteService;
        this.sessionDataService = sessionDataService;
        this.permissionValidator = permissionValidator;
        this.resourceHierarchyValidator = resourceHierarchyValidator;
        this.userValidator = userValidator;
    }

    @GET
    public Response getCompleteIdeasCollection(@QueryParam(value="uuid") int uuid) throws FourHundredException {
        this.permissionValidator.validatePagePermissionByRetroId(uuid);
        this.validateAndGetUser(uuid);
        GroupCollection groupCollection = this.groupService.getGroupsByPageId(uuid, this.thinkService.getThinkElementsList(uuid));
        return Response.ok((Object)GSON.toJson(groupCollection)).build();
    }

    @POST
    @Consumes(value={"application/json"})
    public Response saveGroup(@QueryParam(value="uuid") int uuid) throws FourHundredException {
        this.permissionValidator.validatePagePermissionByRetroId(uuid);
        User user = this.validateAndGetUser(uuid);
        List<ThinkElement> list = this.thinkService.getThinkElementsList(uuid);
        GroupElement group = this.groupService.saveGroupedIdeaAsGroup(uuid, list.toArray(new ThinkElement[list.size()]));
        if (group == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        this.sessionDataService.setUserAsParticipant(uuid, user.getUserKey());
        return Response.ok((Object)GSON.toJson(group)).build();
    }

    @PUT
    @Path(value="/{groupId}")
    @Consumes(value={"application/json"})
    public Response editGroup(@QueryParam(value="uuid") int uuid, @PathParam(value="groupId") int groupId) throws FourHundredException {
        this.permissionValidator.validatePagePermissionByRetroId(uuid);
        this.resourceHierarchyValidator.validateGroupBelongsRetro(groupId, uuid);
        User user = this.validateAndGetUser(uuid);
        this.groupService.editGroup(uuid, groupId);
        this.sessionDataService.setUserAsParticipant(uuid, user.getUserKey());
        return Response.ok().build();
    }

    @DELETE
    @Consumes(value={"application/json"})
    public Response breakGroup(@QueryParam(value="uuid") int uuid) throws FourHundredException {
        this.permissionValidator.validatePagePermissionByRetroId(uuid);
        User user = this.validateAndGetUser(uuid);
        this.groupService.breakGroup(uuid);
        this.sessionDataService.setUserAsParticipant(uuid, user.getUserKey());
        return Response.ok().build();
    }

    @PUT
    @Path(value="/idea")
    @Consumes(value={"application/json"})
    public Response putIdeaInGroup(@QueryParam(value="uuid") int uuid, GroupIdeaRequest request) throws FourHundredException {
        this.permissionValidator.validatePagePermissionByRetroId(uuid);
        this.resourceHierarchyValidator.validateIdeaBelongsRetros(request.getThinkElement().getId(), uuid);
        User user = this.validateAndGetUser(uuid);
        this.groupService.addIdeaToGroupedIdea(uuid, request.getThinkElement());
        this.sessionDataService.setUserAsParticipant(uuid, user.getUserKey());
        return Response.ok().build();
    }

    @PUT
    @Path(value="/idea/name")
    @Consumes(value={"application/json"})
    public Response editGroupIdeaName(@QueryParam(value="uuid") int uuid, GroupRequest request) throws FourHundredException {
        this.permissionValidator.validatePagePermissionByRetroId(uuid);
        User user = this.validateAndGetUser(uuid);
        String name = NormalizeStringUtil.normalizeString(SanitizationUtil.escapeHtml(request.getName()));
        if (name != null && name.length() > 255) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        if (!this.groupService.updateGroupedIdeaName(uuid, name)) {
            return Response.status((Response.Status)Response.Status.CONFLICT).build();
        }
        this.sessionDataService.setUserAsParticipant(uuid, user.getUserKey());
        return Response.ok().build();
    }

    @DELETE
    @Path(value="/idea/{ideaId}")
    @Consumes(value={"application/json"})
    public Response deleteIdeaInGroup(@QueryParam(value="uuid") int uuid, @PathParam(value="ideaId") int ideaId) throws FourHundredException {
        this.permissionValidator.validatePagePermissionByRetroId(uuid);
        User user = this.validateAndGetUser(uuid);
        this.groupService.removeIdeaFromGroupedIdea(uuid, ideaId);
        this.sessionDataService.setUserAsParticipant(uuid, user.getUserKey());
        return Response.ok().build();
    }

    @POST
    @Path(value="/idea")
    @Consumes(value={"application/json"})
    public Response postIdeaInGroup(@QueryParam(value="uuid") int uuid, GroupIdeaRequest request) throws FourHundredException {
        this.permissionValidator.validatePagePermissionByRetroId(uuid);
        this.resourceHierarchyValidator.validateIdeaBelongsRetros(request.getThinkElement().getId(), uuid);
        User user = this.validateAndGetUser(uuid);
        this.groupService.createGroupedIdea(uuid, request.getThinkElement(), "Untitled group", -1);
        this.sessionDataService.setUserAsParticipant(uuid, user.getUserKey());
        return Response.ok().build();
    }

    @POST
    @Path(value="/vote")
    @Consumes(value={"application/json"})
    public Response postVote(@DefaultValue(value="true") @QueryParam(value="increased") boolean increased, @QueryParam(value="uuid") int uuid, VoteRequest request) throws Exception {
        this.permissionValidator.validatePagePermissionByRetroId(uuid);
        this.resourceHierarchyValidator.validateGroupBelongsRetro(request.getGroup().getId(), uuid);
        User user = this.validateAndGetUser(uuid);
        this.sessionDataService.setUserAsParticipant(uuid, user.getUserKey());
        VoteResponse voteResponse = this.voteService.vote(uuid, request, increased, user.getUserKey());
        return Response.ok((Object)GSON.toJson(voteResponse)).build();
    }

    @GET
    @Path(value="/current")
    public Response getGroupedIdea(@QueryParam(value="uuid") int uuid) throws FourHundredException {
        this.permissionValidator.validatePagePermissionByRetroId(uuid);
        this.validateAndGetUser(uuid);
        GroupedIdea groupedIdea = this.groupService.getGroupedIdea(uuid);
        if (groupedIdea == null) {
            return Response.ok().build();
        }
        return Response.ok((Object)GSON.toJson(groupedIdea)).build();
    }

    @GET
    @Path(value="/validate-name")
    public Response validateGroupName(@QueryParam(value="uuid") int uuid, @QueryParam(value="name") String name, @QueryParam(value="excludeGroupId") Integer excludeGroupId) throws FourHundredException {
        this.permissionValidator.validatePagePermissionByRetroId(uuid);
        this.validateAndGetUser(uuid);
        if (name != null && name.length() > 255) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        boolean isDuplicate = this.groupService.isGroupNameDuplicate(uuid, name, excludeGroupId);
        if (isDuplicate) {
            return Response.status((Response.Status)Response.Status.CONFLICT).build();
        }
        return Response.ok().build();
    }

    @POST
    @Path(value="/{groupId}/actionitems")
    @Consumes(value={"application/json"})
    public Response addActionItem(@DefaultValue(value="") @QueryParam(value="userKey") String userKey, @QueryParam(value="uuid") int uuid, @PathParam(value="groupId") int groupId, ActionItem actionItem) throws FourHundredException {
        this.permissionValidator.validatePagePermissionByRetroId(uuid);
        this.resourceHierarchyValidator.validateGroupBelongsRetro(groupId, uuid);
        if (userKey.isEmpty()) {
            throw new FourHundredException(Response.Status.BAD_REQUEST);
        }
        actionItem.setDescription(SanitizationUtil.escapeHtml(actionItem.getDescription()));
        this.groupService.addActionItem(uuid, groupId, actionItem);
        this.sessionDataService.setUserAsParticipant(uuid, userKey);
        return Response.ok().build();
    }

    @DELETE
    @Path(value="/{groupId}/actionitems/{actionItemId}")
    @Consumes(value={"application/json"})
    public Response deleteActionItem(@DefaultValue(value="") @QueryParam(value="userKey") String userKey, @QueryParam(value="uuid") int uuid, @PathParam(value="groupId") int groupId, @PathParam(value="actionItemId") int actionItemId) throws FourHundredException {
        this.permissionValidator.validatePagePermissionByRetroId(uuid);
        this.resourceHierarchyValidator.validateGroupBelongsRetro(groupId, uuid);
        if (userKey.isEmpty()) {
            throw new FourHundredException(Response.Status.BAD_REQUEST);
        }
        this.groupService.removeActionItem(actionItemId);
        this.sessionDataService.setUserAsParticipant(uuid, userKey);
        return Response.ok().build();
    }

    @PUT
    @Path(value="/{groupId}/actionitems/{actionItemId}/assignee")
    @Consumes(value={"application/json"})
    public Response setAssignee(@QueryParam(value="uuid") int uuid, @PathParam(value="groupId") int groupId, @PathParam(value="actionItemId") int actionItemId, User user) throws FourHundredException {
        this.permissionValidator.validatePagePermissionByRetroId(uuid);
        this.resourceHierarchyValidator.validateGroupBelongsRetro(groupId, uuid);
        this.resourceHierarchyValidator.validateActionItemBelongsGroup(actionItemId, groupId);
        this.userValidator.validateUserKey(user.getUserKey());
        user.setPageId(String.valueOf(uuid));
        user.setNumericPageId(uuid);
        user.setFullName(SanitizationUtil.escapeHtml(user.getFullName()));
        user.setName(SanitizationUtil.escapeHtml(user.getName()));
        user.setImageURI(SanitizationUtil.escapeHtml(user.getImageURI()));
        this.groupService.setActionItemAssignee(uuid, actionItemId, user);
        return Response.ok().build();
    }

    @DELETE
    @Path(value="/{groupId}/actionitems/{actionItemId}/assignee")
    @Consumes(value={"application/json"})
    public Response clearAssignee(@QueryParam(value="uuid") int uuid, @PathParam(value="groupId") int groupId, @PathParam(value="actionItemId") int actionItemId) throws FourHundredException {
        this.permissionValidator.validatePagePermissionByRetroId(uuid);
        this.resourceHierarchyValidator.validateGroupBelongsRetro(groupId, uuid);
        this.resourceHierarchyValidator.validateActionItemBelongsGroup(actionItemId, groupId);
        this.groupService.removeActionItemAssignee(actionItemId);
        return Response.ok().build();
    }

    @PUT
    @Path(value="/{groupId}/actionitems/{actionItemId}/togglecomplete")
    @Consumes(value={"application/json"})
    public Response toggleCompleteActionItem(@DefaultValue(value="") @QueryParam(value="userKey") String userKey, @QueryParam(value="uuid") int uuid, @PathParam(value="groupId") int groupId, @PathParam(value="actionItemId") int actionItemId) throws FourHundredException {
        this.permissionValidator.validatePagePermissionByRetroId(uuid);
        this.resourceHierarchyValidator.validateGroupBelongsRetro(groupId, uuid);
        this.resourceHierarchyValidator.validateActionItemBelongsGroup(actionItemId, groupId);
        if (userKey.isEmpty()) {
            throw new FourHundredException(Response.Status.BAD_REQUEST);
        }
        this.groupService.toggleCompleteActionItem(actionItemId);
        this.sessionDataService.setUserAsParticipant(uuid, userKey);
        return Response.ok().build();
    }

    private User validateAndGetUser(long uuid) throws FourHundredException {
        User user = this.sessionDataService.getUserByPageIdOrCreate(uuid);
        if (user == null) {
            throw new FourHundredException(Response.Status.UNAUTHORIZED);
        }
        return user;
    }
}

