/**
 * Normalizes a string by trimming leading/trailing spaces and replacing multiple spaces with a single space.
 * This matches the behavior of NormalizeStringUtil.normalizeString() in the Java backend.
 * 
 * @param {string | null} input - The input string to normalize.
 * @returns {string | null} - The normalized string, or null if input is null.
 */
export function normalizeString(input: string | null): string | null {
    if (input == null) {
        return null;
    }
    // Replace multiple spaces with a single space and trim leading/trailing spaces
    return input.trim().replace(/\s+/g, " ");
}