/*
 * Decompiled with CFR 0.152.
 */
package com.nearsoft.retrospective.securityControl;

import com.nearsoft.retrospective.exception.FourHundredException;
import com.nearsoft.retrospective.model.User;
import com.nearsoft.retrospective.service.RetrospectiveUserService;
import java.util.Objects;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class UserValidator {
    private final Logger LOG = LoggerFactory.getLogger(UserValidator.class);
    private final RetrospectiveUserService _retrospectiveUserService;

    public UserValidator(RetrospectiveUserService retrospectiveUserService) {
        this._retrospectiveUserService = retrospectiveUserService;
    }

    public void validateUserKey(String userKey) throws FourHundredException {
        if (userKey == null || userKey.trim().isEmpty()) {
            this.LOG.error("[agile-retrospectives-for-confluence] Empty or null userKey provided.");
            throw new FourHundredException(Response.Status.BAD_REQUEST);
        }
        User validUser = this._retrospectiveUserService.getValidUserFromUserKey(userKey);
        if (Objects.isNull(validUser)) {
            this.LOG.error("[agile-retrospectives-for-confluence] No existing Confluence user for key: " + userKey);
            throw new FourHundredException(Response.Status.NOT_FOUND);
        }
    }
}

