/*
 * Decompiled with CFR 0.152.
 */
package com.nearsoft.retrospective.listener;

import com.atlassian.migration.app.AccessScope;
import com.atlassian.migration.app.gateway.AppCloudMigrationGateway;
import com.atlassian.migration.app.gateway.MigrationDetailsV1;
import com.atlassian.migration.app.listener.DiscoverableListener;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.nearsoft.retrospective.migration_to_cloud.ServerMigrationStatus;
import com.nearsoft.retrospective.migration_to_cloud.dto.MigrationDataDTO;
import com.nearsoft.retrospective.migration_to_cloud.dto.RetrospectiveDTO;
import com.nearsoft.retrospective.migration_to_cloud.service.RetrosMapDataService;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ExportAsService(value={DiscoverableListener.class})
@Named
public class MigrationListener
implements DiscoverableListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(MigrationListener.class);
    private final RetrosMapDataService retrosMapDataService;

    @Inject
    public MigrationListener(RetrosMapDataService retrosMapDataService) {
        this.retrosMapDataService = retrosMapDataService;
    }

    @Override
    public String getCloudAppKey() {
        return "retrospectives4confluence";
    }

    @Override
    public Set<AccessScope> getDataAccessScopes() {
        return Stream.of(AccessScope.APP_DATA_OTHER, AccessScope.PRODUCT_DATA_OTHER, AccessScope.MIGRATION_TRACING_IDENTITY, AccessScope.MIGRATION_TRACING_PRODUCT).collect(Collectors.toCollection(HashSet::new));
    }

    @Override
    public void onStartAppMigration(AppCloudMigrationGateway gateway, String transferId, MigrationDetailsV1 migrationDetails) {
        LOGGER.warn(">>> onStartAppMigration");
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.serializeNulls();
        Gson gson = gsonBuilder.create();
        MigrationDataDTO migrationDataDTO = new MigrationDataDTO();
        List<RetrospectiveDTO> retrospectiveDTOS = new ArrayList<RetrospectiveDTO>();
        migrationDataDTO.setRetrospectives(retrospectiveDTOS);
        try {
            retrospectiveDTOS = this.retrosMapDataService.matchRetrosForCloud(transferId, gateway, migrationDetails.getConfluenceClientKey());
            LOGGER.info("{} retrospective sessions were found for migration", (Object)retrospectiveDTOS.size());
            migrationDataDTO.setRetrospectives(retrospectiveDTOS);
            migrationDataDTO.setServerMigrationStatus(ServerMigrationStatus.SUCCESS);
        }
        catch (Exception e) {
            migrationDataDTO.setServerMigrationStatus(ServerMigrationStatus.FAILED);
            LOGGER.error("Error while retrieving retrospectives for migration", (Throwable)e);
        }
        try {
            OutputStream firstDataStream = gateway.createAppData(transferId);
            firstDataStream.write(gson.toJson(migrationDataDTO).getBytes());
            firstDataStream.close();
            LOGGER.info("Retrospectives migration finished with transferId: {}", (Object)transferId);
        }
        catch (Exception e) {
            LOGGER.error("Error uploading files to the cloud", (Throwable)e);
        }
    }

    @Override
    public String getServerAppKey() {
        return "retrospectives4confluence";
    }
}

