/*
 * Decompiled with CFR 0.152.
 */
package com.nearsoft.retrospective.service;

import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUserImpl;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.user.UserKey;
import com.nearsoft.retrospective.model.User;
import com.nearsoft.retrospective.service.SessionDataService;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RetrospectiveUserService {
    private static final Logger LOGGER = Logger.getLogger((String)SessionDataService.class.getName());
    private final UserAccessor _userAccessor;

    @Autowired
    public RetrospectiveUserService(@ComponentImport UserAccessor userAccessor) {
        this._userAccessor = userAccessor;
    }

    public String getCurrentUserKey() {
        ConfluenceUserImpl confluenceUser = this.getConfluenceUser();
        if (confluenceUser == null || confluenceUser.getKey() == null) {
            return null;
        }
        return confluenceUser.getKey().toString();
    }

    public ConfluenceUserImpl getConfluenceUser() {
        ConfluenceUserImpl user = null;
        try {
            user = (ConfluenceUserImpl)AuthenticatedUserThreadLocal.get();
        }
        catch (NullPointerException npe) {
            LOGGER.warn((Object)"Couldn't get user from authenticated thread");
        }
        return user;
    }

    public User makeRetrospectiveUser(ConfluenceUserImpl confluenceUser) {
        UserKey userKey;
        if (confluenceUser == null) {
            return null;
        }
        try {
            userKey = confluenceUser.getKey();
        }
        catch (Exception e) {
            return null;
        }
        if (userKey == null) {
            return null;
        }
        String key = userKey.getStringValue();
        String name = confluenceUser.getName();
        String fullName = confluenceUser.getFullName();
        String profilePicture = "";
        try {
            profilePicture = this._userAccessor.getUserProfilePicture(confluenceUser.getBackingUser()).getDownloadPath();
        }
        catch (NullPointerException npe) {
            LOGGER.warn((Object)"Error getting user profile picture");
            LOGGER.warn((Object)npe.getMessage());
        }
        return new User(key, name, fullName, profilePicture);
    }

    public User getValidUserFromUserKey(String userKey) {
        ConfluenceUserImpl confluenceUser;
        if (userKey == null || userKey.trim().isEmpty()) {
            return null;
        }
        try {
            confluenceUser = (ConfluenceUserImpl)this._userAccessor.getExistingUserByKey(new UserKey(userKey));
        }
        catch (Exception e) {
            return null;
        }
        if (confluenceUser == null) {
            return null;
        }
        return this.makeRetrospectiveUser(confluenceUser);
    }
}

