/*
 * Decompiled with CFR 0.152.
 */
package com.nearsoft.retrospective.exception;

import com.google.gson.Gson;
import com.nearsoft.retrospective.dto.ErrorResponse;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.apache.log4j.Logger;

@Provider
public class GenericExceptionMapper
implements ExceptionMapper<Exception> {
    private static final Gson GSON = new Gson();
    private static final Logger LOGGER = Logger.getLogger(GenericExceptionMapper.class);
    private static final String INTERNAL_SERVER_ERROR_MESSAGE = "An internal server error has occurred, please try again later or contact Catapult Labs team for support.";

    public Response toResponse(Exception exception) {
        LOGGER.error((Object)INTERNAL_SERVER_ERROR_MESSAGE, (Throwable)exception);
        ErrorResponse response = new ErrorResponse();
        response.setMessage(INTERNAL_SERVER_ERROR_MESSAGE);
        return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)GSON.toJson(response)).build();
    }
}

