(function (angular) {
  angular.module("retrospectiveApp").service("UtilService", UtilService);

  function UtilService() {
    const flatten = (arr) =>
      arr.reduce(
        (acc, val) =>
          val ? acc.concat(Array.isArray(val) ? flatten(val) : val) : acc,
        []
      );

    const decodeHTML = (data) => {
      if (!data) {
        return data;
      }

      data = data.replace(/&#60;/g, "<");
      data = data.replace(/&#62;/g, ">");
      data = data.replace(/&#38;/g, "&");
      data = data.replace(/&#35;/g, "#")
      return data;
    };

    const encodeHTML = (data) => {
      if (!data) {
        return "";
      }

      return data
          .replaceAll("&", "&#38;")
          .replaceAll("<", "&#60;")
          .replaceAll(">", "&#62;");
    };

    return {
      flatten,
      decodeHTML,
      encodeHTML
    };
  }
})(angular);
