const webpack = require("webpack");
const WebpackShellPlugin = require('webpack-shell-plugin');
const WebpackCleanPlugin = require('clean-webpack-plugin');
const path = require('path');

module.exports = (env) => {
    const getPlugins = () => {
        const cleanOptions = {
            root: path.resolve(__dirname, '../'),
            verbose: true,
            dry: false,
            name: 'clean'
        };

        const plugins = [
            new WebpackCleanPlugin(['build'], cleanOptions),
            new webpack.optimize.CommonsChunkPlugin({ name: 'vendor', filename: 'vendor.js', minChunks: Infinity }),
            new webpack.optimize.CommonsChunkPlugin({ name: 'common', filename: 'common.js', minChunks: Infinity }),
        ];

        if (!env.prod && env.watch) {
            plugins.push(new WebpackShellPlugin({ dev: false }));
        }
        return plugins;
    };

    return {
        entry: {
            "vendor-rte": ['angular', 'angular-route'],
            "app-rte": './src/main/resources/app-rte/index.ts'
        },
        output: {
            filename: '[name].js',
            path: path.resolve(__dirname, '../build')
        },

        devtool: 'source-map',

        resolve: {
            extensions: ['.ts', '.js', '.json']
        },

        module: {
            rules: [
                { test: /\.ts?$/, loader: "awesome-typescript-loader", exclude: /node_modules/ },
                { enforce: "pre", test: /\.js$/, loader: 'source-map-loader' },
                { test: /\.html$/, use: [{ loader: 'html-loader', options: { minimize: true } }] },
                { test: /\.css$/, use: ['style-loader', 'css-loader'], exclude: /node_modules/ },
                { test: /\.jpg$/, use: [ "file-loader" ] },
                { test: /\.png$/, use: [ "url-loader?mimetype=image/png" ] }
            ]
        },

        plugins: getPlugins()
    };
};