(function (angular) {
    angular
        .module('retrospectiveApp')
        .service('UserService', UserService);

    UserService.$inject = ['WorkflowService', 'StatefulService', 'HTTP_PATH', '$http'];

    function UserService(WorkflowService, Stateful, HTTP_PATH, $http) {
        Stateful.make(this);

        /*
            subscribe to events to always get the newest state
         */
        WorkflowService.subscribe((event) => {
            this.state.set('participants', event.state.participants);
        }, ['participants']);

        WorkflowService.subscribe((event) => {
            this.state.set('moderator', event.state.moderator);
        }, ['moderator']);

        // TODO rename to getParticipants
        this.getUserList = () => this.state.get('participants');

        this.getModerator = () => this.state.get('moderator');

        this.getUserByUserKey = (userKey) => this.state.get('participants', []).find(p=> p.userKey === userKey);

        // TODO rename to something related with a number
        this.getReadyUsers = () => this.state.get('participants').filter(p => p.isReady).length;

        this.getBaseUrl = () => {
            const baseUrl = window.location.origin + window.location.pathname;
            let indexString = baseUrl.indexOf('/plugins/')

            if (indexString >= 0) {
                return baseUrl.substring(0, indexString);
            } else {
                return window.location.origin
            }
        }

        this.getUsersBySearch = async (search) =>  {
            try {
                const url = this.getBaseUrl()
                const {data} = await $http({
                    method: 'GET',
                    url: `${url}/rest/api/search`,
                    headers: {
                        'X-Atlassian-Token': 'no-check',
                        'Content-Type': 'application/json'
                    },
                    params: {
                        cql: `type=user AND user~"${search}*"`,
                        limit: 10,
                        start: 0
                    }
                })
                const {results} = data
                const finalUsersPromises = results.map(async ({user}) => {
                    return await $http({
                        method: 'GET',
                        url: `${user._links.self}`,
                        headers: {
                            'X-Atlassian-Token': 'no-check',
                            'Content-Type': 'application/json'
                        },
                    })
                })
                const confluencesUsers = await Promise.all(finalUsersPromises)
                return confluencesUsers.map(({data}) => ({
                    // we remove confluence/ prefix for imageUri
                    imageUri: this.getImageUrl(data.profilePicture.path),
                    fullName: data.displayName,
                    name: data.username,
                    userKey: data.userKey
                }))
            }catch (error) {
                console.log(error.message);
            }
        }

        this.getImageUrl = (url) => {
            if (url.indexOf('/confluence/') >= 0) {
                return url.replace('/confluence', '')
            } else {
                return url
            }
        }


    }
}(angular));